<?php

namespace LewisLarsen\Ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetSellingManagerTemplateAutomationRuleResponseType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains the set of automation rules associated with the specified template.
 * @subpackage Structs
 */
class SetSellingManagerTemplateAutomationRuleResponseType extends AbstractResponseType
{
    /**
     * The AutomatedListingRule
     * Meta information extracted from the WSDL
     * - documentation: Contains the automated listing rule associated with this template.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\SellingManagerAutoListType
     */
    public $AutomatedListingRule;
    /**
     * The AutomatedRelistingRule
     * Meta information extracted from the WSDL
     * - documentation: Contains the automated relisting rule associated with this template.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\SellingManagerAutoRelistType
     */
    public $AutomatedRelistingRule;
    /**
     * The AutomatedSecondChanceOfferRule
     * Meta information extracted from the WSDL
     * - documentation: Contains the automated Second Chance Offer rule associated with this template.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\SellingManagerAutoSecondChanceOfferType
     */
    public $AutomatedSecondChanceOfferRule;
    /**
     * The Fees
     * Meta information extracted from the WSDL
     * - documentation: Contains fees that may be incurred when items are listed using the automation rules (e.g., a scheduled listing fee). Use of an automation rule does not in itself have a fee, but use can result in a fee.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\FeesType
     */
    public $Fees;
    /**
     * Constructor method for SetSellingManagerTemplateAutomationRuleResponseType
     * @uses SetSellingManagerTemplateAutomationRuleResponseType::setAutomatedListingRule()
     * @uses SetSellingManagerTemplateAutomationRuleResponseType::setAutomatedRelistingRule()
     * @uses SetSellingManagerTemplateAutomationRuleResponseType::setAutomatedSecondChanceOfferRule()
     * @uses SetSellingManagerTemplateAutomationRuleResponseType::setFees()
     * @param \LewisLarsen\Ebay\StructType\SellingManagerAutoListType $automatedListingRule
     * @param \LewisLarsen\Ebay\StructType\SellingManagerAutoRelistType $automatedRelistingRule
     * @param \LewisLarsen\Ebay\StructType\SellingManagerAutoSecondChanceOfferType $automatedSecondChanceOfferRule
     * @param \LewisLarsen\Ebay\StructType\FeesType $fees
     */
    public function __construct(\LewisLarsen\Ebay\StructType\SellingManagerAutoListType $automatedListingRule = null, \LewisLarsen\Ebay\StructType\SellingManagerAutoRelistType $automatedRelistingRule = null, \LewisLarsen\Ebay\StructType\SellingManagerAutoSecondChanceOfferType $automatedSecondChanceOfferRule = null, \LewisLarsen\Ebay\StructType\FeesType $fees = null)
    {
        $this
            ->setAutomatedListingRule($automatedListingRule)
            ->setAutomatedRelistingRule($automatedRelistingRule)
            ->setAutomatedSecondChanceOfferRule($automatedSecondChanceOfferRule)
            ->setFees($fees);
    }
    /**
     * Get AutomatedListingRule value
     * @return \LewisLarsen\Ebay\StructType\SellingManagerAutoListType|null
     */
    public function getAutomatedListingRule()
    {
        return $this->AutomatedListingRule;
    }
    /**
     * Set AutomatedListingRule value
     * @param \LewisLarsen\Ebay\StructType\SellingManagerAutoListType $automatedListingRule
     * @return \LewisLarsen\Ebay\StructType\SetSellingManagerTemplateAutomationRuleResponseType
     */
    public function setAutomatedListingRule(\LewisLarsen\Ebay\StructType\SellingManagerAutoListType $automatedListingRule = null)
    {
        $this->AutomatedListingRule = $automatedListingRule;
        return $this;
    }
    /**
     * Get AutomatedRelistingRule value
     * @return \LewisLarsen\Ebay\StructType\SellingManagerAutoRelistType|null
     */
    public function getAutomatedRelistingRule()
    {
        return $this->AutomatedRelistingRule;
    }
    /**
     * Set AutomatedRelistingRule value
     * @param \LewisLarsen\Ebay\StructType\SellingManagerAutoRelistType $automatedRelistingRule
     * @return \LewisLarsen\Ebay\StructType\SetSellingManagerTemplateAutomationRuleResponseType
     */
    public function setAutomatedRelistingRule(\LewisLarsen\Ebay\StructType\SellingManagerAutoRelistType $automatedRelistingRule = null)
    {
        $this->AutomatedRelistingRule = $automatedRelistingRule;
        return $this;
    }
    /**
     * Get AutomatedSecondChanceOfferRule value
     * @return \LewisLarsen\Ebay\StructType\SellingManagerAutoSecondChanceOfferType|null
     */
    public function getAutomatedSecondChanceOfferRule()
    {
        return $this->AutomatedSecondChanceOfferRule;
    }
    /**
     * Set AutomatedSecondChanceOfferRule value
     * @param \LewisLarsen\Ebay\StructType\SellingManagerAutoSecondChanceOfferType $automatedSecondChanceOfferRule
     * @return \LewisLarsen\Ebay\StructType\SetSellingManagerTemplateAutomationRuleResponseType
     */
    public function setAutomatedSecondChanceOfferRule(\LewisLarsen\Ebay\StructType\SellingManagerAutoSecondChanceOfferType $automatedSecondChanceOfferRule = null)
    {
        $this->AutomatedSecondChanceOfferRule = $automatedSecondChanceOfferRule;
        return $this;
    }
    /**
     * Get Fees value
     * @return \LewisLarsen\Ebay\StructType\FeesType|null
     */
    public function getFees()
    {
        return $this->Fees;
    }
    /**
     * Set Fees value
     * @param \LewisLarsen\Ebay\StructType\FeesType $fees
     * @return \LewisLarsen\Ebay\StructType\SetSellingManagerTemplateAutomationRuleResponseType
     */
    public function setFees(\LewisLarsen\Ebay\StructType\FeesType $fees = null)
    {
        $this->Fees = $fees;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \LewisLarsen\Ebay\StructType\SetSellingManagerTemplateAutomationRuleResponseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
