<?php

namespace LewisLarsen\Ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductSafetyType StructType
 * Meta information extracted from the WSDL
 * - documentation: Type defining the <b>Pictograms</b> and <b>Statements</b> containers, and the <b>Component</b> field, that provide product safety and compliance related information. <br /> <span class="tablenote"><b>Note: </b> As a part of General
 * Product Safety Regulation (GPSR) requirements effective on December 13th, 2024, sellers sellers operating in, or shipping to, EU-based countries or Northern Ireland are conditionally required to provide product safety and compliance information in
 * their eBay listings. For more information on GPSR, see <a href = "https://www.ebay.com/sellercenter/resources/general-product-safety-regulation" target="_blank">General Product Safety Regulation (GPSR)</a>.</span>
 * @subpackage Structs
 */
class ProductSafetyType extends AbstractStructBase
{
    /**
     * The Pictograms
     * Meta information extracted from the WSDL
     * - documentation: This container is used by the seller to provide product safety pictograms for the listing. This field is conditionally required if product safety information is supplied. <br /> <span class="tablenote"><b>Note:</b> When supplying
     * product safety information, one of the following elements is required: <b>Pictograms</b> or <b>Statements</b>. Both elements can be included on a listing, but only one is required.</span> A maximum of 2 pictograms are allowed for product safety.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\PictogramsType
     */
    public $Pictograms;
    /**
     * The Statements
     * Meta information extracted from the WSDL
     * - documentation: This container is used by the seller to provide product safety statements for the listing. This field is conditionally required if product safety information is supplied. <br /> <span class="tablenote"><b>Note:</b> When supplying
     * product safety information, one of the following elements is required: <b>Pictograms</b> or <b>Statements</b>. Both elements can be included on a listing, but only one is required.</span> A maximum of 8 statements are allowed for product safety.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\StatementsType
     */
    public $Statements;
    /**
     * The Component
     * Meta information extracted from the WSDL
     * - documentation: This field is used by the seller to provide product safety component information for the listing. For example, component information can include specific warnings related to product safety, such as 'Tipping hazard'. This field is
     * optional for Product Safety. <br /> <span class="tablenote"><b>Note: </b> Component information can only be specified if used with the <b>Pictograms</b> and/or <b>Statements</b> field; if the component is provided without one or both of these fields,
     * an error will occur. </span>
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Component;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for ProductSafetyType
     * @uses ProductSafetyType::setPictograms()
     * @uses ProductSafetyType::setStatements()
     * @uses ProductSafetyType::setComponent()
     * @uses ProductSafetyType::setAny()
     * @param \LewisLarsen\Ebay\StructType\PictogramsType $pictograms
     * @param \LewisLarsen\Ebay\StructType\StatementsType $statements
     * @param string $component
     * @param \DOMDocument $any
     */
    public function __construct(\LewisLarsen\Ebay\StructType\PictogramsType $pictograms = null, \LewisLarsen\Ebay\StructType\StatementsType $statements = null, $component = null, \DOMDocument $any = null)
    {
        $this
            ->setPictograms($pictograms)
            ->setStatements($statements)
            ->setComponent($component)
            ->setAny($any);
    }
    /**
     * Get Pictograms value
     * @return \LewisLarsen\Ebay\StructType\PictogramsType|null
     */
    public function getPictograms()
    {
        return $this->Pictograms;
    }
    /**
     * Set Pictograms value
     * @param \LewisLarsen\Ebay\StructType\PictogramsType $pictograms
     * @return \LewisLarsen\Ebay\StructType\ProductSafetyType
     */
    public function setPictograms(\LewisLarsen\Ebay\StructType\PictogramsType $pictograms = null)
    {
        $this->Pictograms = $pictograms;
        return $this;
    }
    /**
     * Get Statements value
     * @return \LewisLarsen\Ebay\StructType\StatementsType|null
     */
    public function getStatements()
    {
        return $this->Statements;
    }
    /**
     * Set Statements value
     * @param \LewisLarsen\Ebay\StructType\StatementsType $statements
     * @return \LewisLarsen\Ebay\StructType\ProductSafetyType
     */
    public function setStatements(\LewisLarsen\Ebay\StructType\StatementsType $statements = null)
    {
        $this->Statements = $statements;
        return $this;
    }
    /**
     * Get Component value
     * @return string|null
     */
    public function getComponent()
    {
        return $this->Component;
    }
    /**
     * Set Component value
     * @param string $component
     * @return \LewisLarsen\Ebay\StructType\ProductSafetyType
     */
    public function setComponent($component = null)
    {
        // validation for constraint: string
        if (!is_null($component) && !is_string($component)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($component, true), gettype($component)), __LINE__);
        }
        $this->Component = $component;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \LewisLarsen\Ebay\StructType\ProductSafetyType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
}
