<?php

namespace LewisLarsen\Ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConfirmIdentityResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: Confirms the identity of the user by returning the <b>UserID</b> and the <b>EIASToken</b> belonging to the user.
 * @subpackage Structs
 */
class ConfirmIdentityResponseType extends AbstractResponseType
{
    /**
     * The UserID
     * Meta information extracted from the WSDL
     * - documentation: Unique eBay user ID for the user. <br><br> <span class="tablenote"><strong>Note:</strong> Effective September 26, 2025, select developers will no longer receive username data for U.S. users through this field. Instead, an immutable
     * user ID will be returned in its place. For more information, please refer to <a href="/api-docs/static/data-handling-update.html" target="_blank">Data Handling Compliance</a>. </span>
     * - minOccurs: 0
     * @var string
     */
    public $UserID;
    /**
     * Constructor method for ConfirmIdentityResponseType
     * @uses ConfirmIdentityResponseType::setUserID()
     * @param string $userID
     */
    public function __construct($userID = null)
    {
        $this
            ->setUserID($userID);
    }
    /**
     * Get UserID value
     * @return string|null
     */
    public function getUserID()
    {
        return $this->UserID;
    }
    /**
     * Set UserID value
     * @param string $userID
     * @return \LewisLarsen\Ebay\StructType\ConfirmIdentityResponseType
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: string
        if (!is_null($userID) && !is_string($userID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userID, true), gettype($userID)), __LINE__);
        }
        $this->UserID = $userID;
        return $this;
    }
}
