<?php

namespace LewisLarsen\Ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentTransactionType StructType
 * Meta information extracted from the WSDL
 * - documentation: This type contains details about the allocation of funds to one payee from a buyer payment for a specified order.
 * @subpackage Structs
 */
class PaymentTransactionType extends AbstractStructBase
{
    /**
     * The Payer
     * Meta information extracted from the WSDL
     * - documentation: This field indicates the eBay user or eBay partner who submitted the payment. <br><br> <span class="tablenote"><strong>Note:</strong> Effective September 26, 2025, select developers will no longer receive username data for U.S. users
     * through this field. Instead, an immutable user ID will be returned in its place. For more information, please refer to <a href="/api-docs/static/data-handling-update.html" target="_blank">Data Handling Compliance</a>. </span> <br><br> <b>For
     * GetOrders and GetItemTransactions only:</b> If using Trading WSDL Version 1019 or above, this field will only be returned to the buyer or seller, and no longer returned at all to third parties. If using a Trading WSDL older than Version 1019, the
     * correct payer is returned to the buyer or seller, but the identity of the payer will be masked to all third parties.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\UserIdentityType
     */
    public $Payer;
    /**
     * The Payee
     * Meta information extracted from the WSDL
     * - documentation: The person or organization who is to receive the payment allocation. <br><br> <span class="tablenote"><strong>Note:</strong> Effective September 26, 2025, select developers will no longer receive username data for U.S. users through
     * this field. Instead, an immutable user ID will be returned in its place. For more information, please refer to <a href="/api-docs/static/data-handling-update.html" target="_blank">Data Handling Compliance</a>. </span>
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\UserIdentityType
     */
    public $Payee;
    /**
     * The PaymentTime
     * Meta information extracted from the WSDL
     * - documentation: The date and time when the payment is received by the payee.
     * - minOccurs: 0
     * @var string
     */
    public $PaymentTime;
    /**
     * The PaymentAmount
     * Meta information extracted from the WSDL
     * - documentation: The amount of the payment that is allocated to the payee.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\AmountType
     */
    public $PaymentAmount;
    /**
     * The ReferenceID
     * Meta information extracted from the WSDL
     * - documentation: A unique transaction ID for the payment. <br/><br/> This field is not returned if the <strong>Payee</strong> field's <strong>type</strong> attribute is <code>eBayPartner</code>. <br><br> <b>For GetOrders and GetItemTransactions
     * only:</b> If using Trading WSDL Version 1019 or above, this field will only be returned to the buyer or seller, and no longer returned at all to third parties. If using a Trading WSDL older than Version 1019, the correct payment identifier is
     * returned to the buyer or seller, but the payment identifier will be masked to all third parties.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\TransactionReferenceType
     */
    public $ReferenceID;
    /**
     * The FeeOrCreditAmount
     * Meta information extracted from the WSDL
     * - documentation: Fee Amount is a positive value and Credit Amount is a negative value. <br/><br/> This field is not returned if the <strong>Payee</strong> field's <strong>type</strong> attribute is <code>eBayPartner</code>.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\AmountType
     */
    public $FeeOrCreditAmount;
    /**
     * The PaymentReferenceID
     * Meta information extracted from the WSDL
     * - documentation: The payment transaction ID. <br/><br/> <b>For GetOrders and GetItemTransactions only:</b> If using Trading WSDL Version 1019 or above, this field will only be returned to the buyer or seller, and no longer returned at all to third
     * parties. If using a Trading WSDL older than Version 1019, the correct payment identifier is returned to the buyer or seller, but the payment identifier will be masked to all third parties.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\TransactionReferenceType[]
     */
    public $PaymentReferenceID;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for PaymentTransactionType
     * @uses PaymentTransactionType::setPayer()
     * @uses PaymentTransactionType::setPayee()
     * @uses PaymentTransactionType::setPaymentTime()
     * @uses PaymentTransactionType::setPaymentAmount()
     * @uses PaymentTransactionType::setReferenceID()
     * @uses PaymentTransactionType::setFeeOrCreditAmount()
     * @uses PaymentTransactionType::setPaymentReferenceID()
     * @uses PaymentTransactionType::setAny()
     * @param \LewisLarsen\Ebay\StructType\UserIdentityType $payer
     * @param \LewisLarsen\Ebay\StructType\UserIdentityType $payee
     * @param string $paymentTime
     * @param \LewisLarsen\Ebay\StructType\AmountType $paymentAmount
     * @param \LewisLarsen\Ebay\StructType\TransactionReferenceType $referenceID
     * @param \LewisLarsen\Ebay\StructType\AmountType $feeOrCreditAmount
     * @param \LewisLarsen\Ebay\StructType\TransactionReferenceType[] $paymentReferenceID
     * @param \DOMDocument $any
     */
    public function __construct(\LewisLarsen\Ebay\StructType\UserIdentityType $payer = null, \LewisLarsen\Ebay\StructType\UserIdentityType $payee = null, $paymentTime = null, \LewisLarsen\Ebay\StructType\AmountType $paymentAmount = null, \LewisLarsen\Ebay\StructType\TransactionReferenceType $referenceID = null, \LewisLarsen\Ebay\StructType\AmountType $feeOrCreditAmount = null, array $paymentReferenceID = array(), \DOMDocument $any = null)
    {
        $this
            ->setPayer($payer)
            ->setPayee($payee)
            ->setPaymentTime($paymentTime)
            ->setPaymentAmount($paymentAmount)
            ->setReferenceID($referenceID)
            ->setFeeOrCreditAmount($feeOrCreditAmount)
            ->setPaymentReferenceID($paymentReferenceID)
            ->setAny($any);
    }
    /**
     * Get Payer value
     * @return \LewisLarsen\Ebay\StructType\UserIdentityType|null
     */
    public function getPayer()
    {
        return $this->Payer;
    }
    /**
     * Set Payer value
     * @param \LewisLarsen\Ebay\StructType\UserIdentityType $payer
     * @return \LewisLarsen\Ebay\StructType\PaymentTransactionType
     */
    public function setPayer(\LewisLarsen\Ebay\StructType\UserIdentityType $payer = null)
    {
        $this->Payer = $payer;
        return $this;
    }
    /**
     * Get Payee value
     * @return \LewisLarsen\Ebay\StructType\UserIdentityType|null
     */
    public function getPayee()
    {
        return $this->Payee;
    }
    /**
     * Set Payee value
     * @param \LewisLarsen\Ebay\StructType\UserIdentityType $payee
     * @return \LewisLarsen\Ebay\StructType\PaymentTransactionType
     */
    public function setPayee(\LewisLarsen\Ebay\StructType\UserIdentityType $payee = null)
    {
        $this->Payee = $payee;
        return $this;
    }
    /**
     * Get PaymentTime value
     * @return string|null
     */
    public function getPaymentTime()
    {
        return $this->PaymentTime;
    }
    /**
     * Set PaymentTime value
     * @param string $paymentTime
     * @return \LewisLarsen\Ebay\StructType\PaymentTransactionType
     */
    public function setPaymentTime($paymentTime = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTime) && !is_string($paymentTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentTime, true), gettype($paymentTime)), __LINE__);
        }
        $this->PaymentTime = $paymentTime;
        return $this;
    }
    /**
     * Get PaymentAmount value
     * @return \LewisLarsen\Ebay\StructType\AmountType|null
     */
    public function getPaymentAmount()
    {
        return $this->PaymentAmount;
    }
    /**
     * Set PaymentAmount value
     * @param \LewisLarsen\Ebay\StructType\AmountType $paymentAmount
     * @return \LewisLarsen\Ebay\StructType\PaymentTransactionType
     */
    public function setPaymentAmount(\LewisLarsen\Ebay\StructType\AmountType $paymentAmount = null)
    {
        $this->PaymentAmount = $paymentAmount;
        return $this;
    }
    /**
     * Get ReferenceID value
     * @return \LewisLarsen\Ebay\StructType\TransactionReferenceType|null
     */
    public function getReferenceID()
    {
        return $this->ReferenceID;
    }
    /**
     * Set ReferenceID value
     * @param \LewisLarsen\Ebay\StructType\TransactionReferenceType $referenceID
     * @return \LewisLarsen\Ebay\StructType\PaymentTransactionType
     */
    public function setReferenceID(\LewisLarsen\Ebay\StructType\TransactionReferenceType $referenceID = null)
    {
        $this->ReferenceID = $referenceID;
        return $this;
    }
    /**
     * Get FeeOrCreditAmount value
     * @return \LewisLarsen\Ebay\StructType\AmountType|null
     */
    public function getFeeOrCreditAmount()
    {
        return $this->FeeOrCreditAmount;
    }
    /**
     * Set FeeOrCreditAmount value
     * @param \LewisLarsen\Ebay\StructType\AmountType $feeOrCreditAmount
     * @return \LewisLarsen\Ebay\StructType\PaymentTransactionType
     */
    public function setFeeOrCreditAmount(\LewisLarsen\Ebay\StructType\AmountType $feeOrCreditAmount = null)
    {
        $this->FeeOrCreditAmount = $feeOrCreditAmount;
        return $this;
    }
    /**
     * Get PaymentReferenceID value
     * @return \LewisLarsen\Ebay\StructType\TransactionReferenceType[]|null
     */
    public function getPaymentReferenceID()
    {
        return $this->PaymentReferenceID;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentReferenceID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentReferenceID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentReferenceIDForArrayConstraintsFromSetPaymentReferenceID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentTransactionTypePaymentReferenceIDItem) {
            // validation for constraint: itemType
            if (!$paymentTransactionTypePaymentReferenceIDItem instanceof \LewisLarsen\Ebay\StructType\TransactionReferenceType) {
                $invalidValues[] = is_object($paymentTransactionTypePaymentReferenceIDItem) ? get_class($paymentTransactionTypePaymentReferenceIDItem) : sprintf('%s(%s)', gettype($paymentTransactionTypePaymentReferenceIDItem), var_export($paymentTransactionTypePaymentReferenceIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentReferenceID property can only contain items of type \LewisLarsen\Ebay\StructType\TransactionReferenceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentReferenceID value
     * @throws \InvalidArgumentException
     * @param \LewisLarsen\Ebay\StructType\TransactionReferenceType[] $paymentReferenceID
     * @return \LewisLarsen\Ebay\StructType\PaymentTransactionType
     */
    public function setPaymentReferenceID(array $paymentReferenceID = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentReferenceIDArrayErrorMessage = self::validatePaymentReferenceIDForArrayConstraintsFromSetPaymentReferenceID($paymentReferenceID))) {
            throw new \InvalidArgumentException($paymentReferenceIDArrayErrorMessage, __LINE__);
        }
        $this->PaymentReferenceID = $paymentReferenceID;
        return $this;
    }
    /**
     * Add item to PaymentReferenceID value
     * @throws \InvalidArgumentException
     * @param \LewisLarsen\Ebay\StructType\TransactionReferenceType $item
     * @return \LewisLarsen\Ebay\StructType\PaymentTransactionType
     */
    public function addToPaymentReferenceID(\LewisLarsen\Ebay\StructType\TransactionReferenceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \LewisLarsen\Ebay\StructType\TransactionReferenceType) {
            throw new \InvalidArgumentException(sprintf('The PaymentReferenceID property can only contain items of type \LewisLarsen\Ebay\StructType\TransactionReferenceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaymentReferenceID[] = $item;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \LewisLarsen\Ebay\StructType\PaymentTransactionType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
}
