<?php

namespace LewisLarsen\Ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddOrderResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: This type defines the response of an <b>AddOrder</b> call. If the multiple line items are successfully combined into a single order, this response includes the unique identifier of this 'Combined Invoice' order (automatically
 * generated by eBay), and a timestamp indicating when the new order was created.
 * @subpackage Structs
 */
class AddOrderResponseType extends AbstractResponseType
{
    /**
     * The OrderID
     * Meta information extracted from the WSDL
     * - documentation: The unique identifier of the successfully-created 'Combined Invoice' order. This value is only created and returned if the <b>AddOrder</b> call is successful in creating the new order. <br/><br/> This value can be used as an input
     * filter in <b>GetOrders</b> calls to retrieve the 'Combined Invoice' order. <br><br> <span class="tablenote"><b>Note: </b> This unique identifier is not the same as the <b>OrderID</b> that is generated after payment. </span> | Type that represents the
     * unique identifier for an eBay order. The format is a non-parsable string, globally unique across all eBay marketplaces, and consistent for both single line item and multiple line item orders.
     * - base: xs:string
     * - minOccurs: 0
     * @var string
     */
    public $OrderID;
    /**
     * The CreatedTime
     * Meta information extracted from the WSDL
     * - documentation: Timestamp that indicates the date and time that the 'Combined Invoice' order was created.
     * - minOccurs: 0
     * @var string
     */
    public $CreatedTime;
    /**
     * Constructor method for AddOrderResponseType
     * @uses AddOrderResponseType::setOrderID()
     * @uses AddOrderResponseType::setCreatedTime()
     * @param string $orderID
     * @param string $createdTime
     */
    public function __construct($orderID = null, $createdTime = null)
    {
        $this
            ->setOrderID($orderID)
            ->setCreatedTime($createdTime);
    }
    /**
     * Get OrderID value
     * @return string|null
     */
    public function getOrderID()
    {
        return $this->OrderID;
    }
    /**
     * Set OrderID value
     * @param string $orderID
     * @return \LewisLarsen\Ebay\StructType\AddOrderResponseType
     */
    public function setOrderID($orderID = null)
    {
        // validation for constraint: string
        if (!is_null($orderID) && !is_string($orderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderID, true), gettype($orderID)), __LINE__);
        }
        $this->OrderID = $orderID;
        return $this;
    }
    /**
     * Get CreatedTime value
     * @return string|null
     */
    public function getCreatedTime()
    {
        return $this->CreatedTime;
    }
    /**
     * Set CreatedTime value
     * @param string $createdTime
     * @return \LewisLarsen\Ebay\StructType\AddOrderResponseType
     */
    public function setCreatedTime($createdTime = null)
    {
        // validation for constraint: string
        if (!is_null($createdTime) && !is_string($createdTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdTime, true), gettype($createdTime)), __LINE__);
        }
        $this->CreatedTime = $createdTime;
        return $this;
    }
}
