<?php

namespace LewisLarsen\Ebay\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for DescriptionReviseModeCodeType EnumType
 * Meta information extracted from the WSDL
 * - documentation: <span class="tablenote"><span style="color:#004680"><strong>Note: </strong>This field should no longer be used since it no longer supports the ability to append or prepend text using the <b>Append</b> or <b>Prepend</b> values, but
 * only supports the <b>Replace</b> value. If this field is used and set to <b>Append</b> or <b>Prepend</b>, it will default to <b>Replace</b>, and whatever text is supplied in the <b>Item.Description</b> field will completely overwrite the current
 * description for the active listing. If you wish to update the description for an active listing using a revise call, just provide the full description in the <b>Item.Description</b> field and do not use this field at all. This field will be
 * completely removed from the WSDL within a few months.</span><br/><br/> <p>Enumerated type containing the list of values that can be used when revising the item description of an active listing through the Revise API calls.</p>
 * @subpackage Enumerations
 */
class DescriptionReviseModeCodeType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Replace'
     * Meta information extracted from the WSDL
     * - documentation: Use this value in the <b>Item.DescriptionReviseMode</b> field if you want to completely replace (overwrite) the item description of the active listing.
     * @return string 'Replace'
     */
    const VALUE_REPLACE = 'Replace';
    /**
     * Constant for value 'Prepend'
     * Meta information extracted from the WSDL
     * - documentation: <span class="tablenote"><b>Note: </b> This enumerated value has been deprecated. </span>
     * @return string 'Prepend'
     */
    const VALUE_PREPEND = 'Prepend';
    /**
     * Constant for value 'Append'
     * Meta information extracted from the WSDL
     * - documentation: <span class="tablenote"><b>Note: </b> This enumerated value has been deprecated. </span>
     * @return string 'Append'
     */
    const VALUE_APPEND = 'Append';
    /**
     * Constant for value 'CustomCode'
     * Meta information extracted from the WSDL
     * - documentation: <span class="tablenote"><b>Note: </b> This enumerated value has been deprecated. </span>
     * @return string 'CustomCode'
     */
    const VALUE_CUSTOM_CODE = 'CustomCode';
    /**
     * Return allowed values
     * @uses self::VALUE_REPLACE
     * @uses self::VALUE_PREPEND
     * @uses self::VALUE_APPEND
     * @uses self::VALUE_CUSTOM_CODE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_REPLACE,
            self::VALUE_PREPEND,
            self::VALUE_APPEND,
            self::VALUE_CUSTOM_CODE,
        );
    }
}
