<?php

namespace LewisLarsen\Ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResponsiblePersonCodeTypes StructType
 * Meta information extracted from the WSDL
 * - documentation: Container for collection of possible responsible person enumerations.
 * @subpackage Structs
 */
class ResponsiblePersonCodeTypes extends AbstractStructBase
{
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - documentation: The type of Responsible Person associated with the listing. <br /> <span class="tablenote"><b>Note: </b> Currently, the only supported value is <code>EUResponsiblePerson</code>.</span>
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var string[]
     */
    public $Type;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for ResponsiblePersonCodeTypes
     * @uses ResponsiblePersonCodeTypes::setType()
     * @uses ResponsiblePersonCodeTypes::setAny()
     * @param string[] $type
     * @param \DOMDocument $any
     */
    public function __construct(array $type = array(), \DOMDocument $any = null)
    {
        $this
            ->setType($type)
            ->setAny($any);
    }
    /**
     * Get Type value
     * @return string[]
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * This method is responsible for validating the values passed to the setType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTypeForArrayConstraintsFromSetType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $responsiblePersonCodeTypesTypeItem) {
            // validation for constraint: enumeration
            if (!\LewisLarsen\Ebay\EnumType\ResponsiblePersonCodeType::valueIsValid($responsiblePersonCodeTypesTypeItem)) {
                $invalidValues[] = is_object($responsiblePersonCodeTypesTypeItem) ? get_class($responsiblePersonCodeTypesTypeItem) : sprintf('%s(%s)', gettype($responsiblePersonCodeTypesTypeItem), var_export($responsiblePersonCodeTypesTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \LewisLarsen\Ebay\EnumType\ResponsiblePersonCodeType', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \LewisLarsen\Ebay\EnumType\ResponsiblePersonCodeType::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Type value
     * @uses \LewisLarsen\Ebay\EnumType\ResponsiblePersonCodeType::valueIsValid()
     * @uses \LewisLarsen\Ebay\EnumType\ResponsiblePersonCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $type
     * @return \LewisLarsen\Ebay\StructType\ResponsiblePersonCodeTypes
     */
    public function setType(array $type = array())
    {
        // validation for constraint: array
        if ('' !== ($typeArrayErrorMessage = self::validateTypeForArrayConstraintsFromSetType($type))) {
            throw new \InvalidArgumentException($typeArrayErrorMessage, __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Add item to Type value
     * @uses \LewisLarsen\Ebay\EnumType\ResponsiblePersonCodeType::valueIsValid()
     * @uses \LewisLarsen\Ebay\EnumType\ResponsiblePersonCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \LewisLarsen\Ebay\StructType\ResponsiblePersonCodeTypes
     */
    public function addToType($item)
    {
        // validation for constraint: enumeration
        if (!\LewisLarsen\Ebay\EnumType\ResponsiblePersonCodeType::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \LewisLarsen\Ebay\EnumType\ResponsiblePersonCodeType', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \LewisLarsen\Ebay\EnumType\ResponsiblePersonCodeType::getValidValues())), __LINE__);
        }
        $this->Type[] = $item;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \LewisLarsen\Ebay\StructType\ResponsiblePersonCodeTypes
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
}
