<?php

namespace LewisLarsen\Ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxDetailsType StructType
 * Meta information extracted from the WSDL
 * - documentation: Type used by the <b>TaxDetails</b> container, which consists of detailed tax information for an order line item, including the tax type and description, tax on the item cost, and tax related to shipping and handling. The information
 * in this container supercedes/overrides the sales tax information in the <b>ShippingDetails.SalesTax</b> container (if returned). <br><br> A separate <b>TaxDetails</b> container will be returned for each type of tax that applied to an order line item.
 * For tax that is subject to 'eBay collect and remit', such as US sales tax or 'Goods and Services tax' for Australia or New Zealand, the <b>TaxDetails</b> container will be returned under the <b>eBayCollectAndRemitTaxes</b> container. For all other
 * tax, the tax details will be returned under the <b>Taxes</b> container.
 * @subpackage Structs
 */
class TaxDetailsType extends AbstractStructBase
{
    /**
     * The Imposition
     * Meta information extracted from the WSDL
     * - documentation: This field indicates the tax type. A separate <b>TaxDetails</b> container is returned for each unique imposition (tax type).
     * - minOccurs: 0
     * @var string
     */
    public $Imposition;
    /**
     * The TaxDescription
     * Meta information extracted from the WSDL
     * - documentation: This enumeration value indicates the type of tax charged against the item.
     * - minOccurs: 0
     * @var string
     */
    public $TaxDescription;
    /**
     * The TaxAmount
     * Meta information extracted from the WSDL
     * - documentation: This value is the total amount of tax charges for the order line item for the corresponding tax type (see <b>Imposition</b> value), and includes taxes that are applied against the <a
     * href="https://www.ebay.co.uk/help/buying/paying-items/buyer-protection-fee?id=5594" target="_blank">Buyer Protection fee</a>. <br><br> <b>TaxAmount</b> = <b>TaxOnSubtotalAmount</b> + <b>TaxOnShippingAmount</b> + <b>TaxOnHandlingAmount</b> + the tax
     * on the <a href="https://www.ebay.co.uk/help/buying/paying-items/buyer-protection-fee?id=5594" target="_blank">Buyer Protection fee</a>
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\AmountType
     */
    public $TaxAmount;
    /**
     * The TaxOnSubtotalAmount
     * Meta information extracted from the WSDL
     * - documentation: This value is the amount of sales tax applied based on the unit cost of the order line item for the corresponding imposition (tax type) and includes taxes that are applied against the <a
     * href="https://www.ebay.co.uk/help/buying/paying-items/buyer-protection-fee?id=5594" target="_blank">Buyer Protection fee</a>.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\AmountType
     */
    public $TaxOnSubtotalAmount;
    /**
     * The TaxOnShippingAmount
     * Meta information extracted from the WSDL
     * - documentation: This value is the amount of sales tax applied based on shipping costs for the order line item for the corresponding impositiion (tax type).
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\AmountType
     */
    public $TaxOnShippingAmount;
    /**
     * The TaxOnHandlingAmount
     * Meta information extracted from the WSDL
     * - documentation: This value is the amount of sales tax applied based on handling costs for the order line item for the corresponding impositiion (tax type).
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\AmountType
     */
    public $TaxOnHandlingAmount;
    /**
     * The TaxCode
     * Meta information extracted from the WSDL
     * - documentation: This value is the actual tax ID for the buyer. This field will generally only be returned if a seller on the Italy or Spain sites required that the buyer supply a tax ID during the checkout process. If the
     * <b>Order.BuyerTaxIdentifier</b> container is returned, the type of tax ID can be found in the <b>BuyerTaxIdentifier.Type</b> field.
     * - minOccurs: 0
     * @var string
     */
    public $TaxCode;
    /**
     * The CollectionMethod
     * Meta information extracted from the WSDL
     * - documentation: This field indicates the collection method used to collect the 'eBay Collect and Remit' or 'Good and Services' tax for the order. This field is always returned for orders subject to 'Collect and Remit' or 'Good and Services' tax, and
     * its value is always <code>NET</code>. <br> <br> <span class="tablenote"><b>Note: </b> Although the <b>CollectionMethod</b> field is returned for all orders subject to 'Collect and Remit' sales tax or 'Good and Services' tax, the
     * <b>CollectionMethod</b> field and <b>CollectionMethodCodeType</b> are not currently of any practical use, although this field may have use in the future. If and when the logic of this field is changed, this note will be updated and a note will also
     * be added to the Release Notes. </span>
     * - minOccurs: 0
     * @var string
     */
    public $CollectionMethod;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for TaxDetailsType
     * @uses TaxDetailsType::setImposition()
     * @uses TaxDetailsType::setTaxDescription()
     * @uses TaxDetailsType::setTaxAmount()
     * @uses TaxDetailsType::setTaxOnSubtotalAmount()
     * @uses TaxDetailsType::setTaxOnShippingAmount()
     * @uses TaxDetailsType::setTaxOnHandlingAmount()
     * @uses TaxDetailsType::setTaxCode()
     * @uses TaxDetailsType::setCollectionMethod()
     * @uses TaxDetailsType::setAny()
     * @param string $imposition
     * @param string $taxDescription
     * @param \LewisLarsen\Ebay\StructType\AmountType $taxAmount
     * @param \LewisLarsen\Ebay\StructType\AmountType $taxOnSubtotalAmount
     * @param \LewisLarsen\Ebay\StructType\AmountType $taxOnShippingAmount
     * @param \LewisLarsen\Ebay\StructType\AmountType $taxOnHandlingAmount
     * @param string $taxCode
     * @param string $collectionMethod
     * @param \DOMDocument $any
     */
    public function __construct($imposition = null, $taxDescription = null, \LewisLarsen\Ebay\StructType\AmountType $taxAmount = null, \LewisLarsen\Ebay\StructType\AmountType $taxOnSubtotalAmount = null, \LewisLarsen\Ebay\StructType\AmountType $taxOnShippingAmount = null, \LewisLarsen\Ebay\StructType\AmountType $taxOnHandlingAmount = null, $taxCode = null, $collectionMethod = null, \DOMDocument $any = null)
    {
        $this
            ->setImposition($imposition)
            ->setTaxDescription($taxDescription)
            ->setTaxAmount($taxAmount)
            ->setTaxOnSubtotalAmount($taxOnSubtotalAmount)
            ->setTaxOnShippingAmount($taxOnShippingAmount)
            ->setTaxOnHandlingAmount($taxOnHandlingAmount)
            ->setTaxCode($taxCode)
            ->setCollectionMethod($collectionMethod)
            ->setAny($any);
    }
    /**
     * Get Imposition value
     * @return string|null
     */
    public function getImposition()
    {
        return $this->Imposition;
    }
    /**
     * Set Imposition value
     * @uses \LewisLarsen\Ebay\EnumType\TaxTypeCodeType::valueIsValid()
     * @uses \LewisLarsen\Ebay\EnumType\TaxTypeCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $imposition
     * @return \LewisLarsen\Ebay\StructType\TaxDetailsType
     */
    public function setImposition($imposition = null)
    {
        // validation for constraint: enumeration
        if (!\LewisLarsen\Ebay\EnumType\TaxTypeCodeType::valueIsValid($imposition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \LewisLarsen\Ebay\EnumType\TaxTypeCodeType', is_array($imposition) ? implode(', ', $imposition) : var_export($imposition, true), implode(', ', \LewisLarsen\Ebay\EnumType\TaxTypeCodeType::getValidValues())), __LINE__);
        }
        $this->Imposition = $imposition;
        return $this;
    }
    /**
     * Get TaxDescription value
     * @return string|null
     */
    public function getTaxDescription()
    {
        return $this->TaxDescription;
    }
    /**
     * Set TaxDescription value
     * @uses \LewisLarsen\Ebay\EnumType\TaxDescriptionCodeType::valueIsValid()
     * @uses \LewisLarsen\Ebay\EnumType\TaxDescriptionCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $taxDescription
     * @return \LewisLarsen\Ebay\StructType\TaxDetailsType
     */
    public function setTaxDescription($taxDescription = null)
    {
        // validation for constraint: enumeration
        if (!\LewisLarsen\Ebay\EnumType\TaxDescriptionCodeType::valueIsValid($taxDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \LewisLarsen\Ebay\EnumType\TaxDescriptionCodeType', is_array($taxDescription) ? implode(', ', $taxDescription) : var_export($taxDescription, true), implode(', ', \LewisLarsen\Ebay\EnumType\TaxDescriptionCodeType::getValidValues())), __LINE__);
        }
        $this->TaxDescription = $taxDescription;
        return $this;
    }
    /**
     * Get TaxAmount value
     * @return \LewisLarsen\Ebay\StructType\AmountType|null
     */
    public function getTaxAmount()
    {
        return $this->TaxAmount;
    }
    /**
     * Set TaxAmount value
     * @param \LewisLarsen\Ebay\StructType\AmountType $taxAmount
     * @return \LewisLarsen\Ebay\StructType\TaxDetailsType
     */
    public function setTaxAmount(\LewisLarsen\Ebay\StructType\AmountType $taxAmount = null)
    {
        $this->TaxAmount = $taxAmount;
        return $this;
    }
    /**
     * Get TaxOnSubtotalAmount value
     * @return \LewisLarsen\Ebay\StructType\AmountType|null
     */
    public function getTaxOnSubtotalAmount()
    {
        return $this->TaxOnSubtotalAmount;
    }
    /**
     * Set TaxOnSubtotalAmount value
     * @param \LewisLarsen\Ebay\StructType\AmountType $taxOnSubtotalAmount
     * @return \LewisLarsen\Ebay\StructType\TaxDetailsType
     */
    public function setTaxOnSubtotalAmount(\LewisLarsen\Ebay\StructType\AmountType $taxOnSubtotalAmount = null)
    {
        $this->TaxOnSubtotalAmount = $taxOnSubtotalAmount;
        return $this;
    }
    /**
     * Get TaxOnShippingAmount value
     * @return \LewisLarsen\Ebay\StructType\AmountType|null
     */
    public function getTaxOnShippingAmount()
    {
        return $this->TaxOnShippingAmount;
    }
    /**
     * Set TaxOnShippingAmount value
     * @param \LewisLarsen\Ebay\StructType\AmountType $taxOnShippingAmount
     * @return \LewisLarsen\Ebay\StructType\TaxDetailsType
     */
    public function setTaxOnShippingAmount(\LewisLarsen\Ebay\StructType\AmountType $taxOnShippingAmount = null)
    {
        $this->TaxOnShippingAmount = $taxOnShippingAmount;
        return $this;
    }
    /**
     * Get TaxOnHandlingAmount value
     * @return \LewisLarsen\Ebay\StructType\AmountType|null
     */
    public function getTaxOnHandlingAmount()
    {
        return $this->TaxOnHandlingAmount;
    }
    /**
     * Set TaxOnHandlingAmount value
     * @param \LewisLarsen\Ebay\StructType\AmountType $taxOnHandlingAmount
     * @return \LewisLarsen\Ebay\StructType\TaxDetailsType
     */
    public function setTaxOnHandlingAmount(\LewisLarsen\Ebay\StructType\AmountType $taxOnHandlingAmount = null)
    {
        $this->TaxOnHandlingAmount = $taxOnHandlingAmount;
        return $this;
    }
    /**
     * Get TaxCode value
     * @return string|null
     */
    public function getTaxCode()
    {
        return $this->TaxCode;
    }
    /**
     * Set TaxCode value
     * @param string $taxCode
     * @return \LewisLarsen\Ebay\StructType\TaxDetailsType
     */
    public function setTaxCode($taxCode = null)
    {
        // validation for constraint: string
        if (!is_null($taxCode) && !is_string($taxCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxCode, true), gettype($taxCode)), __LINE__);
        }
        $this->TaxCode = $taxCode;
        return $this;
    }
    /**
     * Get CollectionMethod value
     * @return string|null
     */
    public function getCollectionMethod()
    {
        return $this->CollectionMethod;
    }
    /**
     * Set CollectionMethod value
     * @uses \LewisLarsen\Ebay\EnumType\CollectionMethodCodeType::valueIsValid()
     * @uses \LewisLarsen\Ebay\EnumType\CollectionMethodCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $collectionMethod
     * @return \LewisLarsen\Ebay\StructType\TaxDetailsType
     */
    public function setCollectionMethod($collectionMethod = null)
    {
        // validation for constraint: enumeration
        if (!\LewisLarsen\Ebay\EnumType\CollectionMethodCodeType::valueIsValid($collectionMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \LewisLarsen\Ebay\EnumType\CollectionMethodCodeType', is_array($collectionMethod) ? implode(', ', $collectionMethod) : var_export($collectionMethod, true), implode(', ', \LewisLarsen\Ebay\EnumType\CollectionMethodCodeType::getValidValues())), __LINE__);
        }
        $this->CollectionMethod = $collectionMethod;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \LewisLarsen\Ebay\StructType\TaxDetailsType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
}
