<?php

namespace LewisLarsen\Ebay\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for End ServiceType
 * @subpackage Services
 */
class End extends AbstractSoapClientBase
{
    /**
     * Sets the RequesterCredentials SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \LewisLarsen\Ebay\StructType\CustomSecurityHeaderType $requesterCredentials
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderRequesterCredentials(\LewisLarsen\Ebay\StructType\CustomSecurityHeaderType $requesterCredentials, $nameSpace = 'urn:ebay:apis:eBLBaseComponents', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'RequesterCredentials', $requesterCredentials, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named EndFixedPriceItem
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \LewisLarsen\Ebay\StructType\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LewisLarsen\Ebay\StructType\EndFixedPriceItemRequestType $endFixedPriceItemRequest
     * @return \LewisLarsen\Ebay\StructType\EndFixedPriceItemResponseType|bool
     */
    public function EndFixedPriceItem(\LewisLarsen\Ebay\StructType\EndFixedPriceItemRequestType $endFixedPriceItemRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->EndFixedPriceItem($endFixedPriceItemRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EndItem
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \LewisLarsen\Ebay\StructType\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LewisLarsen\Ebay\StructType\EndItemRequestType $endItemRequest
     * @return \LewisLarsen\Ebay\StructType\EndItemResponseType|bool
     */
    public function EndItem(\LewisLarsen\Ebay\StructType\EndItemRequestType $endItemRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->EndItem($endItemRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EndItems
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequesterCredentials
     * - SOAPHeaderNamespaces: urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes: \LewisLarsen\Ebay\StructType\CustomSecurityHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LewisLarsen\Ebay\StructType\EndItemsRequestType $endItemsRequest
     * @return \LewisLarsen\Ebay\StructType\EndItemsResponseType|bool
     */
    public function EndItems(\LewisLarsen\Ebay\StructType\EndItemsRequestType $endItemsRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->EndItems($endItemsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \LewisLarsen\Ebay\StructType\EndFixedPriceItemResponseType|\LewisLarsen\Ebay\StructType\EndItemResponseType|\LewisLarsen\Ebay\StructType\EndItemsResponseType
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
