<?php

namespace LewisLarsen\Ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NotificationUserDataType StructType
 * Meta information extracted from the WSDL
 * - documentation: User data related to notifications.
 * @subpackage Structs
 */
class NotificationUserDataType extends AbstractStructBase
{
    /**
     * The ExternalUserData
     * Meta information extracted from the WSDL
     * - documentation: An application subscribing to notifications can include an XML-compliant string, not to exceed 256 characters, which will be returned in the notification payload. The string can contain user-specific information to identify a
     * particular user. Any sensitive information should be passed with due caution and proper encryption.
     * - minOccurs: 0
     * @var string
     */
    public $ExternalUserData;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for NotificationUserDataType
     * @uses NotificationUserDataType::setExternalUserData()
     * @uses NotificationUserDataType::setAny()
     * @param string $externalUserData
     * @param \DOMDocument $any
     */
    public function __construct($externalUserData = null, \DOMDocument $any = null)
    {
        $this
            ->setExternalUserData($externalUserData)
            ->setAny($any);
    }
    /**
     * Get ExternalUserData value
     * @return string|null
     */
    public function getExternalUserData()
    {
        return $this->ExternalUserData;
    }
    /**
     * Set ExternalUserData value
     * @param string $externalUserData
     * @return \LewisLarsen\Ebay\StructType\NotificationUserDataType
     */
    public function setExternalUserData($externalUserData = null)
    {
        // validation for constraint: string
        if (!is_null($externalUserData) && !is_string($externalUserData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalUserData, true), gettype($externalUserData)), __LINE__);
        }
        $this->ExternalUserData = $externalUserData;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \LewisLarsen\Ebay\StructType\NotificationUserDataType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
}
