<?php

namespace LewisLarsen\Ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidateTestUserRegistrationRequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Requests to enable a test user to sell items in the Sandbox environment.
 * @subpackage Structs
 */
class ValidateTestUserRegistrationRequestType extends AbstractRequestType
{
    /**
     * The FeedbackScore
     * Meta information extracted from the WSDL
     * - documentation: Value for the feedback score of a user. If no value is passed in the request, or if the value is zero, the feedback score is unchanged. This element is not intended for regularly testing feedback because the feedback value can change
     * after the request.
     * - minOccurs: 0
     * @var int
     */
    public $FeedbackScore;
    /**
     * The RegistrationDate
     * Meta information extracted from the WSDL
     * - documentation: Value for the date and time that a user's registration begins.
     * - minOccurs: 0
     * @var string
     */
    public $RegistrationDate;
    /**
     * The SubscribeSM
     * Meta information extracted from the WSDL
     * - documentation: Indicates if a user subscribes to Selling Manager. You cannot request to subscribe a user to both Selling Manager and Selling Manager Pro. You cannot request to unsubscribe a user.
     * - minOccurs: 0
     * @var bool
     */
    public $SubscribeSM;
    /**
     * The SubscribeSMPro
     * Meta information extracted from the WSDL
     * - documentation: Indicates if a user subscribes to Selling Manager Pro. You cannot request to subscribe a user to both Selling Manager and Selling Manager Pro. You cannot request to unsubscribe a user.
     * - minOccurs: 0
     * @var bool
     */
    public $SubscribeSMPro;
    /**
     * Constructor method for ValidateTestUserRegistrationRequestType
     * @uses ValidateTestUserRegistrationRequestType::setFeedbackScore()
     * @uses ValidateTestUserRegistrationRequestType::setRegistrationDate()
     * @uses ValidateTestUserRegistrationRequestType::setSubscribeSM()
     * @uses ValidateTestUserRegistrationRequestType::setSubscribeSMPro()
     * @param int $feedbackScore
     * @param string $registrationDate
     * @param bool $subscribeSM
     * @param bool $subscribeSMPro
     */
    public function __construct($feedbackScore = null, $registrationDate = null, $subscribeSM = null, $subscribeSMPro = null)
    {
        $this
            ->setFeedbackScore($feedbackScore)
            ->setRegistrationDate($registrationDate)
            ->setSubscribeSM($subscribeSM)
            ->setSubscribeSMPro($subscribeSMPro);
    }
    /**
     * Get FeedbackScore value
     * @return int|null
     */
    public function getFeedbackScore()
    {
        return $this->FeedbackScore;
    }
    /**
     * Set FeedbackScore value
     * @param int $feedbackScore
     * @return \LewisLarsen\Ebay\StructType\ValidateTestUserRegistrationRequestType
     */
    public function setFeedbackScore($feedbackScore = null)
    {
        // validation for constraint: int
        if (!is_null($feedbackScore) && !(is_int($feedbackScore) || ctype_digit($feedbackScore))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($feedbackScore, true), gettype($feedbackScore)), __LINE__);
        }
        $this->FeedbackScore = $feedbackScore;
        return $this;
    }
    /**
     * Get RegistrationDate value
     * @return string|null
     */
    public function getRegistrationDate()
    {
        return $this->RegistrationDate;
    }
    /**
     * Set RegistrationDate value
     * @param string $registrationDate
     * @return \LewisLarsen\Ebay\StructType\ValidateTestUserRegistrationRequestType
     */
    public function setRegistrationDate($registrationDate = null)
    {
        // validation for constraint: string
        if (!is_null($registrationDate) && !is_string($registrationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($registrationDate, true), gettype($registrationDate)), __LINE__);
        }
        $this->RegistrationDate = $registrationDate;
        return $this;
    }
    /**
     * Get SubscribeSM value
     * @return bool|null
     */
    public function getSubscribeSM()
    {
        return $this->SubscribeSM;
    }
    /**
     * Set SubscribeSM value
     * @param bool $subscribeSM
     * @return \LewisLarsen\Ebay\StructType\ValidateTestUserRegistrationRequestType
     */
    public function setSubscribeSM($subscribeSM = null)
    {
        // validation for constraint: boolean
        if (!is_null($subscribeSM) && !is_bool($subscribeSM)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($subscribeSM, true), gettype($subscribeSM)), __LINE__);
        }
        $this->SubscribeSM = $subscribeSM;
        return $this;
    }
    /**
     * Get SubscribeSMPro value
     * @return bool|null
     */
    public function getSubscribeSMPro()
    {
        return $this->SubscribeSMPro;
    }
    /**
     * Set SubscribeSMPro value
     * @param bool $subscribeSMPro
     * @return \LewisLarsen\Ebay\StructType\ValidateTestUserRegistrationRequestType
     */
    public function setSubscribeSMPro($subscribeSMPro = null)
    {
        // validation for constraint: boolean
        if (!is_null($subscribeSMPro) && !is_bool($subscribeSMPro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($subscribeSMPro, true), gettype($subscribeSMPro)), __LINE__);
        }
        $this->SubscribeSMPro = $subscribeSMPro;
        return $this;
    }
}
