<?php

namespace LewisLarsen\Ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentType StructType
 * Meta information extracted from the WSDL
 * - documentation: Type defining the unique identifier of a regulatory document associated with the listing.
 * @subpackage Structs
 */
class DocumentType extends AbstractStructBase
{
    /**
     * The DocumentID
     * Meta information extracted from the WSDL
     * - documentation: The unique identifier of a regulatory document associated with the listing. <br /><br /> This value can be found in the response of the <a href = "/api-docs/commerce/media/resources/document/methods/createDocument"
     * target="_blank">createDocument</a> method of the Media API.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentID;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for DocumentType
     * @uses DocumentType::setDocumentID()
     * @uses DocumentType::setAny()
     * @param string $documentID
     * @param \DOMDocument $any
     */
    public function __construct($documentID = null, \DOMDocument $any = null)
    {
        $this
            ->setDocumentID($documentID)
            ->setAny($any);
    }
    /**
     * Get DocumentID value
     * @return string|null
     */
    public function getDocumentID()
    {
        return $this->DocumentID;
    }
    /**
     * Set DocumentID value
     * @param string $documentID
     * @return \LewisLarsen\Ebay\StructType\DocumentType
     */
    public function setDocumentID($documentID = null)
    {
        // validation for constraint: string
        if (!is_null($documentID) && !is_string($documentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentID, true), gettype($documentID)), __LINE__);
        }
        $this->DocumentID = $documentID;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \LewisLarsen\Ebay\StructType\DocumentType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
}
