<?php

namespace LewisLarsen\Ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetMyeBaySellingResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: Returns summary and detail information about items the user is selling, items scheduled to sell, currently listed, sold, and closed but not sold.
 * @subpackage Structs
 */
class GetMyeBaySellingResponseType extends AbstractResponseType
{
    /**
     * The SellingSummary
     * Meta information extracted from the WSDL
     * - documentation: This container consists of seller activity counts and values. For this container to be returned, the user must include the <b>SellingSummary.Include</b> field in the request and set its value to <code>true</code>.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\SellingSummaryType
     */
    public $SellingSummary;
    /**
     * The ScheduledList
     * Meta information extracted from the WSDL
     * - documentation: This container consists of the items that are scheduled to become active at a future date/time. This container will be returned if the eBay user has one or more listings scheduled to become active at a future date/time. <br><br> This
     * container will not be returned in the response (even if there are listings scheduled to become active) if the <b>DetailLevel</b> value is set to <code>ReturnSummary</code> and the <b>ScheduledList.Include</b> field is omitted or set to
     * <code>false</code>.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\PaginatedItemArrayType
     */
    public $ScheduledList;
    /**
     * The ActiveList
     * Meta information extracted from the WSDL
     * - documentation: This container consists of active listings. This container will be returned if the eBay user has one or more active listings on eBay.com. <br><br> This container will not be returned in the response (even if there are one or more
     * active listings) if the <b>DetailLevel</b> value is set to <code>ReturnSummary</code> and the <b>ActiveList.Include</b> field is omitted or set to <code>false</code>.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\PaginatedItemArrayType
     */
    public $ActiveList;
    /**
     * The SoldList
     * Meta information extracted from the WSDL
     * - documentation: This container consists of order line items that have been sold. This container will be returned if the eBay user has one or more listings that have had recent sales. <br><br> This container will not be returned in the response (even
     * if there are one or more sales) if the <b>DetailLevel</b> value is set to <code>ReturnSummary</code> and the <b>SoldList.Include</b> field is omitted or set to <code>false</code>.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\PaginatedOrderTransactionArrayType
     */
    public $SoldList;
    /**
     * The UnsoldList
     * Meta information extracted from the WSDL
     * - documentation: This container consists of listings that have ended without sales. This container will be returned if the eBay user has one or more listings that have ended without sales. <br><br> This container will not be returned in the response
     * (even if there are one or more listings that ended without sales) if the <b>DetailLevel</b> value is set to <code>ReturnSummary</code> and the <b>UnsoldList.Include</b> field is omitted or set to <code>false</code>.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\PaginatedItemArrayType
     */
    public $UnsoldList;
    /**
     * The Summary
     * Meta information extracted from the WSDL
     * - documentation: This container consists of seller activity counts and values. This container is always returned if there has been recent sell activity.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\MyeBaySellingSummaryType
     */
    public $Summary;
    /**
     * Constructor method for GetMyeBaySellingResponseType
     * @uses GetMyeBaySellingResponseType::setSellingSummary()
     * @uses GetMyeBaySellingResponseType::setScheduledList()
     * @uses GetMyeBaySellingResponseType::setActiveList()
     * @uses GetMyeBaySellingResponseType::setSoldList()
     * @uses GetMyeBaySellingResponseType::setUnsoldList()
     * @uses GetMyeBaySellingResponseType::setSummary()
     * @param \LewisLarsen\Ebay\StructType\SellingSummaryType $sellingSummary
     * @param \LewisLarsen\Ebay\StructType\PaginatedItemArrayType $scheduledList
     * @param \LewisLarsen\Ebay\StructType\PaginatedItemArrayType $activeList
     * @param \LewisLarsen\Ebay\StructType\PaginatedOrderTransactionArrayType $soldList
     * @param \LewisLarsen\Ebay\StructType\PaginatedItemArrayType $unsoldList
     * @param \LewisLarsen\Ebay\StructType\MyeBaySellingSummaryType $summary
     */
    public function __construct(\LewisLarsen\Ebay\StructType\SellingSummaryType $sellingSummary = null, \LewisLarsen\Ebay\StructType\PaginatedItemArrayType $scheduledList = null, \LewisLarsen\Ebay\StructType\PaginatedItemArrayType $activeList = null, \LewisLarsen\Ebay\StructType\PaginatedOrderTransactionArrayType $soldList = null, \LewisLarsen\Ebay\StructType\PaginatedItemArrayType $unsoldList = null, \LewisLarsen\Ebay\StructType\MyeBaySellingSummaryType $summary = null)
    {
        $this
            ->setSellingSummary($sellingSummary)
            ->setScheduledList($scheduledList)
            ->setActiveList($activeList)
            ->setSoldList($soldList)
            ->setUnsoldList($unsoldList)
            ->setSummary($summary);
    }
    /**
     * Get SellingSummary value
     * @return \LewisLarsen\Ebay\StructType\SellingSummaryType|null
     */
    public function getSellingSummary()
    {
        return $this->SellingSummary;
    }
    /**
     * Set SellingSummary value
     * @param \LewisLarsen\Ebay\StructType\SellingSummaryType $sellingSummary
     * @return \LewisLarsen\Ebay\StructType\GetMyeBaySellingResponseType
     */
    public function setSellingSummary(\LewisLarsen\Ebay\StructType\SellingSummaryType $sellingSummary = null)
    {
        $this->SellingSummary = $sellingSummary;
        return $this;
    }
    /**
     * Get ScheduledList value
     * @return \LewisLarsen\Ebay\StructType\PaginatedItemArrayType|null
     */
    public function getScheduledList()
    {
        return $this->ScheduledList;
    }
    /**
     * Set ScheduledList value
     * @param \LewisLarsen\Ebay\StructType\PaginatedItemArrayType $scheduledList
     * @return \LewisLarsen\Ebay\StructType\GetMyeBaySellingResponseType
     */
    public function setScheduledList(\LewisLarsen\Ebay\StructType\PaginatedItemArrayType $scheduledList = null)
    {
        $this->ScheduledList = $scheduledList;
        return $this;
    }
    /**
     * Get ActiveList value
     * @return \LewisLarsen\Ebay\StructType\PaginatedItemArrayType|null
     */
    public function getActiveList()
    {
        return $this->ActiveList;
    }
    /**
     * Set ActiveList value
     * @param \LewisLarsen\Ebay\StructType\PaginatedItemArrayType $activeList
     * @return \LewisLarsen\Ebay\StructType\GetMyeBaySellingResponseType
     */
    public function setActiveList(\LewisLarsen\Ebay\StructType\PaginatedItemArrayType $activeList = null)
    {
        $this->ActiveList = $activeList;
        return $this;
    }
    /**
     * Get SoldList value
     * @return \LewisLarsen\Ebay\StructType\PaginatedOrderTransactionArrayType|null
     */
    public function getSoldList()
    {
        return $this->SoldList;
    }
    /**
     * Set SoldList value
     * @param \LewisLarsen\Ebay\StructType\PaginatedOrderTransactionArrayType $soldList
     * @return \LewisLarsen\Ebay\StructType\GetMyeBaySellingResponseType
     */
    public function setSoldList(\LewisLarsen\Ebay\StructType\PaginatedOrderTransactionArrayType $soldList = null)
    {
        $this->SoldList = $soldList;
        return $this;
    }
    /**
     * Get UnsoldList value
     * @return \LewisLarsen\Ebay\StructType\PaginatedItemArrayType|null
     */
    public function getUnsoldList()
    {
        return $this->UnsoldList;
    }
    /**
     * Set UnsoldList value
     * @param \LewisLarsen\Ebay\StructType\PaginatedItemArrayType $unsoldList
     * @return \LewisLarsen\Ebay\StructType\GetMyeBaySellingResponseType
     */
    public function setUnsoldList(\LewisLarsen\Ebay\StructType\PaginatedItemArrayType $unsoldList = null)
    {
        $this->UnsoldList = $unsoldList;
        return $this;
    }
    /**
     * Get Summary value
     * @return \LewisLarsen\Ebay\StructType\MyeBaySellingSummaryType|null
     */
    public function getSummary()
    {
        return $this->Summary;
    }
    /**
     * Set Summary value
     * @param \LewisLarsen\Ebay\StructType\MyeBaySellingSummaryType $summary
     * @return \LewisLarsen\Ebay\StructType\GetMyeBaySellingResponseType
     */
    public function setSummary(\LewisLarsen\Ebay\StructType\MyeBaySellingSummaryType $summary = null)
    {
        $this->Summary = $summary;
        return $this;
    }
}
