<?php

namespace LewisLarsen\Ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CalculatedShippingRateType StructType
 * Meta information extracted from the WSDL
 * - documentation: This type is used to specify domestic and international package handling costs if calculated shipping is being used.
 * @subpackage Structs
 */
class CalculatedShippingRateType extends AbstractStructBase
{
    /**
     * The PackagingHandlingCosts
     * Meta information extracted from the WSDL
     * - documentation: Fees a seller might assess for the shipping of the item (in addition to whatever the shipping service might charge). Any packaging/handling cost specified on input is added to each shipping service on output. <br/><br/> If domestic
     * and international calculated shipping is offered for an item and if packaging/handling cost is specified only for domestic shipping, that cost will be applied by eBay as the international packaging/handling cost. (To specify a international
     * packaging/handling cost, you must always specify a domestic packaging/handling cost, even if it is 0.) When UPS is one of the shipping services offered by the seller, package dimensions are required on list/relist/revise. <br/> <span
     * class="tablenote"><strong>Note:</strong> If the listing only has one domestic shipping service and it is free shipping, the domestic package handling cost will be ignored and will not be applied to the listing. </span>
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\AmountType
     */
    public $PackagingHandlingCosts;
    /**
     * The InternationalPackagingHandlingCosts
     * Meta information extracted from the WSDL
     * - documentation: This field shows any package handling cost applied to international shipping. This cost will be in addition to any shipping cost applicable to each international shipping service option. <br/><br/> For international calculated
     * shipping only.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\AmountType
     */
    public $InternationalPackagingHandlingCosts;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for CalculatedShippingRateType
     * @uses CalculatedShippingRateType::setPackagingHandlingCosts()
     * @uses CalculatedShippingRateType::setInternationalPackagingHandlingCosts()
     * @uses CalculatedShippingRateType::setAny()
     * @param \LewisLarsen\Ebay\StructType\AmountType $packagingHandlingCosts
     * @param \LewisLarsen\Ebay\StructType\AmountType $internationalPackagingHandlingCosts
     * @param \DOMDocument $any
     */
    public function __construct(\LewisLarsen\Ebay\StructType\AmountType $packagingHandlingCosts = null, \LewisLarsen\Ebay\StructType\AmountType $internationalPackagingHandlingCosts = null, \DOMDocument $any = null)
    {
        $this
            ->setPackagingHandlingCosts($packagingHandlingCosts)
            ->setInternationalPackagingHandlingCosts($internationalPackagingHandlingCosts)
            ->setAny($any);
    }
    /**
     * Get PackagingHandlingCosts value
     * @return \LewisLarsen\Ebay\StructType\AmountType|null
     */
    public function getPackagingHandlingCosts()
    {
        return $this->PackagingHandlingCosts;
    }
    /**
     * Set PackagingHandlingCosts value
     * @param \LewisLarsen\Ebay\StructType\AmountType $packagingHandlingCosts
     * @return \LewisLarsen\Ebay\StructType\CalculatedShippingRateType
     */
    public function setPackagingHandlingCosts(\LewisLarsen\Ebay\StructType\AmountType $packagingHandlingCosts = null)
    {
        $this->PackagingHandlingCosts = $packagingHandlingCosts;
        return $this;
    }
    /**
     * Get InternationalPackagingHandlingCosts value
     * @return \LewisLarsen\Ebay\StructType\AmountType|null
     */
    public function getInternationalPackagingHandlingCosts()
    {
        return $this->InternationalPackagingHandlingCosts;
    }
    /**
     * Set InternationalPackagingHandlingCosts value
     * @param \LewisLarsen\Ebay\StructType\AmountType $internationalPackagingHandlingCosts
     * @return \LewisLarsen\Ebay\StructType\CalculatedShippingRateType
     */
    public function setInternationalPackagingHandlingCosts(\LewisLarsen\Ebay\StructType\AmountType $internationalPackagingHandlingCosts = null)
    {
        $this->InternationalPackagingHandlingCosts = $internationalPackagingHandlingCosts;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \LewisLarsen\Ebay\StructType\CalculatedShippingRateType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
}
