<?php

namespace LewisLarsen\Ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LeaveFeedbackResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: Base response for the <b>LeaveFeedback</b> call. The response includes a <b>FeedbackID</b> value, which is automatically generated by eBay if the caller is successfully at submitting the Feedback entry.
 * @subpackage Structs
 */
class LeaveFeedbackResponseType extends AbstractResponseType
{
    /**
     * The FeedbackID
     * Meta information extracted from the WSDL
     * - documentation: The unique identifier of the Feedback entry that has been submitted by the caller.
     * - minOccurs: 0
     * @var string
     */
    public $FeedbackID;
    /**
     * Constructor method for LeaveFeedbackResponseType
     * @uses LeaveFeedbackResponseType::setFeedbackID()
     * @param string $feedbackID
     */
    public function __construct($feedbackID = null)
    {
        $this
            ->setFeedbackID($feedbackID);
    }
    /**
     * Get FeedbackID value
     * @return string|null
     */
    public function getFeedbackID()
    {
        return $this->FeedbackID;
    }
    /**
     * Set FeedbackID value
     * @param string $feedbackID
     * @return \LewisLarsen\Ebay\StructType\LeaveFeedbackResponseType
     */
    public function setFeedbackID($feedbackID = null)
    {
        // validation for constraint: string
        if (!is_null($feedbackID) && !is_string($feedbackID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($feedbackID, true), gettype($feedbackID)), __LINE__);
        }
        $this->FeedbackID = $feedbackID;
        return $this;
    }
}
