<?php

namespace LewisLarsen\Ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendInvoiceRequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: This call enables a seller to send an order invoice to a buyer. Optionally, and when applicable, this call can also be used to update the shipping service options available for shipment, to provide payment or checkout instructions to
 * the buyer, to make a cost adjustment for the order/order line item, or to provide one or more offline payment methods (for orders where offline payment is an option).
 * @subpackage Structs
 */
class SendInvoiceRequestType extends AbstractRequestType
{
    /**
     * The ItemID
     * Meta information extracted from the WSDL
     * - documentation: Unique identifier of the eBay listing. Unless <b>OrderID</b> or <b>OrderLineItemID</b> is provided in the request, the <b>ItemID</b> value (or <b>SKU</b> value) is conditionally required and must be paired with the corresponding
     * <b>TransactionID</b> value to identify an order line item. For a multiple line item order, <b>OrderID</b> should be used. | Type that represents the unique identifier for an eBay listing.
     * - base: xs:string
     * - minOccurs: 0
     * @var string
     */
    public $ItemID;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - documentation: Unique identifier for an eBay sales transaction. This identifier is created once there is a commitment from a buyer to purchase an item. Since an auction listing can only have one sales transaction during the duration of the listing,
     * the <b>TransactionID</b> value for auction listings is always <code>0</code>. Unless <b>OrderID</b> or <b>OrderLineItemID</b> is provided in the request, the <b>TransactionID</b> value is required and must be paired with the corresponding
     * <b>ItemID</b> value to identify an order line item. For a multiple line item order, <b>OrderID</b> should be used.
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * The OrderID
     * Meta information extracted from the WSDL
     * - documentation: A unique identifier that identifies a single line item or multiple line item order. <br><br> Unless the <b>ItemID</b> value (or <b>SKU</b> value) and corresponding <b>TransactionID</b> value, or the <b>OrderLineItemID</b> value is
     * provided in the request to identify a single line item order, the <b>OrderID</b> value must be specified. If <b>OrderID</b> value is specified, <b>OrderLineItemID</b>, <b>ItemID</b>, <b>TransactionID</b>, and <b>SKU</b> fields are ignored if present
     * in the same request. <br><br> <span class="tablenote"><b>Note: </b> Note that the unique identifier of a 'non-immediate payment' order will change as it goes from an unpaid order to a paid order. Due to this scenario, all Trading API calls that
     * accept Order ID values as filters in the request payload will support the identifiers for both unpaid and paid orders. <br><br> Sellers can check to see if an order has been paid by looking for a value of <code>Complete</code> in the
     * <b>CheckoutStatus.Status</b> field in the response of <b>GetOrders</b> call, or in the <b>Status.CompleteStatus</b> field in the response of <b>GetItemTransactions</b> or <b>GetSellerTransactions</b> call. Sellers should not fulfill orders until
     * buyer has made payment. </span> | Type that represents the unique identifier for an eBay order. The format is a non-parsable string, globally unique across all eBay marketplaces, and consistent for both single line item and multiple line item orders.
     * - base: xs:string
     * - minOccurs: 0
     * @var string
     */
    public $OrderID;
    /**
     * The InternationalShippingServiceOptions
     * Meta information extracted from the WSDL
     * - documentation: If the buyer has an international shipping address, use this container to offer up to four international shipping service options (or five if one of the shipping service options is Global Shipping Program or eBay International
     * Shipping). If one or more international shipping service options are offered through this container, the (domestic) <b>ShippingServiceOptions</b> container should not be included in the same request. <br>
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\InternationalShippingServiceOptionsType[]
     */
    public $InternationalShippingServiceOptions;
    /**
     * The ShippingServiceOptions
     * Meta information extracted from the WSDL
     * - documentation: If the buyer has a domestic shipping address, use this container to offer up to four domestic shipping service options. If one or more domestic shipping service options are offered through this container, the
     * <b>InternationalShippingServiceOptions</b> container should not be included in the same request. <br>
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\ShippingServiceOptionsType[]
     */
    public $ShippingServiceOptions;
    /**
     * The SalesTax
     * Meta information extracted from the WSDL
     * - documentation: This container is used if the seller wishes to apply sales tax to the order if the buyer lives in a state/jurisdiction where sales tax is not already collected automatically by eBay and remitted to the tax authority. The amount of
     * sales tax applied to the order is dependent on the sales tax rate in the buyer's state and whether sales tax is being applied to the cost of the order only or the cost of the order plus shipping and handling. <br><br> <span class="tablenote"><b>Note:
     * </b> Buyers in all 50 US states and DC are automatically charged sales tax for eBay purchases, and eBay collects and remits this sales tax to the proper taxing authority on the buyer's behalf. Because of this, if a sales tax percentage rate is
     * applied to a listing by a seller in one of these states, this field will be ignored during the checkout process. <br><br> Currently, sales tax percentage rates can only be specified by sellers in Canada and 5 US territories, including American Samoa
     * (AS), Guam (GU), Northern Mariana Islands (MP), Palau (PW), and Virgin Islands (VI). </span>
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\SalesTaxType
     */
    public $SalesTax;
    /**
     * The PaymentMethods
     * Meta information extracted from the WSDL
     * - documentation: This field should only be used if the seller needs to add one or more offline payment options for an order that requires/supports offline payment. A seller should not submit any online payment methods here since eBay now controls the
     * available online payment options that are available to buyers, and not the seller. </span>
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $PaymentMethods;
    /**
     * The CheckoutInstructions
     * Meta information extracted from the WSDL
     * - documentation: This field allows the seller to provide a message or instructions regarding checkout/payment, or the return policy.
     * - minOccurs: 0
     * @var string
     */
    public $CheckoutInstructions;
    /**
     * The EmailCopyToSeller
     * Meta information extracted from the WSDL
     * - documentation: This field is included and set to <code>true</code> if the seller wishes to receive an email copy of the invoice sent to the buyer.
     * - minOccurs: 0
     * @var bool
     */
    public $EmailCopyToSeller;
    /**
     * The SKU
     * Meta information extracted from the WSDL
     * - documentation: The seller's unique identifier for an item that is being tracked by this SKU. If <b>OrderID</b> or <b>OrderLineItemID</b> are not provided, both <b>SKU</b> (or <b>ItemID</b>) and corresponding <b>TransactionID</b> must be provided to
     * uniquely identify a single line item order. For a multiple line item order, <b>OrderID</b> must be used. <br> <br> This field should only be used if the <b>Item.InventoryTrackingMethod</b> field (set with the <b>AddFixedPriceItem</b> or
     * <b>RelistFixedPriceItem</b> calls) is set to <code>SKU</code>. | Primitive type that represents a stock-keeping unit (SKU). The usage of this string may vary in different contexts. For usage information and rules, see the fields that reference this
     * type.
     * - base: xs:string
     * - minOccurs: 0
     * @var string
     */
    public $SKU;
    /**
     * The OrderLineItemID
     * Meta information extracted from the WSDL
     * - documentation: A unique identifier for an eBay order line item. This identifier is created as soon as there is a commitment to buy (bidder wins the auction, buyer clicks buy button, or buyer purchases item through <b>PlaceOffer</b> call). <br> <br>
     * Unless the <b>ItemID</b> (or <b>SKU</b>) and corresponding <b>TransactionID</b> is used to identify a single line item order, or the <b>OrderID</b> is used to identify a single or multiple line item order, the <b>OrderLineItemID</b> must be
     * specified. For a multiple line item order, <b>OrderID</b> should be used. If <b>OrderLineItemID</b> is specified, <b>ItemID</b>, <b>TransactionID</b>, and <b>SKU</b> are ignored if present in the same request.
     * - minOccurs: 0
     * @var string
     */
    public $OrderLineItemID;
    /**
     * The AdjustmentAmount
     * Meta information extracted from the WSDL
     * - documentation: This field allows the seller to adjust the total cost of the order to account for an extra charge or to pass down a discount to the buyer. <br><br> The currency used in this field must be the same currency of the listing site. A
     * positive value in this field indicates that the amount is an extra charge being paid to the seller by the buyer, and a negative value indicates that the amount is a discount given to the buyer by the seller.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\AmountType
     */
    public $AdjustmentAmount;
    /**
     * Constructor method for SendInvoiceRequestType
     * @uses SendInvoiceRequestType::setItemID()
     * @uses SendInvoiceRequestType::setTransactionID()
     * @uses SendInvoiceRequestType::setOrderID()
     * @uses SendInvoiceRequestType::setInternationalShippingServiceOptions()
     * @uses SendInvoiceRequestType::setShippingServiceOptions()
     * @uses SendInvoiceRequestType::setSalesTax()
     * @uses SendInvoiceRequestType::setPaymentMethods()
     * @uses SendInvoiceRequestType::setCheckoutInstructions()
     * @uses SendInvoiceRequestType::setEmailCopyToSeller()
     * @uses SendInvoiceRequestType::setSKU()
     * @uses SendInvoiceRequestType::setOrderLineItemID()
     * @uses SendInvoiceRequestType::setAdjustmentAmount()
     * @param string $itemID
     * @param string $transactionID
     * @param string $orderID
     * @param \LewisLarsen\Ebay\StructType\InternationalShippingServiceOptionsType[] $internationalShippingServiceOptions
     * @param \LewisLarsen\Ebay\StructType\ShippingServiceOptionsType[] $shippingServiceOptions
     * @param \LewisLarsen\Ebay\StructType\SalesTaxType $salesTax
     * @param string[] $paymentMethods
     * @param string $checkoutInstructions
     * @param bool $emailCopyToSeller
     * @param string $sKU
     * @param string $orderLineItemID
     * @param \LewisLarsen\Ebay\StructType\AmountType $adjustmentAmount
     */
    public function __construct($itemID = null, $transactionID = null, $orderID = null, array $internationalShippingServiceOptions = array(), array $shippingServiceOptions = array(), \LewisLarsen\Ebay\StructType\SalesTaxType $salesTax = null, array $paymentMethods = array(), $checkoutInstructions = null, $emailCopyToSeller = null, $sKU = null, $orderLineItemID = null, \LewisLarsen\Ebay\StructType\AmountType $adjustmentAmount = null)
    {
        $this
            ->setItemID($itemID)
            ->setTransactionID($transactionID)
            ->setOrderID($orderID)
            ->setInternationalShippingServiceOptions($internationalShippingServiceOptions)
            ->setShippingServiceOptions($shippingServiceOptions)
            ->setSalesTax($salesTax)
            ->setPaymentMethods($paymentMethods)
            ->setCheckoutInstructions($checkoutInstructions)
            ->setEmailCopyToSeller($emailCopyToSeller)
            ->setSKU($sKU)
            ->setOrderLineItemID($orderLineItemID)
            ->setAdjustmentAmount($adjustmentAmount);
    }
    /**
     * Get ItemID value
     * @return string|null
     */
    public function getItemID()
    {
        return $this->ItemID;
    }
    /**
     * Set ItemID value
     * @param string $itemID
     * @return \LewisLarsen\Ebay\StructType\SendInvoiceRequestType
     */
    public function setItemID($itemID = null)
    {
        // validation for constraint: string
        if (!is_null($itemID) && !is_string($itemID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemID, true), gettype($itemID)), __LINE__);
        }
        $this->ItemID = $itemID;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \LewisLarsen\Ebay\StructType\SendInvoiceRequestType
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get OrderID value
     * @return string|null
     */
    public function getOrderID()
    {
        return $this->OrderID;
    }
    /**
     * Set OrderID value
     * @param string $orderID
     * @return \LewisLarsen\Ebay\StructType\SendInvoiceRequestType
     */
    public function setOrderID($orderID = null)
    {
        // validation for constraint: string
        if (!is_null($orderID) && !is_string($orderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderID, true), gettype($orderID)), __LINE__);
        }
        $this->OrderID = $orderID;
        return $this;
    }
    /**
     * Get InternationalShippingServiceOptions value
     * @return \LewisLarsen\Ebay\StructType\InternationalShippingServiceOptionsType[]|null
     */
    public function getInternationalShippingServiceOptions()
    {
        return $this->InternationalShippingServiceOptions;
    }
    /**
     * This method is responsible for validating the values passed to the setInternationalShippingServiceOptions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInternationalShippingServiceOptions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInternationalShippingServiceOptionsForArrayConstraintsFromSetInternationalShippingServiceOptions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $sendInvoiceRequestTypeInternationalShippingServiceOptionsItem) {
            // validation for constraint: itemType
            if (!$sendInvoiceRequestTypeInternationalShippingServiceOptionsItem instanceof \LewisLarsen\Ebay\StructType\InternationalShippingServiceOptionsType) {
                $invalidValues[] = is_object($sendInvoiceRequestTypeInternationalShippingServiceOptionsItem) ? get_class($sendInvoiceRequestTypeInternationalShippingServiceOptionsItem) : sprintf('%s(%s)', gettype($sendInvoiceRequestTypeInternationalShippingServiceOptionsItem), var_export($sendInvoiceRequestTypeInternationalShippingServiceOptionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InternationalShippingServiceOptions property can only contain items of type \LewisLarsen\Ebay\StructType\InternationalShippingServiceOptionsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InternationalShippingServiceOptions value
     * @throws \InvalidArgumentException
     * @param \LewisLarsen\Ebay\StructType\InternationalShippingServiceOptionsType[] $internationalShippingServiceOptions
     * @return \LewisLarsen\Ebay\StructType\SendInvoiceRequestType
     */
    public function setInternationalShippingServiceOptions(array $internationalShippingServiceOptions = array())
    {
        // validation for constraint: array
        if ('' !== ($internationalShippingServiceOptionsArrayErrorMessage = self::validateInternationalShippingServiceOptionsForArrayConstraintsFromSetInternationalShippingServiceOptions($internationalShippingServiceOptions))) {
            throw new \InvalidArgumentException($internationalShippingServiceOptionsArrayErrorMessage, __LINE__);
        }
        $this->InternationalShippingServiceOptions = $internationalShippingServiceOptions;
        return $this;
    }
    /**
     * Add item to InternationalShippingServiceOptions value
     * @throws \InvalidArgumentException
     * @param \LewisLarsen\Ebay\StructType\InternationalShippingServiceOptionsType $item
     * @return \LewisLarsen\Ebay\StructType\SendInvoiceRequestType
     */
    public function addToInternationalShippingServiceOptions(\LewisLarsen\Ebay\StructType\InternationalShippingServiceOptionsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \LewisLarsen\Ebay\StructType\InternationalShippingServiceOptionsType) {
            throw new \InvalidArgumentException(sprintf('The InternationalShippingServiceOptions property can only contain items of type \LewisLarsen\Ebay\StructType\InternationalShippingServiceOptionsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InternationalShippingServiceOptions[] = $item;
        return $this;
    }
    /**
     * Get ShippingServiceOptions value
     * @return \LewisLarsen\Ebay\StructType\ShippingServiceOptionsType[]|null
     */
    public function getShippingServiceOptions()
    {
        return $this->ShippingServiceOptions;
    }
    /**
     * This method is responsible for validating the values passed to the setShippingServiceOptions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShippingServiceOptions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShippingServiceOptionsForArrayConstraintsFromSetShippingServiceOptions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $sendInvoiceRequestTypeShippingServiceOptionsItem) {
            // validation for constraint: itemType
            if (!$sendInvoiceRequestTypeShippingServiceOptionsItem instanceof \LewisLarsen\Ebay\StructType\ShippingServiceOptionsType) {
                $invalidValues[] = is_object($sendInvoiceRequestTypeShippingServiceOptionsItem) ? get_class($sendInvoiceRequestTypeShippingServiceOptionsItem) : sprintf('%s(%s)', gettype($sendInvoiceRequestTypeShippingServiceOptionsItem), var_export($sendInvoiceRequestTypeShippingServiceOptionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ShippingServiceOptions property can only contain items of type \LewisLarsen\Ebay\StructType\ShippingServiceOptionsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ShippingServiceOptions value
     * @throws \InvalidArgumentException
     * @param \LewisLarsen\Ebay\StructType\ShippingServiceOptionsType[] $shippingServiceOptions
     * @return \LewisLarsen\Ebay\StructType\SendInvoiceRequestType
     */
    public function setShippingServiceOptions(array $shippingServiceOptions = array())
    {
        // validation for constraint: array
        if ('' !== ($shippingServiceOptionsArrayErrorMessage = self::validateShippingServiceOptionsForArrayConstraintsFromSetShippingServiceOptions($shippingServiceOptions))) {
            throw new \InvalidArgumentException($shippingServiceOptionsArrayErrorMessage, __LINE__);
        }
        $this->ShippingServiceOptions = $shippingServiceOptions;
        return $this;
    }
    /**
     * Add item to ShippingServiceOptions value
     * @throws \InvalidArgumentException
     * @param \LewisLarsen\Ebay\StructType\ShippingServiceOptionsType $item
     * @return \LewisLarsen\Ebay\StructType\SendInvoiceRequestType
     */
    public function addToShippingServiceOptions(\LewisLarsen\Ebay\StructType\ShippingServiceOptionsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \LewisLarsen\Ebay\StructType\ShippingServiceOptionsType) {
            throw new \InvalidArgumentException(sprintf('The ShippingServiceOptions property can only contain items of type \LewisLarsen\Ebay\StructType\ShippingServiceOptionsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ShippingServiceOptions[] = $item;
        return $this;
    }
    /**
     * Get SalesTax value
     * @return \LewisLarsen\Ebay\StructType\SalesTaxType|null
     */
    public function getSalesTax()
    {
        return $this->SalesTax;
    }
    /**
     * Set SalesTax value
     * @param \LewisLarsen\Ebay\StructType\SalesTaxType $salesTax
     * @return \LewisLarsen\Ebay\StructType\SendInvoiceRequestType
     */
    public function setSalesTax(\LewisLarsen\Ebay\StructType\SalesTaxType $salesTax = null)
    {
        $this->SalesTax = $salesTax;
        return $this;
    }
    /**
     * Get PaymentMethods value
     * @return string[]|null
     */
    public function getPaymentMethods()
    {
        return $this->PaymentMethods;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentMethods method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentMethods method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentMethodsForArrayConstraintsFromSetPaymentMethods(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $sendInvoiceRequestTypePaymentMethodsItem) {
            // validation for constraint: enumeration
            if (!\LewisLarsen\Ebay\EnumType\BuyerPaymentMethodCodeType::valueIsValid($sendInvoiceRequestTypePaymentMethodsItem)) {
                $invalidValues[] = is_object($sendInvoiceRequestTypePaymentMethodsItem) ? get_class($sendInvoiceRequestTypePaymentMethodsItem) : sprintf('%s(%s)', gettype($sendInvoiceRequestTypePaymentMethodsItem), var_export($sendInvoiceRequestTypePaymentMethodsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \LewisLarsen\Ebay\EnumType\BuyerPaymentMethodCodeType', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \LewisLarsen\Ebay\EnumType\BuyerPaymentMethodCodeType::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentMethods value
     * @uses \LewisLarsen\Ebay\EnumType\BuyerPaymentMethodCodeType::valueIsValid()
     * @uses \LewisLarsen\Ebay\EnumType\BuyerPaymentMethodCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $paymentMethods
     * @return \LewisLarsen\Ebay\StructType\SendInvoiceRequestType
     */
    public function setPaymentMethods(array $paymentMethods = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentMethodsArrayErrorMessage = self::validatePaymentMethodsForArrayConstraintsFromSetPaymentMethods($paymentMethods))) {
            throw new \InvalidArgumentException($paymentMethodsArrayErrorMessage, __LINE__);
        }
        $this->PaymentMethods = $paymentMethods;
        return $this;
    }
    /**
     * Add item to PaymentMethods value
     * @uses \LewisLarsen\Ebay\EnumType\BuyerPaymentMethodCodeType::valueIsValid()
     * @uses \LewisLarsen\Ebay\EnumType\BuyerPaymentMethodCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \LewisLarsen\Ebay\StructType\SendInvoiceRequestType
     */
    public function addToPaymentMethods($item)
    {
        // validation for constraint: enumeration
        if (!\LewisLarsen\Ebay\EnumType\BuyerPaymentMethodCodeType::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \LewisLarsen\Ebay\EnumType\BuyerPaymentMethodCodeType', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \LewisLarsen\Ebay\EnumType\BuyerPaymentMethodCodeType::getValidValues())), __LINE__);
        }
        $this->PaymentMethods[] = $item;
        return $this;
    }
    /**
     * Get CheckoutInstructions value
     * @return string|null
     */
    public function getCheckoutInstructions()
    {
        return $this->CheckoutInstructions;
    }
    /**
     * Set CheckoutInstructions value
     * @param string $checkoutInstructions
     * @return \LewisLarsen\Ebay\StructType\SendInvoiceRequestType
     */
    public function setCheckoutInstructions($checkoutInstructions = null)
    {
        // validation for constraint: string
        if (!is_null($checkoutInstructions) && !is_string($checkoutInstructions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checkoutInstructions, true), gettype($checkoutInstructions)), __LINE__);
        }
        $this->CheckoutInstructions = $checkoutInstructions;
        return $this;
    }
    /**
     * Get EmailCopyToSeller value
     * @return bool|null
     */
    public function getEmailCopyToSeller()
    {
        return $this->EmailCopyToSeller;
    }
    /**
     * Set EmailCopyToSeller value
     * @param bool $emailCopyToSeller
     * @return \LewisLarsen\Ebay\StructType\SendInvoiceRequestType
     */
    public function setEmailCopyToSeller($emailCopyToSeller = null)
    {
        // validation for constraint: boolean
        if (!is_null($emailCopyToSeller) && !is_bool($emailCopyToSeller)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($emailCopyToSeller, true), gettype($emailCopyToSeller)), __LINE__);
        }
        $this->EmailCopyToSeller = $emailCopyToSeller;
        return $this;
    }
    /**
     * Get SKU value
     * @return string|null
     */
    public function getSKU()
    {
        return $this->SKU;
    }
    /**
     * Set SKU value
     * @param string $sKU
     * @return \LewisLarsen\Ebay\StructType\SendInvoiceRequestType
     */
    public function setSKU($sKU = null)
    {
        // validation for constraint: string
        if (!is_null($sKU) && !is_string($sKU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sKU, true), gettype($sKU)), __LINE__);
        }
        $this->SKU = $sKU;
        return $this;
    }
    /**
     * Get OrderLineItemID value
     * @return string|null
     */
    public function getOrderLineItemID()
    {
        return $this->OrderLineItemID;
    }
    /**
     * Set OrderLineItemID value
     * @param string $orderLineItemID
     * @return \LewisLarsen\Ebay\StructType\SendInvoiceRequestType
     */
    public function setOrderLineItemID($orderLineItemID = null)
    {
        // validation for constraint: string
        if (!is_null($orderLineItemID) && !is_string($orderLineItemID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderLineItemID, true), gettype($orderLineItemID)), __LINE__);
        }
        $this->OrderLineItemID = $orderLineItemID;
        return $this;
    }
    /**
     * Get AdjustmentAmount value
     * @return \LewisLarsen\Ebay\StructType\AmountType|null
     */
    public function getAdjustmentAmount()
    {
        return $this->AdjustmentAmount;
    }
    /**
     * Set AdjustmentAmount value
     * @param \LewisLarsen\Ebay\StructType\AmountType $adjustmentAmount
     * @return \LewisLarsen\Ebay\StructType\SendInvoiceRequestType
     */
    public function setAdjustmentAmount(\LewisLarsen\Ebay\StructType\AmountType $adjustmentAmount = null)
    {
        $this->AdjustmentAmount = $adjustmentAmount;
        return $this;
    }
}
