<?php

namespace LewisLarsen\Ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetShippingDiscountProfilesRequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: This call enables a seller to create and manage shipping discounts rules. These are the same shipping discount rules that can be created or managed in My eBay Shipping Preferences. <br/><br/> The types of shipping discount rules that
 * can be created and managed with this call include flat-rate shipping rules, calculated shipping rules, and promotional shipping rules. This call can also be used by sellers to set whether or not they allow buyers to combine separate line items into
 * one Combined Invoice order, and how many days they allow buyers to perform that action. <br/><br/> A seller can only create, update, or delete one discount rule type with each call. The action to take (either <code>Add</code>, <code>Update</code>, or
 * <code>Delete</code>) is set and controlled with the <b>ModifyActionCode</b> field.
 * @subpackage Structs
 */
class SetShippingDiscountProfilesRequestType extends AbstractRequestType
{
    /**
     * The CurrencyID
     * Meta information extracted from the WSDL
     * - documentation: The three-digit code of the currency to be used for shipping discounts on Combined Invoice orders. A discount profile can only be associated with a listing if the <b>CurrencyID</b> value of the profile matches the
     * <b>Item.Currency</b> value specified in a listing. This field is required if the user is adding or updating one or more shipping discount profiles. <br><br> Note that There is a <b>currencyID</b> attribute on all <b>SetShippingDiscountProfiles</b>
     * elements involving money. To avoid a call error, be sure to use the same currency type in these attributes as what is set for the <b>CurrencyID</b> field.
     * - minOccurs: 0
     * @var string
     */
    public $CurrencyID;
    /**
     * The CombinedDuration
     * Meta information extracted from the WSDL
     * - documentation: This field is used to specify the number of days after the purchase of an item that the buyer or seller can combine multiple and mutual order line items into one Combined Invoice order. In a Combined Invoice order, the buyer makes
     * one payment for all order line items, hence only unpaid order line items can be combined into a Combined Invoice order.
     * - minOccurs: 0
     * @var string
     */
    public $CombinedDuration;
    /**
     * The ModifyActionCode
     * Meta information extracted from the WSDL
     * - documentation: This field is used to set which action is being taken (<code>Add</code>, <code>Update</code>, or <code>Delete</code>) in the call. If you are adding a shipping discount rule, you will have to supply a name for that shipping discount
     * profile. If you want to update or delete a shipping discount profile, you'll have to provide the unique identifier of this rule through the corresponding containers. The unique identifiers of these rules can be retrieved with the
     * <b>GetShippingDiscountRules</b> call, or the seller can view these identifiers in My eBay Shipping Preferences.
     * - minOccurs: 0
     * @var string
     */
    public $ModifyActionCode;
    /**
     * The FlatShippingDiscount
     * Meta information extracted from the WSDL
     * - documentation: This container allows you to create, update, or delete a flat-rate shipping discount profile.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\FlatShippingDiscountType
     */
    public $FlatShippingDiscount;
    /**
     * The CalculatedShippingDiscount
     * Meta information extracted from the WSDL
     * - documentation: This container allows you to create, update, or delete a calculated shipping discount profile.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\CalculatedShippingDiscountType
     */
    public $CalculatedShippingDiscount;
    /**
     * The CalculatedHandlingDiscount
     * Meta information extracted from the WSDL
     * - documentation: This container allows you to create, update, or delete a calculated handling discount profile.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\CalculatedHandlingDiscountType
     */
    public $CalculatedHandlingDiscount;
    /**
     * The PromotionalShippingDiscountDetails
     * Meta information extracted from the WSDL
     * - documentation: This container allows you to create, update, or delete a promotional shipping discount profile.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\PromotionalShippingDiscountDetailsType
     */
    public $PromotionalShippingDiscountDetails;
    /**
     * Constructor method for SetShippingDiscountProfilesRequestType
     * @uses SetShippingDiscountProfilesRequestType::setCurrencyID()
     * @uses SetShippingDiscountProfilesRequestType::setCombinedDuration()
     * @uses SetShippingDiscountProfilesRequestType::setModifyActionCode()
     * @uses SetShippingDiscountProfilesRequestType::setFlatShippingDiscount()
     * @uses SetShippingDiscountProfilesRequestType::setCalculatedShippingDiscount()
     * @uses SetShippingDiscountProfilesRequestType::setCalculatedHandlingDiscount()
     * @uses SetShippingDiscountProfilesRequestType::setPromotionalShippingDiscountDetails()
     * @param string $currencyID
     * @param string $combinedDuration
     * @param string $modifyActionCode
     * @param \LewisLarsen\Ebay\StructType\FlatShippingDiscountType $flatShippingDiscount
     * @param \LewisLarsen\Ebay\StructType\CalculatedShippingDiscountType $calculatedShippingDiscount
     * @param \LewisLarsen\Ebay\StructType\CalculatedHandlingDiscountType $calculatedHandlingDiscount
     * @param \LewisLarsen\Ebay\StructType\PromotionalShippingDiscountDetailsType $promotionalShippingDiscountDetails
     */
    public function __construct($currencyID = null, $combinedDuration = null, $modifyActionCode = null, \LewisLarsen\Ebay\StructType\FlatShippingDiscountType $flatShippingDiscount = null, \LewisLarsen\Ebay\StructType\CalculatedShippingDiscountType $calculatedShippingDiscount = null, \LewisLarsen\Ebay\StructType\CalculatedHandlingDiscountType $calculatedHandlingDiscount = null, \LewisLarsen\Ebay\StructType\PromotionalShippingDiscountDetailsType $promotionalShippingDiscountDetails = null)
    {
        $this
            ->setCurrencyID($currencyID)
            ->setCombinedDuration($combinedDuration)
            ->setModifyActionCode($modifyActionCode)
            ->setFlatShippingDiscount($flatShippingDiscount)
            ->setCalculatedShippingDiscount($calculatedShippingDiscount)
            ->setCalculatedHandlingDiscount($calculatedHandlingDiscount)
            ->setPromotionalShippingDiscountDetails($promotionalShippingDiscountDetails);
    }
    /**
     * Get CurrencyID value
     * @return string|null
     */
    public function getCurrencyID()
    {
        return $this->CurrencyID;
    }
    /**
     * Set CurrencyID value
     * @uses \LewisLarsen\Ebay\EnumType\CurrencyCodeType::valueIsValid()
     * @uses \LewisLarsen\Ebay\EnumType\CurrencyCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $currencyID
     * @return \LewisLarsen\Ebay\StructType\SetShippingDiscountProfilesRequestType
     */
    public function setCurrencyID($currencyID = null)
    {
        // validation for constraint: enumeration
        if (!\LewisLarsen\Ebay\EnumType\CurrencyCodeType::valueIsValid($currencyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \LewisLarsen\Ebay\EnumType\CurrencyCodeType', is_array($currencyID) ? implode(', ', $currencyID) : var_export($currencyID, true), implode(', ', \LewisLarsen\Ebay\EnumType\CurrencyCodeType::getValidValues())), __LINE__);
        }
        $this->CurrencyID = $currencyID;
        return $this;
    }
    /**
     * Get CombinedDuration value
     * @return string|null
     */
    public function getCombinedDuration()
    {
        return $this->CombinedDuration;
    }
    /**
     * Set CombinedDuration value
     * @uses \LewisLarsen\Ebay\EnumType\CombinedPaymentPeriodCodeType::valueIsValid()
     * @uses \LewisLarsen\Ebay\EnumType\CombinedPaymentPeriodCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $combinedDuration
     * @return \LewisLarsen\Ebay\StructType\SetShippingDiscountProfilesRequestType
     */
    public function setCombinedDuration($combinedDuration = null)
    {
        // validation for constraint: enumeration
        if (!\LewisLarsen\Ebay\EnumType\CombinedPaymentPeriodCodeType::valueIsValid($combinedDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \LewisLarsen\Ebay\EnumType\CombinedPaymentPeriodCodeType', is_array($combinedDuration) ? implode(', ', $combinedDuration) : var_export($combinedDuration, true), implode(', ', \LewisLarsen\Ebay\EnumType\CombinedPaymentPeriodCodeType::getValidValues())), __LINE__);
        }
        $this->CombinedDuration = $combinedDuration;
        return $this;
    }
    /**
     * Get ModifyActionCode value
     * @return string|null
     */
    public function getModifyActionCode()
    {
        return $this->ModifyActionCode;
    }
    /**
     * Set ModifyActionCode value
     * @uses \LewisLarsen\Ebay\EnumType\ModifyActionCodeType::valueIsValid()
     * @uses \LewisLarsen\Ebay\EnumType\ModifyActionCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $modifyActionCode
     * @return \LewisLarsen\Ebay\StructType\SetShippingDiscountProfilesRequestType
     */
    public function setModifyActionCode($modifyActionCode = null)
    {
        // validation for constraint: enumeration
        if (!\LewisLarsen\Ebay\EnumType\ModifyActionCodeType::valueIsValid($modifyActionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \LewisLarsen\Ebay\EnumType\ModifyActionCodeType', is_array($modifyActionCode) ? implode(', ', $modifyActionCode) : var_export($modifyActionCode, true), implode(', ', \LewisLarsen\Ebay\EnumType\ModifyActionCodeType::getValidValues())), __LINE__);
        }
        $this->ModifyActionCode = $modifyActionCode;
        return $this;
    }
    /**
     * Get FlatShippingDiscount value
     * @return \LewisLarsen\Ebay\StructType\FlatShippingDiscountType|null
     */
    public function getFlatShippingDiscount()
    {
        return $this->FlatShippingDiscount;
    }
    /**
     * Set FlatShippingDiscount value
     * @param \LewisLarsen\Ebay\StructType\FlatShippingDiscountType $flatShippingDiscount
     * @return \LewisLarsen\Ebay\StructType\SetShippingDiscountProfilesRequestType
     */
    public function setFlatShippingDiscount(\LewisLarsen\Ebay\StructType\FlatShippingDiscountType $flatShippingDiscount = null)
    {
        $this->FlatShippingDiscount = $flatShippingDiscount;
        return $this;
    }
    /**
     * Get CalculatedShippingDiscount value
     * @return \LewisLarsen\Ebay\StructType\CalculatedShippingDiscountType|null
     */
    public function getCalculatedShippingDiscount()
    {
        return $this->CalculatedShippingDiscount;
    }
    /**
     * Set CalculatedShippingDiscount value
     * @param \LewisLarsen\Ebay\StructType\CalculatedShippingDiscountType $calculatedShippingDiscount
     * @return \LewisLarsen\Ebay\StructType\SetShippingDiscountProfilesRequestType
     */
    public function setCalculatedShippingDiscount(\LewisLarsen\Ebay\StructType\CalculatedShippingDiscountType $calculatedShippingDiscount = null)
    {
        $this->CalculatedShippingDiscount = $calculatedShippingDiscount;
        return $this;
    }
    /**
     * Get CalculatedHandlingDiscount value
     * @return \LewisLarsen\Ebay\StructType\CalculatedHandlingDiscountType|null
     */
    public function getCalculatedHandlingDiscount()
    {
        return $this->CalculatedHandlingDiscount;
    }
    /**
     * Set CalculatedHandlingDiscount value
     * @param \LewisLarsen\Ebay\StructType\CalculatedHandlingDiscountType $calculatedHandlingDiscount
     * @return \LewisLarsen\Ebay\StructType\SetShippingDiscountProfilesRequestType
     */
    public function setCalculatedHandlingDiscount(\LewisLarsen\Ebay\StructType\CalculatedHandlingDiscountType $calculatedHandlingDiscount = null)
    {
        $this->CalculatedHandlingDiscount = $calculatedHandlingDiscount;
        return $this;
    }
    /**
     * Get PromotionalShippingDiscountDetails value
     * @return \LewisLarsen\Ebay\StructType\PromotionalShippingDiscountDetailsType|null
     */
    public function getPromotionalShippingDiscountDetails()
    {
        return $this->PromotionalShippingDiscountDetails;
    }
    /**
     * Set PromotionalShippingDiscountDetails value
     * @param \LewisLarsen\Ebay\StructType\PromotionalShippingDiscountDetailsType $promotionalShippingDiscountDetails
     * @return \LewisLarsen\Ebay\StructType\SetShippingDiscountProfilesRequestType
     */
    public function setPromotionalShippingDiscountDetails(\LewisLarsen\Ebay\StructType\PromotionalShippingDiscountDetailsType $promotionalShippingDiscountDetails = null)
    {
        $this->PromotionalShippingDiscountDetails = $promotionalShippingDiscountDetails;
        return $this;
    }
}
