<?php

namespace LewisLarsen\Ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetShippingDiscountProfilesResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: The base response of the <b>GetShippingDiscountProfiles</b> call.
 * @subpackage Structs
 */
class GetShippingDiscountProfilesResponseType extends AbstractResponseType
{
    /**
     * The CurrencyID
     * Meta information extracted from the WSDL
     * - documentation: The three-digit code of the currency to be used for shipping cost discounts. A discount profile can only be associated with a listing if the <b>CurrencyID</b> value of the profile matches the <b>Item.Currency</b> value specified in a
     * listing.
     * - minOccurs: 0
     * @var string
     */
    public $CurrencyID;
    /**
     * The FlatShippingDiscount
     * Meta information extracted from the WSDL
     * - documentation: This container consists of one or more flat-rate shipping discount rules that are set up for a seller's account. This container is returned as an empty element if no flat-rate shipping discount rules are currently set for the
     * seller's account.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\FlatShippingDiscountType
     */
    public $FlatShippingDiscount;
    /**
     * The CalculatedShippingDiscount
     * Meta information extracted from the WSDL
     * - documentation: This container consists of one or more calculated shipping discount rules that are set up for a seller's account. This container is returned as an empty element if no calculated shipping discount rules are currently set for the
     * seller's account.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\CalculatedShippingDiscountType
     */
    public $CalculatedShippingDiscount;
    /**
     * The PromotionalShippingDiscount
     * Meta information extracted from the WSDL
     * - documentation: This field indicates whether or not a seller has set up a promotional shipping discount rule in the seller's account. Only one promotional shipping discount may be defined for a seller's account at any given time. This field is
     * returned whether <code>false</code> or <code>true</code>. If <code>true</code>, details of the rule can be found in the <b>PromotionalShippingDiscountDetails</b> container.
     * - minOccurs: 0
     * @var bool
     */
    public $PromotionalShippingDiscount;
    /**
     * The CalculatedHandlingDiscount
     * Meta information extracted from the WSDL
     * - documentation: This container consists of the handling discount applicable to a calculated shipping discount rule that is set up for a seller's account. This container is not returned if no calculated shipping discount rules are currently set for
     * the seller's account.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\CalculatedHandlingDiscountType
     */
    public $CalculatedHandlingDiscount;
    /**
     * The PromotionalShippingDiscountDetails
     * Meta information extracted from the WSDL
     * - documentation: This container consists of information related to the promotional shipping discount rule that is set up for a seller's account. This container is not returned if no promotional shipping discount rule is set up for the seller's
     * account.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\PromotionalShippingDiscountDetailsType
     */
    public $PromotionalShippingDiscountDetails;
    /**
     * The CombinedDuration
     * Meta information extracted from the WSDL
     * - documentation: This field indicates the number of days after the sale of an item in which the buyer or seller can combine multiple and mutual order line items into one Combined Invoice order. In a Combined Invoice order, the buyer makes one payment
     * for all order line items, hence only unpaid order line items can be combined into a Combined Invoice order.
     * - minOccurs: 0
     * @var string
     */
    public $CombinedDuration;
    /**
     * Constructor method for GetShippingDiscountProfilesResponseType
     * @uses GetShippingDiscountProfilesResponseType::setCurrencyID()
     * @uses GetShippingDiscountProfilesResponseType::setFlatShippingDiscount()
     * @uses GetShippingDiscountProfilesResponseType::setCalculatedShippingDiscount()
     * @uses GetShippingDiscountProfilesResponseType::setPromotionalShippingDiscount()
     * @uses GetShippingDiscountProfilesResponseType::setCalculatedHandlingDiscount()
     * @uses GetShippingDiscountProfilesResponseType::setPromotionalShippingDiscountDetails()
     * @uses GetShippingDiscountProfilesResponseType::setCombinedDuration()
     * @param string $currencyID
     * @param \LewisLarsen\Ebay\StructType\FlatShippingDiscountType $flatShippingDiscount
     * @param \LewisLarsen\Ebay\StructType\CalculatedShippingDiscountType $calculatedShippingDiscount
     * @param bool $promotionalShippingDiscount
     * @param \LewisLarsen\Ebay\StructType\CalculatedHandlingDiscountType $calculatedHandlingDiscount
     * @param \LewisLarsen\Ebay\StructType\PromotionalShippingDiscountDetailsType $promotionalShippingDiscountDetails
     * @param string $combinedDuration
     */
    public function __construct($currencyID = null, \LewisLarsen\Ebay\StructType\FlatShippingDiscountType $flatShippingDiscount = null, \LewisLarsen\Ebay\StructType\CalculatedShippingDiscountType $calculatedShippingDiscount = null, $promotionalShippingDiscount = null, \LewisLarsen\Ebay\StructType\CalculatedHandlingDiscountType $calculatedHandlingDiscount = null, \LewisLarsen\Ebay\StructType\PromotionalShippingDiscountDetailsType $promotionalShippingDiscountDetails = null, $combinedDuration = null)
    {
        $this
            ->setCurrencyID($currencyID)
            ->setFlatShippingDiscount($flatShippingDiscount)
            ->setCalculatedShippingDiscount($calculatedShippingDiscount)
            ->setPromotionalShippingDiscount($promotionalShippingDiscount)
            ->setCalculatedHandlingDiscount($calculatedHandlingDiscount)
            ->setPromotionalShippingDiscountDetails($promotionalShippingDiscountDetails)
            ->setCombinedDuration($combinedDuration);
    }
    /**
     * Get CurrencyID value
     * @return string|null
     */
    public function getCurrencyID()
    {
        return $this->CurrencyID;
    }
    /**
     * Set CurrencyID value
     * @uses \LewisLarsen\Ebay\EnumType\CurrencyCodeType::valueIsValid()
     * @uses \LewisLarsen\Ebay\EnumType\CurrencyCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $currencyID
     * @return \LewisLarsen\Ebay\StructType\GetShippingDiscountProfilesResponseType
     */
    public function setCurrencyID($currencyID = null)
    {
        // validation for constraint: enumeration
        if (!\LewisLarsen\Ebay\EnumType\CurrencyCodeType::valueIsValid($currencyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \LewisLarsen\Ebay\EnumType\CurrencyCodeType', is_array($currencyID) ? implode(', ', $currencyID) : var_export($currencyID, true), implode(', ', \LewisLarsen\Ebay\EnumType\CurrencyCodeType::getValidValues())), __LINE__);
        }
        $this->CurrencyID = $currencyID;
        return $this;
    }
    /**
     * Get FlatShippingDiscount value
     * @return \LewisLarsen\Ebay\StructType\FlatShippingDiscountType|null
     */
    public function getFlatShippingDiscount()
    {
        return $this->FlatShippingDiscount;
    }
    /**
     * Set FlatShippingDiscount value
     * @param \LewisLarsen\Ebay\StructType\FlatShippingDiscountType $flatShippingDiscount
     * @return \LewisLarsen\Ebay\StructType\GetShippingDiscountProfilesResponseType
     */
    public function setFlatShippingDiscount(\LewisLarsen\Ebay\StructType\FlatShippingDiscountType $flatShippingDiscount = null)
    {
        $this->FlatShippingDiscount = $flatShippingDiscount;
        return $this;
    }
    /**
     * Get CalculatedShippingDiscount value
     * @return \LewisLarsen\Ebay\StructType\CalculatedShippingDiscountType|null
     */
    public function getCalculatedShippingDiscount()
    {
        return $this->CalculatedShippingDiscount;
    }
    /**
     * Set CalculatedShippingDiscount value
     * @param \LewisLarsen\Ebay\StructType\CalculatedShippingDiscountType $calculatedShippingDiscount
     * @return \LewisLarsen\Ebay\StructType\GetShippingDiscountProfilesResponseType
     */
    public function setCalculatedShippingDiscount(\LewisLarsen\Ebay\StructType\CalculatedShippingDiscountType $calculatedShippingDiscount = null)
    {
        $this->CalculatedShippingDiscount = $calculatedShippingDiscount;
        return $this;
    }
    /**
     * Get PromotionalShippingDiscount value
     * @return bool|null
     */
    public function getPromotionalShippingDiscount()
    {
        return $this->PromotionalShippingDiscount;
    }
    /**
     * Set PromotionalShippingDiscount value
     * @param bool $promotionalShippingDiscount
     * @return \LewisLarsen\Ebay\StructType\GetShippingDiscountProfilesResponseType
     */
    public function setPromotionalShippingDiscount($promotionalShippingDiscount = null)
    {
        // validation for constraint: boolean
        if (!is_null($promotionalShippingDiscount) && !is_bool($promotionalShippingDiscount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($promotionalShippingDiscount, true), gettype($promotionalShippingDiscount)), __LINE__);
        }
        $this->PromotionalShippingDiscount = $promotionalShippingDiscount;
        return $this;
    }
    /**
     * Get CalculatedHandlingDiscount value
     * @return \LewisLarsen\Ebay\StructType\CalculatedHandlingDiscountType|null
     */
    public function getCalculatedHandlingDiscount()
    {
        return $this->CalculatedHandlingDiscount;
    }
    /**
     * Set CalculatedHandlingDiscount value
     * @param \LewisLarsen\Ebay\StructType\CalculatedHandlingDiscountType $calculatedHandlingDiscount
     * @return \LewisLarsen\Ebay\StructType\GetShippingDiscountProfilesResponseType
     */
    public function setCalculatedHandlingDiscount(\LewisLarsen\Ebay\StructType\CalculatedHandlingDiscountType $calculatedHandlingDiscount = null)
    {
        $this->CalculatedHandlingDiscount = $calculatedHandlingDiscount;
        return $this;
    }
    /**
     * Get PromotionalShippingDiscountDetails value
     * @return \LewisLarsen\Ebay\StructType\PromotionalShippingDiscountDetailsType|null
     */
    public function getPromotionalShippingDiscountDetails()
    {
        return $this->PromotionalShippingDiscountDetails;
    }
    /**
     * Set PromotionalShippingDiscountDetails value
     * @param \LewisLarsen\Ebay\StructType\PromotionalShippingDiscountDetailsType $promotionalShippingDiscountDetails
     * @return \LewisLarsen\Ebay\StructType\GetShippingDiscountProfilesResponseType
     */
    public function setPromotionalShippingDiscountDetails(\LewisLarsen\Ebay\StructType\PromotionalShippingDiscountDetailsType $promotionalShippingDiscountDetails = null)
    {
        $this->PromotionalShippingDiscountDetails = $promotionalShippingDiscountDetails;
        return $this;
    }
    /**
     * Get CombinedDuration value
     * @return string|null
     */
    public function getCombinedDuration()
    {
        return $this->CombinedDuration;
    }
    /**
     * Set CombinedDuration value
     * @uses \LewisLarsen\Ebay\EnumType\CombinedPaymentPeriodCodeType::valueIsValid()
     * @uses \LewisLarsen\Ebay\EnumType\CombinedPaymentPeriodCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $combinedDuration
     * @return \LewisLarsen\Ebay\StructType\GetShippingDiscountProfilesResponseType
     */
    public function setCombinedDuration($combinedDuration = null)
    {
        // validation for constraint: enumeration
        if (!\LewisLarsen\Ebay\EnumType\CombinedPaymentPeriodCodeType::valueIsValid($combinedDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \LewisLarsen\Ebay\EnumType\CombinedPaymentPeriodCodeType', is_array($combinedDuration) ? implode(', ', $combinedDuration) : var_export($combinedDuration, true), implode(', ', \LewisLarsen\Ebay\EnumType\CombinedPaymentPeriodCodeType::getValidValues())), __LINE__);
        }
        $this->CombinedDuration = $combinedDuration;
        return $this;
    }
}
