<?php

namespace LewisLarsen\Ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetMyeBayBuyingRequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Retrieves information regarding a user's buying activity, such as items they are watching, bidding on, have won, did not win, and have made Best Offers on.
 * @subpackage Structs
 */
class GetMyeBayBuyingRequestType extends AbstractRequestType
{
    /**
     * The WatchList
     * Meta information extracted from the WSDL
     * - documentation: Include this container and set the <b>WatchList.Include</b> field to <code>true</code> to return the list of items on the eBay user's Watch List. <br><br> The user also has the option of using pagination and sorting for the list of
     * watched items that will be returned.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\ItemListCustomizationType
     */
    public $WatchList;
    /**
     * The BidList
     * Meta information extracted from the WSDL
     * - documentation: Include this container and set the <b>BidList.Include</b> field to <code>true</code> to return the list of auction items on which the eBay user has bid. <br><br> The user also has the option of using pagination and sorting for the
     * list of auction items that will be returned.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\ItemListCustomizationType
     */
    public $BidList;
    /**
     * The BestOfferList
     * Meta information extracted from the WSDL
     * - documentation: Include this container and set the <b>BestOfferList.Include</b> field to <code>true</code> to return the list of items on which the eBay user has made a Best Offer. <br><br> The user also has the option of using pagination and
     * sorting for the list of items that will be returned.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\ItemListCustomizationType
     */
    public $BestOfferList;
    /**
     * The WonList
     * Meta information extracted from the WSDL
     * - documentation: Include this container and set the <b>WonList.Include</b> field to <code>true</code> to return the list of auction items on which the eBay user has bid on and won. <br><br> The user also has the option of using pagination and sorting
     * for the list of auction items that will be returned.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\ItemListCustomizationType
     */
    public $WonList;
    /**
     * The LostList
     * Meta information extracted from the WSDL
     * - documentation: Include this container and set the <b>LostList.Include</b> field to <code>true</code> to return the list of auction items on which the eBay user has bid on and lost. <br><br> The user also has the option of using pagination and
     * sorting for the list of auction items that will be returned.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\ItemListCustomizationType
     */
    public $LostList;
    /**
     * The FavoriteSearches
     * Meta information extracted from the WSDL
     * - documentation: Include this container and set the <b>FavoriteSearches.Include</b> field to <code>true</code> to return the list of the eBay user's saved searches.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\MyeBaySelectionType
     */
    public $FavoriteSearches;
    /**
     * The FavoriteSellers
     * Meta information extracted from the WSDL
     * - documentation: Include this container and set the <b>FavoriteSellers.Include</b> field to <code>true</code> to return the list of the eBay user's saved sellers.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\MyeBaySelectionType
     */
    public $FavoriteSellers;
    /**
     * The SecondChanceOffer
     * Meta information extracted from the WSDL
     * - documentation: Include this container and set the <b>SecondChanceOffer.Include</b> field to <code>true</code> to return any Second Chance Offers that the eBay user has received.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\MyeBaySelectionType
     */
    public $SecondChanceOffer;
    /**
     * The DeletedFromWonList
     * Meta information extracted from the WSDL
     * - documentation: Include this container and set the <b>DeletedFromWonList.Include</b> field to <code>true</code> to return the list of auction items on which the eBay user has bid on and won, but has deleted from their My eBay page. <br><br> The user
     * also has the option of using pagination and sorting for the list of auction items that will be returned.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\ItemListCustomizationType
     */
    public $DeletedFromWonList;
    /**
     * The DeletedFromLostList
     * Meta information extracted from the WSDL
     * - documentation: Include this container and set the <b>DeletedFromLostList.Include</b> field to <code>true</code> to return the list of auction items on which the eBay user has bid on and lost, and has deleted from their My eBay page. <br><br> The
     * user also has the option of using pagination and sorting for the list of auction items that will be returned.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\ItemListCustomizationType
     */
    public $DeletedFromLostList;
    /**
     * The BuyingSummary
     * Meta information extracted from the WSDL
     * - documentation: Include this container and set the <b>BuyingSummary.Include</b> field to <code>true</code> to return the <b>BuyingSummary</b> container in the response. The <b>BuyingSummary</b> container consists of buying/bidding activity counts
     * and values.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\ItemListCustomizationType
     */
    public $BuyingSummary;
    /**
     * The UserDefinedLists
     * Meta information extracted from the WSDL
     * - documentation: Include this container and set the <b>UserDefinedLists.Include</b> field to <code>true</code> to return one or more user-defined lists. User-defined lists are lists created by the user in My eBay and consists of a combination of
     * items, saved sellers, and/or saved searches.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\MyeBaySelectionType
     */
    public $UserDefinedLists;
    /**
     * The HideVariations
     * Meta information extracted from the WSDL
     * - documentation: If this field is included and set to <code>true</code>, the <b>Variations</b> node (and all variation data) is omitted for all multiple-variation listings in the response. If this field is omitted or set to <code>false</code>, the
     * <b>Variations</b> node is returned for all multiple-variation listings in the response. <br>
     * - minOccurs: 0
     * @var bool
     */
    public $HideVariations;
    /**
     * Constructor method for GetMyeBayBuyingRequestType
     * @uses GetMyeBayBuyingRequestType::setWatchList()
     * @uses GetMyeBayBuyingRequestType::setBidList()
     * @uses GetMyeBayBuyingRequestType::setBestOfferList()
     * @uses GetMyeBayBuyingRequestType::setWonList()
     * @uses GetMyeBayBuyingRequestType::setLostList()
     * @uses GetMyeBayBuyingRequestType::setFavoriteSearches()
     * @uses GetMyeBayBuyingRequestType::setFavoriteSellers()
     * @uses GetMyeBayBuyingRequestType::setSecondChanceOffer()
     * @uses GetMyeBayBuyingRequestType::setDeletedFromWonList()
     * @uses GetMyeBayBuyingRequestType::setDeletedFromLostList()
     * @uses GetMyeBayBuyingRequestType::setBuyingSummary()
     * @uses GetMyeBayBuyingRequestType::setUserDefinedLists()
     * @uses GetMyeBayBuyingRequestType::setHideVariations()
     * @param \LewisLarsen\Ebay\StructType\ItemListCustomizationType $watchList
     * @param \LewisLarsen\Ebay\StructType\ItemListCustomizationType $bidList
     * @param \LewisLarsen\Ebay\StructType\ItemListCustomizationType $bestOfferList
     * @param \LewisLarsen\Ebay\StructType\ItemListCustomizationType $wonList
     * @param \LewisLarsen\Ebay\StructType\ItemListCustomizationType $lostList
     * @param \LewisLarsen\Ebay\StructType\MyeBaySelectionType $favoriteSearches
     * @param \LewisLarsen\Ebay\StructType\MyeBaySelectionType $favoriteSellers
     * @param \LewisLarsen\Ebay\StructType\MyeBaySelectionType $secondChanceOffer
     * @param \LewisLarsen\Ebay\StructType\ItemListCustomizationType $deletedFromWonList
     * @param \LewisLarsen\Ebay\StructType\ItemListCustomizationType $deletedFromLostList
     * @param \LewisLarsen\Ebay\StructType\ItemListCustomizationType $buyingSummary
     * @param \LewisLarsen\Ebay\StructType\MyeBaySelectionType $userDefinedLists
     * @param bool $hideVariations
     */
    public function __construct(\LewisLarsen\Ebay\StructType\ItemListCustomizationType $watchList = null, \LewisLarsen\Ebay\StructType\ItemListCustomizationType $bidList = null, \LewisLarsen\Ebay\StructType\ItemListCustomizationType $bestOfferList = null, \LewisLarsen\Ebay\StructType\ItemListCustomizationType $wonList = null, \LewisLarsen\Ebay\StructType\ItemListCustomizationType $lostList = null, \LewisLarsen\Ebay\StructType\MyeBaySelectionType $favoriteSearches = null, \LewisLarsen\Ebay\StructType\MyeBaySelectionType $favoriteSellers = null, \LewisLarsen\Ebay\StructType\MyeBaySelectionType $secondChanceOffer = null, \LewisLarsen\Ebay\StructType\ItemListCustomizationType $deletedFromWonList = null, \LewisLarsen\Ebay\StructType\ItemListCustomizationType $deletedFromLostList = null, \LewisLarsen\Ebay\StructType\ItemListCustomizationType $buyingSummary = null, \LewisLarsen\Ebay\StructType\MyeBaySelectionType $userDefinedLists = null, $hideVariations = null)
    {
        $this
            ->setWatchList($watchList)
            ->setBidList($bidList)
            ->setBestOfferList($bestOfferList)
            ->setWonList($wonList)
            ->setLostList($lostList)
            ->setFavoriteSearches($favoriteSearches)
            ->setFavoriteSellers($favoriteSellers)
            ->setSecondChanceOffer($secondChanceOffer)
            ->setDeletedFromWonList($deletedFromWonList)
            ->setDeletedFromLostList($deletedFromLostList)
            ->setBuyingSummary($buyingSummary)
            ->setUserDefinedLists($userDefinedLists)
            ->setHideVariations($hideVariations);
    }
    /**
     * Get WatchList value
     * @return \LewisLarsen\Ebay\StructType\ItemListCustomizationType|null
     */
    public function getWatchList()
    {
        return $this->WatchList;
    }
    /**
     * Set WatchList value
     * @param \LewisLarsen\Ebay\StructType\ItemListCustomizationType $watchList
     * @return \LewisLarsen\Ebay\StructType\GetMyeBayBuyingRequestType
     */
    public function setWatchList(\LewisLarsen\Ebay\StructType\ItemListCustomizationType $watchList = null)
    {
        $this->WatchList = $watchList;
        return $this;
    }
    /**
     * Get BidList value
     * @return \LewisLarsen\Ebay\StructType\ItemListCustomizationType|null
     */
    public function getBidList()
    {
        return $this->BidList;
    }
    /**
     * Set BidList value
     * @param \LewisLarsen\Ebay\StructType\ItemListCustomizationType $bidList
     * @return \LewisLarsen\Ebay\StructType\GetMyeBayBuyingRequestType
     */
    public function setBidList(\LewisLarsen\Ebay\StructType\ItemListCustomizationType $bidList = null)
    {
        $this->BidList = $bidList;
        return $this;
    }
    /**
     * Get BestOfferList value
     * @return \LewisLarsen\Ebay\StructType\ItemListCustomizationType|null
     */
    public function getBestOfferList()
    {
        return $this->BestOfferList;
    }
    /**
     * Set BestOfferList value
     * @param \LewisLarsen\Ebay\StructType\ItemListCustomizationType $bestOfferList
     * @return \LewisLarsen\Ebay\StructType\GetMyeBayBuyingRequestType
     */
    public function setBestOfferList(\LewisLarsen\Ebay\StructType\ItemListCustomizationType $bestOfferList = null)
    {
        $this->BestOfferList = $bestOfferList;
        return $this;
    }
    /**
     * Get WonList value
     * @return \LewisLarsen\Ebay\StructType\ItemListCustomizationType|null
     */
    public function getWonList()
    {
        return $this->WonList;
    }
    /**
     * Set WonList value
     * @param \LewisLarsen\Ebay\StructType\ItemListCustomizationType $wonList
     * @return \LewisLarsen\Ebay\StructType\GetMyeBayBuyingRequestType
     */
    public function setWonList(\LewisLarsen\Ebay\StructType\ItemListCustomizationType $wonList = null)
    {
        $this->WonList = $wonList;
        return $this;
    }
    /**
     * Get LostList value
     * @return \LewisLarsen\Ebay\StructType\ItemListCustomizationType|null
     */
    public function getLostList()
    {
        return $this->LostList;
    }
    /**
     * Set LostList value
     * @param \LewisLarsen\Ebay\StructType\ItemListCustomizationType $lostList
     * @return \LewisLarsen\Ebay\StructType\GetMyeBayBuyingRequestType
     */
    public function setLostList(\LewisLarsen\Ebay\StructType\ItemListCustomizationType $lostList = null)
    {
        $this->LostList = $lostList;
        return $this;
    }
    /**
     * Get FavoriteSearches value
     * @return \LewisLarsen\Ebay\StructType\MyeBaySelectionType|null
     */
    public function getFavoriteSearches()
    {
        return $this->FavoriteSearches;
    }
    /**
     * Set FavoriteSearches value
     * @param \LewisLarsen\Ebay\StructType\MyeBaySelectionType $favoriteSearches
     * @return \LewisLarsen\Ebay\StructType\GetMyeBayBuyingRequestType
     */
    public function setFavoriteSearches(\LewisLarsen\Ebay\StructType\MyeBaySelectionType $favoriteSearches = null)
    {
        $this->FavoriteSearches = $favoriteSearches;
        return $this;
    }
    /**
     * Get FavoriteSellers value
     * @return \LewisLarsen\Ebay\StructType\MyeBaySelectionType|null
     */
    public function getFavoriteSellers()
    {
        return $this->FavoriteSellers;
    }
    /**
     * Set FavoriteSellers value
     * @param \LewisLarsen\Ebay\StructType\MyeBaySelectionType $favoriteSellers
     * @return \LewisLarsen\Ebay\StructType\GetMyeBayBuyingRequestType
     */
    public function setFavoriteSellers(\LewisLarsen\Ebay\StructType\MyeBaySelectionType $favoriteSellers = null)
    {
        $this->FavoriteSellers = $favoriteSellers;
        return $this;
    }
    /**
     * Get SecondChanceOffer value
     * @return \LewisLarsen\Ebay\StructType\MyeBaySelectionType|null
     */
    public function getSecondChanceOffer()
    {
        return $this->SecondChanceOffer;
    }
    /**
     * Set SecondChanceOffer value
     * @param \LewisLarsen\Ebay\StructType\MyeBaySelectionType $secondChanceOffer
     * @return \LewisLarsen\Ebay\StructType\GetMyeBayBuyingRequestType
     */
    public function setSecondChanceOffer(\LewisLarsen\Ebay\StructType\MyeBaySelectionType $secondChanceOffer = null)
    {
        $this->SecondChanceOffer = $secondChanceOffer;
        return $this;
    }
    /**
     * Get DeletedFromWonList value
     * @return \LewisLarsen\Ebay\StructType\ItemListCustomizationType|null
     */
    public function getDeletedFromWonList()
    {
        return $this->DeletedFromWonList;
    }
    /**
     * Set DeletedFromWonList value
     * @param \LewisLarsen\Ebay\StructType\ItemListCustomizationType $deletedFromWonList
     * @return \LewisLarsen\Ebay\StructType\GetMyeBayBuyingRequestType
     */
    public function setDeletedFromWonList(\LewisLarsen\Ebay\StructType\ItemListCustomizationType $deletedFromWonList = null)
    {
        $this->DeletedFromWonList = $deletedFromWonList;
        return $this;
    }
    /**
     * Get DeletedFromLostList value
     * @return \LewisLarsen\Ebay\StructType\ItemListCustomizationType|null
     */
    public function getDeletedFromLostList()
    {
        return $this->DeletedFromLostList;
    }
    /**
     * Set DeletedFromLostList value
     * @param \LewisLarsen\Ebay\StructType\ItemListCustomizationType $deletedFromLostList
     * @return \LewisLarsen\Ebay\StructType\GetMyeBayBuyingRequestType
     */
    public function setDeletedFromLostList(\LewisLarsen\Ebay\StructType\ItemListCustomizationType $deletedFromLostList = null)
    {
        $this->DeletedFromLostList = $deletedFromLostList;
        return $this;
    }
    /**
     * Get BuyingSummary value
     * @return \LewisLarsen\Ebay\StructType\ItemListCustomizationType|null
     */
    public function getBuyingSummary()
    {
        return $this->BuyingSummary;
    }
    /**
     * Set BuyingSummary value
     * @param \LewisLarsen\Ebay\StructType\ItemListCustomizationType $buyingSummary
     * @return \LewisLarsen\Ebay\StructType\GetMyeBayBuyingRequestType
     */
    public function setBuyingSummary(\LewisLarsen\Ebay\StructType\ItemListCustomizationType $buyingSummary = null)
    {
        $this->BuyingSummary = $buyingSummary;
        return $this;
    }
    /**
     * Get UserDefinedLists value
     * @return \LewisLarsen\Ebay\StructType\MyeBaySelectionType|null
     */
    public function getUserDefinedLists()
    {
        return $this->UserDefinedLists;
    }
    /**
     * Set UserDefinedLists value
     * @param \LewisLarsen\Ebay\StructType\MyeBaySelectionType $userDefinedLists
     * @return \LewisLarsen\Ebay\StructType\GetMyeBayBuyingRequestType
     */
    public function setUserDefinedLists(\LewisLarsen\Ebay\StructType\MyeBaySelectionType $userDefinedLists = null)
    {
        $this->UserDefinedLists = $userDefinedLists;
        return $this;
    }
    /**
     * Get HideVariations value
     * @return bool|null
     */
    public function getHideVariations()
    {
        return $this->HideVariations;
    }
    /**
     * Set HideVariations value
     * @param bool $hideVariations
     * @return \LewisLarsen\Ebay\StructType\GetMyeBayBuyingRequestType
     */
    public function setHideVariations($hideVariations = null)
    {
        // validation for constraint: boolean
        if (!is_null($hideVariations) && !is_bool($hideVariations)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hideVariations, true), gettype($hideVariations)), __LINE__);
        }
        $this->HideVariations = $hideVariations;
        return $this;
    }
}
