<?php

namespace LewisLarsen\Ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentType StructType
 * Meta information extracted from the WSDL
 * - documentation: Type defining the <b>Shipment</b> container, which is used by the seller in <b>CompleteSale</b> to provide shipping information.
 * @subpackage Structs
 */
class ShipmentType extends AbstractStructBase
{
    /**
     * The ShippedTime
     * Meta information extracted from the WSDL
     * - documentation: The date and time that the seller handed off the package(s) to the shipping carrier. If this field is not included in the request, the timestamp of the call execution is used as the shipped time. Note that sellers have the ability to
     * set this value up to 3 calendar days in the future.
     * - minOccurs: 0
     * @var string
     */
    public $ShippedTime;
    /**
     * The ShipmentTrackingDetails
     * Meta information extracted from the WSDL
     * - documentation: Container consisting of the tracking number and shipping carrier associated with the shipment of one item (package). <br><br> Because an order can have multiple line items and/or packages, there can be multiple
     * <b>ShipmentTrackingDetails</b> containers under the <b>Shipment</b> container.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\ShipmentTrackingDetailsType[]
     */
    public $ShipmentTrackingDetails;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for ShipmentType
     * @uses ShipmentType::setShippedTime()
     * @uses ShipmentType::setShipmentTrackingDetails()
     * @uses ShipmentType::setAny()
     * @param string $shippedTime
     * @param \LewisLarsen\Ebay\StructType\ShipmentTrackingDetailsType[] $shipmentTrackingDetails
     * @param \DOMDocument $any
     */
    public function __construct($shippedTime = null, array $shipmentTrackingDetails = array(), \DOMDocument $any = null)
    {
        $this
            ->setShippedTime($shippedTime)
            ->setShipmentTrackingDetails($shipmentTrackingDetails)
            ->setAny($any);
    }
    /**
     * Get ShippedTime value
     * @return string|null
     */
    public function getShippedTime()
    {
        return $this->ShippedTime;
    }
    /**
     * Set ShippedTime value
     * @param string $shippedTime
     * @return \LewisLarsen\Ebay\StructType\ShipmentType
     */
    public function setShippedTime($shippedTime = null)
    {
        // validation for constraint: string
        if (!is_null($shippedTime) && !is_string($shippedTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippedTime, true), gettype($shippedTime)), __LINE__);
        }
        $this->ShippedTime = $shippedTime;
        return $this;
    }
    /**
     * Get ShipmentTrackingDetails value
     * @return \LewisLarsen\Ebay\StructType\ShipmentTrackingDetailsType[]|null
     */
    public function getShipmentTrackingDetails()
    {
        return $this->ShipmentTrackingDetails;
    }
    /**
     * This method is responsible for validating the values passed to the setShipmentTrackingDetails method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipmentTrackingDetails method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShipmentTrackingDetailsForArrayConstraintsFromSetShipmentTrackingDetails(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentTypeShipmentTrackingDetailsItem) {
            // validation for constraint: itemType
            if (!$shipmentTypeShipmentTrackingDetailsItem instanceof \LewisLarsen\Ebay\StructType\ShipmentTrackingDetailsType) {
                $invalidValues[] = is_object($shipmentTypeShipmentTrackingDetailsItem) ? get_class($shipmentTypeShipmentTrackingDetailsItem) : sprintf('%s(%s)', gettype($shipmentTypeShipmentTrackingDetailsItem), var_export($shipmentTypeShipmentTrackingDetailsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ShipmentTrackingDetails property can only contain items of type \LewisLarsen\Ebay\StructType\ShipmentTrackingDetailsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ShipmentTrackingDetails value
     * @throws \InvalidArgumentException
     * @param \LewisLarsen\Ebay\StructType\ShipmentTrackingDetailsType[] $shipmentTrackingDetails
     * @return \LewisLarsen\Ebay\StructType\ShipmentType
     */
    public function setShipmentTrackingDetails(array $shipmentTrackingDetails = array())
    {
        // validation for constraint: array
        if ('' !== ($shipmentTrackingDetailsArrayErrorMessage = self::validateShipmentTrackingDetailsForArrayConstraintsFromSetShipmentTrackingDetails($shipmentTrackingDetails))) {
            throw new \InvalidArgumentException($shipmentTrackingDetailsArrayErrorMessage, __LINE__);
        }
        $this->ShipmentTrackingDetails = $shipmentTrackingDetails;
        return $this;
    }
    /**
     * Add item to ShipmentTrackingDetails value
     * @throws \InvalidArgumentException
     * @param \LewisLarsen\Ebay\StructType\ShipmentTrackingDetailsType $item
     * @return \LewisLarsen\Ebay\StructType\ShipmentType
     */
    public function addToShipmentTrackingDetails(\LewisLarsen\Ebay\StructType\ShipmentTrackingDetailsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \LewisLarsen\Ebay\StructType\ShipmentTrackingDetailsType) {
            throw new \InvalidArgumentException(sprintf('The ShipmentTrackingDetails property can only contain items of type \LewisLarsen\Ebay\StructType\ShipmentTrackingDetailsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ShipmentTrackingDetails[] = $item;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \LewisLarsen\Ebay\StructType\ShipmentType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
}
