<?php

namespace LewisLarsen\Ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetBidderListResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: Response to GetBidderListRequest. | Response to a <b>GetBidderList</b> call, which retrieves all items the user is currently bidding on, or has won or purchased.
 * @subpackage Structs
 */
class GetBidderListResponseType extends AbstractResponseType
{
    /**
     * The Bidder
     * Meta information extracted from the WSDL
     * - documentation: Data for one eBay bidder.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\UserType
     */
    public $Bidder;
    /**
     * The BidItemArray
     * Meta information extracted from the WSDL
     * - documentation: Array of items the bidder has bid on, has won or has lost.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\ArrayType\ItemArrayType
     */
    public $BidItemArray;
    /**
     * Constructor method for GetBidderListResponseType
     * @uses GetBidderListResponseType::setBidder()
     * @uses GetBidderListResponseType::setBidItemArray()
     * @param \LewisLarsen\Ebay\StructType\UserType $bidder
     * @param \LewisLarsen\Ebay\ArrayType\ItemArrayType $bidItemArray
     */
    public function __construct(\LewisLarsen\Ebay\StructType\UserType $bidder = null, \LewisLarsen\Ebay\ArrayType\ItemArrayType $bidItemArray = null)
    {
        $this
            ->setBidder($bidder)
            ->setBidItemArray($bidItemArray);
    }
    /**
     * Get Bidder value
     * @return \LewisLarsen\Ebay\StructType\UserType|null
     */
    public function getBidder()
    {
        return $this->Bidder;
    }
    /**
     * Set Bidder value
     * @param \LewisLarsen\Ebay\StructType\UserType $bidder
     * @return \LewisLarsen\Ebay\StructType\GetBidderListResponseType
     */
    public function setBidder(\LewisLarsen\Ebay\StructType\UserType $bidder = null)
    {
        $this->Bidder = $bidder;
        return $this;
    }
    /**
     * Get BidItemArray value
     * @return \LewisLarsen\Ebay\ArrayType\ItemArrayType|null
     */
    public function getBidItemArray()
    {
        return $this->BidItemArray;
    }
    /**
     * Set BidItemArray value
     * @param \LewisLarsen\Ebay\ArrayType\ItemArrayType $bidItemArray
     * @return \LewisLarsen\Ebay\StructType\GetBidderListResponseType
     */
    public function setBidItemArray(\LewisLarsen\Ebay\ArrayType\ItemArrayType $bidItemArray = null)
    {
        $this->BidItemArray = $bidItemArray;
        return $this;
    }
}
