<?php

namespace LewisLarsen\Ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentType StructType
 * Meta information extracted from the WSDL
 * - documentation: Type defining the <b>Shipment</b> container, which is used by the seller in <b>CompleteSale</b> to provide shipping information.
 * @subpackage Structs
 */
class ShipmentType extends AbstractStructBase
{
    /**
     * The EstimatedDeliveryDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EstimatedDeliveryDate;
    /**
     * The InsuredValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\AmountType
     */
    public $InsuredValue;
    /**
     * The PackageDepth
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\MeasureType
     */
    public $PackageDepth;
    /**
     * The PackageLength
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\MeasureType
     */
    public $PackageLength;
    /**
     * The PackageWidth
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\MeasureType
     */
    public $PackageWidth;
    /**
     * The PayPalShipmentID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PayPalShipmentID;
    /**
     * The ShipmentID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ShipmentID;
    /**
     * The PostageTotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\AmountType
     */
    public $PostageTotal;
    /**
     * The PrintedTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PrintedTime;
    /**
     * The ShipFromAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\AddressType
     */
    public $ShipFromAddress;
    /**
     * The ShippingAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\AddressType
     */
    public $ShippingAddress;
    /**
     * The ShippingCarrierUsed
     * Meta information extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var string
     */
    public $ShippingCarrierUsed;
    /**
     * The ShippingFeature
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $ShippingFeature;
    /**
     * The ShippingPackage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ShippingPackage;
    /**
     * The ShippingServiceUsed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ShippingServiceUsed;
    /**
     * The ShipmentTrackingNumber
     * Meta information extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var string
     */
    public $ShipmentTrackingNumber;
    /**
     * The WeightMajor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\MeasureType
     */
    public $WeightMajor;
    /**
     * The WeightMinor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\MeasureType
     */
    public $WeightMinor;
    /**
     * The DeliveryDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryDate;
    /**
     * The DeliveryStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryStatus;
    /**
     * The RefundGrantedTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RefundGrantedTime;
    /**
     * The RefundRequestedTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RefundRequestedTime;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The ShippedTime
     * Meta information extracted from the WSDL
     * - documentation: The date and time that the seller handed off the package(s) to the shipping carrier. If this field is not included in the request, the timestamp of the call execution is used as the shipped time. Note that sellers have the ability to
     * set this value up to 3 calendar days in the future.
     * - minOccurs: 0
     * @var string
     */
    public $ShippedTime;
    /**
     * The Notes
     * Meta information extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var string
     */
    public $Notes;
    /**
     * The ShipmentTrackingDetails
     * Meta information extracted from the WSDL
     * - documentation: Container consisting of the tracking number and shipping carrier associated with the shipment of one item (package). <br><br> Because an order can have multiple line items and/or packages, there can be multiple
     * <b>ShipmentTrackingDetails</b> containers under the <b>Shipment</b> container.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\ShipmentTrackingDetailsType[]
     */
    public $ShipmentTrackingDetails;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for ShipmentType
     * @uses ShipmentType::setEstimatedDeliveryDate()
     * @uses ShipmentType::setInsuredValue()
     * @uses ShipmentType::setPackageDepth()
     * @uses ShipmentType::setPackageLength()
     * @uses ShipmentType::setPackageWidth()
     * @uses ShipmentType::setPayPalShipmentID()
     * @uses ShipmentType::setShipmentID()
     * @uses ShipmentType::setPostageTotal()
     * @uses ShipmentType::setPrintedTime()
     * @uses ShipmentType::setShipFromAddress()
     * @uses ShipmentType::setShippingAddress()
     * @uses ShipmentType::setShippingCarrierUsed()
     * @uses ShipmentType::setShippingFeature()
     * @uses ShipmentType::setShippingPackage()
     * @uses ShipmentType::setShippingServiceUsed()
     * @uses ShipmentType::setShipmentTrackingNumber()
     * @uses ShipmentType::setWeightMajor()
     * @uses ShipmentType::setWeightMinor()
     * @uses ShipmentType::setDeliveryDate()
     * @uses ShipmentType::setDeliveryStatus()
     * @uses ShipmentType::setRefundGrantedTime()
     * @uses ShipmentType::setRefundRequestedTime()
     * @uses ShipmentType::setStatus()
     * @uses ShipmentType::setShippedTime()
     * @uses ShipmentType::setNotes()
     * @uses ShipmentType::setShipmentTrackingDetails()
     * @uses ShipmentType::setAny()
     * @param string $estimatedDeliveryDate
     * @param \LewisLarsen\Ebay\StructType\AmountType $insuredValue
     * @param \LewisLarsen\Ebay\StructType\MeasureType $packageDepth
     * @param \LewisLarsen\Ebay\StructType\MeasureType $packageLength
     * @param \LewisLarsen\Ebay\StructType\MeasureType $packageWidth
     * @param string $payPalShipmentID
     * @param int $shipmentID
     * @param \LewisLarsen\Ebay\StructType\AmountType $postageTotal
     * @param string $printedTime
     * @param \LewisLarsen\Ebay\StructType\AddressType $shipFromAddress
     * @param \LewisLarsen\Ebay\StructType\AddressType $shippingAddress
     * @param string $shippingCarrierUsed
     * @param string[] $shippingFeature
     * @param string $shippingPackage
     * @param string $shippingServiceUsed
     * @param string $shipmentTrackingNumber
     * @param \LewisLarsen\Ebay\StructType\MeasureType $weightMajor
     * @param \LewisLarsen\Ebay\StructType\MeasureType $weightMinor
     * @param string $deliveryDate
     * @param string $deliveryStatus
     * @param string $refundGrantedTime
     * @param string $refundRequestedTime
     * @param string $status
     * @param string $shippedTime
     * @param string $notes
     * @param \LewisLarsen\Ebay\StructType\ShipmentTrackingDetailsType[] $shipmentTrackingDetails
     * @param \DOMDocument $any
     */
    public function __construct($estimatedDeliveryDate = null, \LewisLarsen\Ebay\StructType\AmountType $insuredValue = null, \LewisLarsen\Ebay\StructType\MeasureType $packageDepth = null, \LewisLarsen\Ebay\StructType\MeasureType $packageLength = null, \LewisLarsen\Ebay\StructType\MeasureType $packageWidth = null, $payPalShipmentID = null, $shipmentID = null, \LewisLarsen\Ebay\StructType\AmountType $postageTotal = null, $printedTime = null, \LewisLarsen\Ebay\StructType\AddressType $shipFromAddress = null, \LewisLarsen\Ebay\StructType\AddressType $shippingAddress = null, $shippingCarrierUsed = null, array $shippingFeature = array(), $shippingPackage = null, $shippingServiceUsed = null, $shipmentTrackingNumber = null, \LewisLarsen\Ebay\StructType\MeasureType $weightMajor = null, \LewisLarsen\Ebay\StructType\MeasureType $weightMinor = null, $deliveryDate = null, $deliveryStatus = null, $refundGrantedTime = null, $refundRequestedTime = null, $status = null, $shippedTime = null, $notes = null, array $shipmentTrackingDetails = array(), \DOMDocument $any = null)
    {
        $this
            ->setEstimatedDeliveryDate($estimatedDeliveryDate)
            ->setInsuredValue($insuredValue)
            ->setPackageDepth($packageDepth)
            ->setPackageLength($packageLength)
            ->setPackageWidth($packageWidth)
            ->setPayPalShipmentID($payPalShipmentID)
            ->setShipmentID($shipmentID)
            ->setPostageTotal($postageTotal)
            ->setPrintedTime($printedTime)
            ->setShipFromAddress($shipFromAddress)
            ->setShippingAddress($shippingAddress)
            ->setShippingCarrierUsed($shippingCarrierUsed)
            ->setShippingFeature($shippingFeature)
            ->setShippingPackage($shippingPackage)
            ->setShippingServiceUsed($shippingServiceUsed)
            ->setShipmentTrackingNumber($shipmentTrackingNumber)
            ->setWeightMajor($weightMajor)
            ->setWeightMinor($weightMinor)
            ->setDeliveryDate($deliveryDate)
            ->setDeliveryStatus($deliveryStatus)
            ->setRefundGrantedTime($refundGrantedTime)
            ->setRefundRequestedTime($refundRequestedTime)
            ->setStatus($status)
            ->setShippedTime($shippedTime)
            ->setNotes($notes)
            ->setShipmentTrackingDetails($shipmentTrackingDetails)
            ->setAny($any);
    }
    /**
     * Get EstimatedDeliveryDate value
     * @return string|null
     */
    public function getEstimatedDeliveryDate()
    {
        return $this->EstimatedDeliveryDate;
    }
    /**
     * Set EstimatedDeliveryDate value
     * @param string $estimatedDeliveryDate
     * @return \LewisLarsen\Ebay\StructType\ShipmentType
     */
    public function setEstimatedDeliveryDate($estimatedDeliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($estimatedDeliveryDate) && !is_string($estimatedDeliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($estimatedDeliveryDate, true), gettype($estimatedDeliveryDate)), __LINE__);
        }
        $this->EstimatedDeliveryDate = $estimatedDeliveryDate;
        return $this;
    }
    /**
     * Get InsuredValue value
     * @return \LewisLarsen\Ebay\StructType\AmountType|null
     */
    public function getInsuredValue()
    {
        return $this->InsuredValue;
    }
    /**
     * Set InsuredValue value
     * @param \LewisLarsen\Ebay\StructType\AmountType $insuredValue
     * @return \LewisLarsen\Ebay\StructType\ShipmentType
     */
    public function setInsuredValue(\LewisLarsen\Ebay\StructType\AmountType $insuredValue = null)
    {
        $this->InsuredValue = $insuredValue;
        return $this;
    }
    /**
     * Get PackageDepth value
     * @return \LewisLarsen\Ebay\StructType\MeasureType|null
     */
    public function getPackageDepth()
    {
        return $this->PackageDepth;
    }
    /**
     * Set PackageDepth value
     * @param \LewisLarsen\Ebay\StructType\MeasureType $packageDepth
     * @return \LewisLarsen\Ebay\StructType\ShipmentType
     */
    public function setPackageDepth(\LewisLarsen\Ebay\StructType\MeasureType $packageDepth = null)
    {
        $this->PackageDepth = $packageDepth;
        return $this;
    }
    /**
     * Get PackageLength value
     * @return \LewisLarsen\Ebay\StructType\MeasureType|null
     */
    public function getPackageLength()
    {
        return $this->PackageLength;
    }
    /**
     * Set PackageLength value
     * @param \LewisLarsen\Ebay\StructType\MeasureType $packageLength
     * @return \LewisLarsen\Ebay\StructType\ShipmentType
     */
    public function setPackageLength(\LewisLarsen\Ebay\StructType\MeasureType $packageLength = null)
    {
        $this->PackageLength = $packageLength;
        return $this;
    }
    /**
     * Get PackageWidth value
     * @return \LewisLarsen\Ebay\StructType\MeasureType|null
     */
    public function getPackageWidth()
    {
        return $this->PackageWidth;
    }
    /**
     * Set PackageWidth value
     * @param \LewisLarsen\Ebay\StructType\MeasureType $packageWidth
     * @return \LewisLarsen\Ebay\StructType\ShipmentType
     */
    public function setPackageWidth(\LewisLarsen\Ebay\StructType\MeasureType $packageWidth = null)
    {
        $this->PackageWidth = $packageWidth;
        return $this;
    }
    /**
     * Get PayPalShipmentID value
     * @return string|null
     */
    public function getPayPalShipmentID()
    {
        return $this->PayPalShipmentID;
    }
    /**
     * Set PayPalShipmentID value
     * @param string $payPalShipmentID
     * @return \LewisLarsen\Ebay\StructType\ShipmentType
     */
    public function setPayPalShipmentID($payPalShipmentID = null)
    {
        // validation for constraint: string
        if (!is_null($payPalShipmentID) && !is_string($payPalShipmentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payPalShipmentID, true), gettype($payPalShipmentID)), __LINE__);
        }
        $this->PayPalShipmentID = $payPalShipmentID;
        return $this;
    }
    /**
     * Get ShipmentID value
     * @return int|null
     */
    public function getShipmentID()
    {
        return $this->ShipmentID;
    }
    /**
     * Set ShipmentID value
     * @param int $shipmentID
     * @return \LewisLarsen\Ebay\StructType\ShipmentType
     */
    public function setShipmentID($shipmentID = null)
    {
        // validation for constraint: int
        if (!is_null($shipmentID) && !(is_int($shipmentID) || ctype_digit($shipmentID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($shipmentID, true), gettype($shipmentID)), __LINE__);
        }
        $this->ShipmentID = $shipmentID;
        return $this;
    }
    /**
     * Get PostageTotal value
     * @return \LewisLarsen\Ebay\StructType\AmountType|null
     */
    public function getPostageTotal()
    {
        return $this->PostageTotal;
    }
    /**
     * Set PostageTotal value
     * @param \LewisLarsen\Ebay\StructType\AmountType $postageTotal
     * @return \LewisLarsen\Ebay\StructType\ShipmentType
     */
    public function setPostageTotal(\LewisLarsen\Ebay\StructType\AmountType $postageTotal = null)
    {
        $this->PostageTotal = $postageTotal;
        return $this;
    }
    /**
     * Get PrintedTime value
     * @return string|null
     */
    public function getPrintedTime()
    {
        return $this->PrintedTime;
    }
    /**
     * Set PrintedTime value
     * @param string $printedTime
     * @return \LewisLarsen\Ebay\StructType\ShipmentType
     */
    public function setPrintedTime($printedTime = null)
    {
        // validation for constraint: string
        if (!is_null($printedTime) && !is_string($printedTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printedTime, true), gettype($printedTime)), __LINE__);
        }
        $this->PrintedTime = $printedTime;
        return $this;
    }
    /**
     * Get ShipFromAddress value
     * @return \LewisLarsen\Ebay\StructType\AddressType|null
     */
    public function getShipFromAddress()
    {
        return $this->ShipFromAddress;
    }
    /**
     * Set ShipFromAddress value
     * @param \LewisLarsen\Ebay\StructType\AddressType $shipFromAddress
     * @return \LewisLarsen\Ebay\StructType\ShipmentType
     */
    public function setShipFromAddress(\LewisLarsen\Ebay\StructType\AddressType $shipFromAddress = null)
    {
        $this->ShipFromAddress = $shipFromAddress;
        return $this;
    }
    /**
     * Get ShippingAddress value
     * @return \LewisLarsen\Ebay\StructType\AddressType|null
     */
    public function getShippingAddress()
    {
        return $this->ShippingAddress;
    }
    /**
     * Set ShippingAddress value
     * @param \LewisLarsen\Ebay\StructType\AddressType $shippingAddress
     * @return \LewisLarsen\Ebay\StructType\ShipmentType
     */
    public function setShippingAddress(\LewisLarsen\Ebay\StructType\AddressType $shippingAddress = null)
    {
        $this->ShippingAddress = $shippingAddress;
        return $this;
    }
    /**
     * Get ShippingCarrierUsed value
     * @return string|null
     */
    public function getShippingCarrierUsed()
    {
        return $this->ShippingCarrierUsed;
    }
    /**
     * Set ShippingCarrierUsed value
     * @param string $shippingCarrierUsed
     * @return \LewisLarsen\Ebay\StructType\ShipmentType
     */
    public function setShippingCarrierUsed($shippingCarrierUsed = null)
    {
        // validation for constraint: string
        if (!is_null($shippingCarrierUsed) && !is_string($shippingCarrierUsed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingCarrierUsed, true), gettype($shippingCarrierUsed)), __LINE__);
        }
        $this->ShippingCarrierUsed = $shippingCarrierUsed;
        return $this;
    }
    /**
     * Get ShippingFeature value
     * @return string[]|null
     */
    public function getShippingFeature()
    {
        return $this->ShippingFeature;
    }
    /**
     * This method is responsible for validating the values passed to the setShippingFeature method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShippingFeature method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShippingFeatureForArrayConstraintsFromSetShippingFeature(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentTypeShippingFeatureItem) {
            // validation for constraint: enumeration
            if (!\LewisLarsen\Ebay\EnumType\ShippingFeatureCodeType::valueIsValid($shipmentTypeShippingFeatureItem)) {
                $invalidValues[] = is_object($shipmentTypeShippingFeatureItem) ? get_class($shipmentTypeShippingFeatureItem) : sprintf('%s(%s)', gettype($shipmentTypeShippingFeatureItem), var_export($shipmentTypeShippingFeatureItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \LewisLarsen\Ebay\EnumType\ShippingFeatureCodeType', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \LewisLarsen\Ebay\EnumType\ShippingFeatureCodeType::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ShippingFeature value
     * @uses \LewisLarsen\Ebay\EnumType\ShippingFeatureCodeType::valueIsValid()
     * @uses \LewisLarsen\Ebay\EnumType\ShippingFeatureCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $shippingFeature
     * @return \LewisLarsen\Ebay\StructType\ShipmentType
     */
    public function setShippingFeature(array $shippingFeature = array())
    {
        // validation for constraint: array
        if ('' !== ($shippingFeatureArrayErrorMessage = self::validateShippingFeatureForArrayConstraintsFromSetShippingFeature($shippingFeature))) {
            throw new \InvalidArgumentException($shippingFeatureArrayErrorMessage, __LINE__);
        }
        $this->ShippingFeature = $shippingFeature;
        return $this;
    }
    /**
     * Add item to ShippingFeature value
     * @uses \LewisLarsen\Ebay\EnumType\ShippingFeatureCodeType::valueIsValid()
     * @uses \LewisLarsen\Ebay\EnumType\ShippingFeatureCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \LewisLarsen\Ebay\StructType\ShipmentType
     */
    public function addToShippingFeature($item)
    {
        // validation for constraint: enumeration
        if (!\LewisLarsen\Ebay\EnumType\ShippingFeatureCodeType::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \LewisLarsen\Ebay\EnumType\ShippingFeatureCodeType', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \LewisLarsen\Ebay\EnumType\ShippingFeatureCodeType::getValidValues())), __LINE__);
        }
        $this->ShippingFeature[] = $item;
        return $this;
    }
    /**
     * Get ShippingPackage value
     * @return string|null
     */
    public function getShippingPackage()
    {
        return $this->ShippingPackage;
    }
    /**
     * Set ShippingPackage value
     * @uses \LewisLarsen\Ebay\EnumType\ShippingPackageCodeType::valueIsValid()
     * @uses \LewisLarsen\Ebay\EnumType\ShippingPackageCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $shippingPackage
     * @return \LewisLarsen\Ebay\StructType\ShipmentType
     */
    public function setShippingPackage($shippingPackage = null)
    {
        // validation for constraint: enumeration
        if (!\LewisLarsen\Ebay\EnumType\ShippingPackageCodeType::valueIsValid($shippingPackage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \LewisLarsen\Ebay\EnumType\ShippingPackageCodeType', is_array($shippingPackage) ? implode(', ', $shippingPackage) : var_export($shippingPackage, true), implode(', ', \LewisLarsen\Ebay\EnumType\ShippingPackageCodeType::getValidValues())), __LINE__);
        }
        $this->ShippingPackage = $shippingPackage;
        return $this;
    }
    /**
     * Get ShippingServiceUsed value
     * @return string|null
     */
    public function getShippingServiceUsed()
    {
        return $this->ShippingServiceUsed;
    }
    /**
     * Set ShippingServiceUsed value
     * @param string $shippingServiceUsed
     * @return \LewisLarsen\Ebay\StructType\ShipmentType
     */
    public function setShippingServiceUsed($shippingServiceUsed = null)
    {
        // validation for constraint: string
        if (!is_null($shippingServiceUsed) && !is_string($shippingServiceUsed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingServiceUsed, true), gettype($shippingServiceUsed)), __LINE__);
        }
        $this->ShippingServiceUsed = $shippingServiceUsed;
        return $this;
    }
    /**
     * Get ShipmentTrackingNumber value
     * @return string|null
     */
    public function getShipmentTrackingNumber()
    {
        return $this->ShipmentTrackingNumber;
    }
    /**
     * Set ShipmentTrackingNumber value
     * @param string $shipmentTrackingNumber
     * @return \LewisLarsen\Ebay\StructType\ShipmentType
     */
    public function setShipmentTrackingNumber($shipmentTrackingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentTrackingNumber) && !is_string($shipmentTrackingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentTrackingNumber, true), gettype($shipmentTrackingNumber)), __LINE__);
        }
        $this->ShipmentTrackingNumber = $shipmentTrackingNumber;
        return $this;
    }
    /**
     * Get WeightMajor value
     * @return \LewisLarsen\Ebay\StructType\MeasureType|null
     */
    public function getWeightMajor()
    {
        return $this->WeightMajor;
    }
    /**
     * Set WeightMajor value
     * @param \LewisLarsen\Ebay\StructType\MeasureType $weightMajor
     * @return \LewisLarsen\Ebay\StructType\ShipmentType
     */
    public function setWeightMajor(\LewisLarsen\Ebay\StructType\MeasureType $weightMajor = null)
    {
        $this->WeightMajor = $weightMajor;
        return $this;
    }
    /**
     * Get WeightMinor value
     * @return \LewisLarsen\Ebay\StructType\MeasureType|null
     */
    public function getWeightMinor()
    {
        return $this->WeightMinor;
    }
    /**
     * Set WeightMinor value
     * @param \LewisLarsen\Ebay\StructType\MeasureType $weightMinor
     * @return \LewisLarsen\Ebay\StructType\ShipmentType
     */
    public function setWeightMinor(\LewisLarsen\Ebay\StructType\MeasureType $weightMinor = null)
    {
        $this->WeightMinor = $weightMinor;
        return $this;
    }
    /**
     * Get DeliveryDate value
     * @return string|null
     */
    public function getDeliveryDate()
    {
        return $this->DeliveryDate;
    }
    /**
     * Set DeliveryDate value
     * @param string $deliveryDate
     * @return \LewisLarsen\Ebay\StructType\ShipmentType
     */
    public function setDeliveryDate($deliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryDate) && !is_string($deliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryDate, true), gettype($deliveryDate)), __LINE__);
        }
        $this->DeliveryDate = $deliveryDate;
        return $this;
    }
    /**
     * Get DeliveryStatus value
     * @return string|null
     */
    public function getDeliveryStatus()
    {
        return $this->DeliveryStatus;
    }
    /**
     * Set DeliveryStatus value
     * @uses \LewisLarsen\Ebay\EnumType\ShipmentDeliveryStatusCodeType::valueIsValid()
     * @uses \LewisLarsen\Ebay\EnumType\ShipmentDeliveryStatusCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deliveryStatus
     * @return \LewisLarsen\Ebay\StructType\ShipmentType
     */
    public function setDeliveryStatus($deliveryStatus = null)
    {
        // validation for constraint: enumeration
        if (!\LewisLarsen\Ebay\EnumType\ShipmentDeliveryStatusCodeType::valueIsValid($deliveryStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \LewisLarsen\Ebay\EnumType\ShipmentDeliveryStatusCodeType', is_array($deliveryStatus) ? implode(', ', $deliveryStatus) : var_export($deliveryStatus, true), implode(', ', \LewisLarsen\Ebay\EnumType\ShipmentDeliveryStatusCodeType::getValidValues())), __LINE__);
        }
        $this->DeliveryStatus = $deliveryStatus;
        return $this;
    }
    /**
     * Get RefundGrantedTime value
     * @return string|null
     */
    public function getRefundGrantedTime()
    {
        return $this->RefundGrantedTime;
    }
    /**
     * Set RefundGrantedTime value
     * @param string $refundGrantedTime
     * @return \LewisLarsen\Ebay\StructType\ShipmentType
     */
    public function setRefundGrantedTime($refundGrantedTime = null)
    {
        // validation for constraint: string
        if (!is_null($refundGrantedTime) && !is_string($refundGrantedTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refundGrantedTime, true), gettype($refundGrantedTime)), __LINE__);
        }
        $this->RefundGrantedTime = $refundGrantedTime;
        return $this;
    }
    /**
     * Get RefundRequestedTime value
     * @return string|null
     */
    public function getRefundRequestedTime()
    {
        return $this->RefundRequestedTime;
    }
    /**
     * Set RefundRequestedTime value
     * @param string $refundRequestedTime
     * @return \LewisLarsen\Ebay\StructType\ShipmentType
     */
    public function setRefundRequestedTime($refundRequestedTime = null)
    {
        // validation for constraint: string
        if (!is_null($refundRequestedTime) && !is_string($refundRequestedTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refundRequestedTime, true), gettype($refundRequestedTime)), __LINE__);
        }
        $this->RefundRequestedTime = $refundRequestedTime;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \LewisLarsen\Ebay\EnumType\ShipmentStatusCodeType::valueIsValid()
     * @uses \LewisLarsen\Ebay\EnumType\ShipmentStatusCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \LewisLarsen\Ebay\StructType\ShipmentType
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\LewisLarsen\Ebay\EnumType\ShipmentStatusCodeType::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \LewisLarsen\Ebay\EnumType\ShipmentStatusCodeType', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \LewisLarsen\Ebay\EnumType\ShipmentStatusCodeType::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get ShippedTime value
     * @return string|null
     */
    public function getShippedTime()
    {
        return $this->ShippedTime;
    }
    /**
     * Set ShippedTime value
     * @param string $shippedTime
     * @return \LewisLarsen\Ebay\StructType\ShipmentType
     */
    public function setShippedTime($shippedTime = null)
    {
        // validation for constraint: string
        if (!is_null($shippedTime) && !is_string($shippedTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippedTime, true), gettype($shippedTime)), __LINE__);
        }
        $this->ShippedTime = $shippedTime;
        return $this;
    }
    /**
     * Get Notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @param string $notes
     * @return \LewisLarsen\Ebay\StructType\ShipmentType
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notes, true), gettype($notes)), __LINE__);
        }
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Get ShipmentTrackingDetails value
     * @return \LewisLarsen\Ebay\StructType\ShipmentTrackingDetailsType[]|null
     */
    public function getShipmentTrackingDetails()
    {
        return $this->ShipmentTrackingDetails;
    }
    /**
     * This method is responsible for validating the values passed to the setShipmentTrackingDetails method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipmentTrackingDetails method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShipmentTrackingDetailsForArrayConstraintsFromSetShipmentTrackingDetails(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentTypeShipmentTrackingDetailsItem) {
            // validation for constraint: itemType
            if (!$shipmentTypeShipmentTrackingDetailsItem instanceof \LewisLarsen\Ebay\StructType\ShipmentTrackingDetailsType) {
                $invalidValues[] = is_object($shipmentTypeShipmentTrackingDetailsItem) ? get_class($shipmentTypeShipmentTrackingDetailsItem) : sprintf('%s(%s)', gettype($shipmentTypeShipmentTrackingDetailsItem), var_export($shipmentTypeShipmentTrackingDetailsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ShipmentTrackingDetails property can only contain items of type \LewisLarsen\Ebay\StructType\ShipmentTrackingDetailsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ShipmentTrackingDetails value
     * @throws \InvalidArgumentException
     * @param \LewisLarsen\Ebay\StructType\ShipmentTrackingDetailsType[] $shipmentTrackingDetails
     * @return \LewisLarsen\Ebay\StructType\ShipmentType
     */
    public function setShipmentTrackingDetails(array $shipmentTrackingDetails = array())
    {
        // validation for constraint: array
        if ('' !== ($shipmentTrackingDetailsArrayErrorMessage = self::validateShipmentTrackingDetailsForArrayConstraintsFromSetShipmentTrackingDetails($shipmentTrackingDetails))) {
            throw new \InvalidArgumentException($shipmentTrackingDetailsArrayErrorMessage, __LINE__);
        }
        $this->ShipmentTrackingDetails = $shipmentTrackingDetails;
        return $this;
    }
    /**
     * Add item to ShipmentTrackingDetails value
     * @throws \InvalidArgumentException
     * @param \LewisLarsen\Ebay\StructType\ShipmentTrackingDetailsType $item
     * @return \LewisLarsen\Ebay\StructType\ShipmentType
     */
    public function addToShipmentTrackingDetails(\LewisLarsen\Ebay\StructType\ShipmentTrackingDetailsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \LewisLarsen\Ebay\StructType\ShipmentTrackingDetailsType) {
            throw new \InvalidArgumentException(sprintf('The ShipmentTrackingDetails property can only contain items of type \LewisLarsen\Ebay\StructType\ShipmentTrackingDetailsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ShipmentTrackingDetails[] = $item;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \LewisLarsen\Ebay\StructType\ShipmentType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
}
