<?php

namespace LewisLarsen\Ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetBestOffersResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: All Best Offers for the item according to the filter or Best Offer ID (or both) used in the input. For the notification client usage, this response includes a single Best Offer.
 * @subpackage Structs
 */
class GetBestOffersResponseType extends AbstractResponseType
{
    /**
     * The BestOfferArray
     * Meta information extracted from the WSDL
     * - documentation: All Best Offers for the item according to the filter or Best Offer ID (or both) used in the input. The buyer and seller messages are returned only if the detail level is defined. Includes the buyer and seller message only if the
     * <code>ReturnAll</code> detail level is used. Only returned if Best Offers have been made.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\ArrayType\BestOfferArrayType
     */
    public $BestOfferArray;
    /**
     * The Item
     * Meta information extracted from the WSDL
     * - documentation: This container consists of several details about the listing for which a Best Offer has been made, including the Item ID, the current price of the item (not the Best Offer price), and the time that the listing is scheduled to end.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\ItemType
     */
    public $Item;
    /**
     * The ItemBestOffersArray
     * Meta information extracted from the WSDL
     * - documentation: A collection of details about the Best Offers received for a specific item. Empty if there are no Best Offers.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\ItemBestOffersArrayType
     */
    public $ItemBestOffersArray;
    /**
     * The PageNumber
     * Meta information extracted from the WSDL
     * - documentation: This integer value indicates the current page number of Best Offers that is currently being shown. This value will be the same value passed into the <b>Pagination.PageNumber</b> field in the request.
     * - minOccurs: 0
     * @var int
     */
    public $PageNumber;
    /**
     * The PaginationResult
     * Meta information extracted from the WSDL
     * - documentation: Provides information about the data returned, including the number of pages and the number of entries.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\PaginationResultType
     */
    public $PaginationResult;
    /**
     * Constructor method for GetBestOffersResponseType
     * @uses GetBestOffersResponseType::setBestOfferArray()
     * @uses GetBestOffersResponseType::setItem()
     * @uses GetBestOffersResponseType::setItemBestOffersArray()
     * @uses GetBestOffersResponseType::setPageNumber()
     * @uses GetBestOffersResponseType::setPaginationResult()
     * @param \LewisLarsen\Ebay\ArrayType\BestOfferArrayType $bestOfferArray
     * @param \LewisLarsen\Ebay\StructType\ItemType $item
     * @param \LewisLarsen\Ebay\StructType\ItemBestOffersArrayType $itemBestOffersArray
     * @param int $pageNumber
     * @param \LewisLarsen\Ebay\StructType\PaginationResultType $paginationResult
     */
    public function __construct(\LewisLarsen\Ebay\ArrayType\BestOfferArrayType $bestOfferArray = null, \LewisLarsen\Ebay\StructType\ItemType $item = null, \LewisLarsen\Ebay\StructType\ItemBestOffersArrayType $itemBestOffersArray = null, $pageNumber = null, \LewisLarsen\Ebay\StructType\PaginationResultType $paginationResult = null)
    {
        $this
            ->setBestOfferArray($bestOfferArray)
            ->setItem($item)
            ->setItemBestOffersArray($itemBestOffersArray)
            ->setPageNumber($pageNumber)
            ->setPaginationResult($paginationResult);
    }
    /**
     * Get BestOfferArray value
     * @return \LewisLarsen\Ebay\ArrayType\BestOfferArrayType|null
     */
    public function getBestOfferArray()
    {
        return $this->BestOfferArray;
    }
    /**
     * Set BestOfferArray value
     * @param \LewisLarsen\Ebay\ArrayType\BestOfferArrayType $bestOfferArray
     * @return \LewisLarsen\Ebay\StructType\GetBestOffersResponseType
     */
    public function setBestOfferArray(\LewisLarsen\Ebay\ArrayType\BestOfferArrayType $bestOfferArray = null)
    {
        $this->BestOfferArray = $bestOfferArray;
        return $this;
    }
    /**
     * Get Item value
     * @return \LewisLarsen\Ebay\StructType\ItemType|null
     */
    public function getItem()
    {
        return $this->Item;
    }
    /**
     * Set Item value
     * @param \LewisLarsen\Ebay\StructType\ItemType $item
     * @return \LewisLarsen\Ebay\StructType\GetBestOffersResponseType
     */
    public function setItem(\LewisLarsen\Ebay\StructType\ItemType $item = null)
    {
        $this->Item = $item;
        return $this;
    }
    /**
     * Get ItemBestOffersArray value
     * @return \LewisLarsen\Ebay\StructType\ItemBestOffersArrayType|null
     */
    public function getItemBestOffersArray()
    {
        return $this->ItemBestOffersArray;
    }
    /**
     * Set ItemBestOffersArray value
     * @param \LewisLarsen\Ebay\StructType\ItemBestOffersArrayType $itemBestOffersArray
     * @return \LewisLarsen\Ebay\StructType\GetBestOffersResponseType
     */
    public function setItemBestOffersArray(\LewisLarsen\Ebay\StructType\ItemBestOffersArrayType $itemBestOffersArray = null)
    {
        $this->ItemBestOffersArray = $itemBestOffersArray;
        return $this;
    }
    /**
     * Get PageNumber value
     * @return int|null
     */
    public function getPageNumber()
    {
        return $this->PageNumber;
    }
    /**
     * Set PageNumber value
     * @param int $pageNumber
     * @return \LewisLarsen\Ebay\StructType\GetBestOffersResponseType
     */
    public function setPageNumber($pageNumber = null)
    {
        // validation for constraint: int
        if (!is_null($pageNumber) && !(is_int($pageNumber) || ctype_digit($pageNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageNumber, true), gettype($pageNumber)), __LINE__);
        }
        $this->PageNumber = $pageNumber;
        return $this;
    }
    /**
     * Get PaginationResult value
     * @return \LewisLarsen\Ebay\StructType\PaginationResultType|null
     */
    public function getPaginationResult()
    {
        return $this->PaginationResult;
    }
    /**
     * Set PaginationResult value
     * @param \LewisLarsen\Ebay\StructType\PaginationResultType $paginationResult
     * @return \LewisLarsen\Ebay\StructType\GetBestOffersResponseType
     */
    public function setPaginationResult(\LewisLarsen\Ebay\StructType\PaginationResultType $paginationResult = null)
    {
        $this->PaginationResult = $paginationResult;
        return $this;
    }
}
