<?php

namespace LewisLarsen\Ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddressType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains the data for an eBay user's address. This is the base type for a number of user addresses, including seller payment address, buyer shipping address, and buyer and seller registration address.
 * @subpackage Structs
 */
class AddressType extends AbstractStructBase
{
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: <br> The eBay user's name associated with an address on file with eBay. <br> <span class="tablenote"><b>Note: </b> The <b>Seller.RegistrationAddress</b> container and its child fields will stop being returned in
     * <b>GetSellerTransactions</b> on January 31, 2024. </span>
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Street
     * Meta information extracted from the WSDL
     * - documentation: A concatenation of <b>Street1</b> and <b>Street2</b>, primarily used for a registration address.
     * - minOccurs: 0
     * @var string
     */
    public $Street;
    /**
     * The Street1
     * Meta information extracted from the WSDL
     * - documentation: The first line of the user's street address. <br><br> <span class="tablenote"><b>Note: </b> Note the different maximum lengths noted below for different countries. If a street name exceeds the maximum length for the applicable
     * country, the full street name may be expressed through both the <b>Street1</b> and <b>Street2</b> fields. </span>
     * - minOccurs: 0
     * @var string
     */
    public $Street1;
    /**
     * The Street2
     * Meta information extracted from the WSDL
     * - documentation: The second line of the user's street address (such as an apartment number or suite number).<br/><br/> Returned if the user specified a second street value for their address. <br/> <span class="tablenote"><b>Note: </b> In case of
     * <b>Item.SellerContactDetails</b>, <b>Street2</b> can be used to provide City, Address, State, and Zip code (if applicable). </span> <span class="tablenote"><b>Note: </b> Note the different maximum lengths noted below for different countries. If a
     * street name exceeds the maximum length for the applicable country, the full street name may be expressed through both the <b>Street1</b> and <b>Street2</b> fields. </span> <span class="tablenote"><b>Note: </b> In the case of
     * <b>TransactionArray.Transaction.MultiLegShippingDetails.SellerShipmentToLogisticsProvider.ShipToAddress</b>, if the item is being shipped through eBay International Shipping and this address refers to an intermediated warehouse address, the eBay
     * Virtual Tracking number (eVTN) that is used for the domestic leg of the shipment is appended to <b>Street2</b>. This value is generated by eBay when the order is completed. Example:&quot;Reference #1234567890123456&quot;</span>
     * - minOccurs: 0
     * @var string
     */
    public $Street2;
    /**
     * The CityName
     * Meta information extracted from the WSDL
     * - documentation: The city associated with an address on file with eBay. Most addresses include a city name, but not all. For example, Singapore is an island city-state, so <code>SG</code> would appear in the <b>Country</b> field, and 'Singapore' or
     * 'Republic of Singapore' would appear in the <b>CountryName</b> field, but the <b>CityName</b> field is not applicable. <br>
     * - minOccurs: 0
     * @var string
     */
    public $CityName;
    /**
     * The County
     * Meta information extracted from the WSDL
     * - documentation: The county associated with an address on file with eBay. This field should only be passed in or returned if applicable/defined.
     * - minOccurs: 0
     * @var string
     */
    public $County;
    /**
     * The StateOrProvince
     * Meta information extracted from the WSDL
     * - documentation: The state or province associated with an address on file with eBay. Whether it's a state or a province will depend on the region and/or country. This field should only be passed in or returned if applicable/defined. <br>
     * - minOccurs: 0
     * @var string
     */
    public $StateOrProvince;
    /**
     * The Country
     * Meta information extracted from the WSDL
     * - documentation: The two-digit code representing the country of the user.<br> <br> If not provided as input, eBay uses the country associated with the eBay Site ID when the call is made.<br> <br>
     * - minOccurs: 0
     * @var string
     */
    public $Country;
    /**
     * The CountryName
     * Meta information extracted from the WSDL
     * - documentation: The full name of the country associated with an address on file with eBay. <br/>
     * - minOccurs: 0
     * @var string
     */
    public $CountryName;
    /**
     * The Phone
     * Meta information extracted from the WSDL
     * - documentation: User's primary phone number. This may return a value of <code>Invalid Request</code> if you are not authorized to see the user's phone number. <br/><br/> In the US, the area code (3 digits), the prefix (3 digits), the line number (4
     * digits), and phone extension (if specified by the user) are returned in this field. The extension can be one or more digits. Non-breaking spaces are used as delimiters between these phone number components. <br>
     * - minOccurs: 0
     * @var string
     */
    public $Phone;
    /**
     * The PhoneCountryCode
     * Meta information extracted from the WSDL
     * - documentation: Standard ISO code for the country of the user's primary telephone phone number. For Classified Ad listings, this code is used to look up the country's international calling prefix. Both the ISO code and country phone prefix are
     * stored with listings of this type. This field applies to Classified Ad listings only.
     * - minOccurs: 0
     * @var string
     */
    public $PhoneCountryCode;
    /**
     * The PhoneCountryPrefix
     * Meta information extracted from the WSDL
     * - documentation: Country Prefix of the secondary phone number. This value is derived from inputs supplied for <b>PhoneCountryCode</b>. This field applies to Classified Ad listings only.
     * - minOccurs: 0
     * @var string
     */
    public $PhoneCountryPrefix;
    /**
     * The PhoneAreaOrCityCode
     * Meta information extracted from the WSDL
     * - documentation: Area or City Code of a user's primary phone number. This field applies to Classified Ad listings only.
     * - minOccurs: 0
     * @var string
     */
    public $PhoneAreaOrCityCode;
    /**
     * The PhoneLocalNumber
     * Meta information extracted from the WSDL
     * - documentation: The local number portion of the user's primary phone number. This field applies to Classified Ad listings only. <br><br> <b>Note:</b> The full primary phone number is constructed by combining <b>PhoneLocalNumber</b> with
     * <b>PhoneAreaOrCityCode</b> and <b>PhoneCountryPrefix</b>. <br>
     * - minOccurs: 0
     * @var string
     */
    public $PhoneLocalNumber;
    /**
     * The PostalCode
     * Meta information extracted from the WSDL
     * - documentation: User's postal code.<br>
     * - minOccurs: 0
     * @var string
     */
    public $PostalCode;
    /**
     * The AddressID
     * Meta information extracted from the WSDL
     * - documentation: <br> Unique ID for a user's address in the eBay database. This value can help prevent the need to store an address multiple times across multiple orders. The ID changes if a user changes their address. <br> <br> <span
     * class="tablenote"><b>Note:</b> For orders subject to Australian 'Goods and Services' tax (GST), in addition to the unique identifier for the address, the last two digits of the user's Australian Business Number (ABN) will also appear in this field.
     * Australian 'Goods and Services' tax (GST) is automatically charged to buyers outside of Australia when they purchase items on the eBay Australia site. </span> <span class="tablenote"><b>Note: </b> The <b>Seller.RegistrationAddress</b> container and
     * its child fields will stop being returned in <b>GetSellerTransactions</b> on January 31, 2024. </span>
     * - minOccurs: 0
     * @var string
     */
    public $AddressID;
    /**
     * The AddressOwner
     * Meta information extracted from the WSDL
     * - documentation: This enumeration value returned here indicates the company that has the address on file. The value returned here should always be <code>eBay</code>.
     * - minOccurs: 0
     * @var string
     */
    public $AddressOwner;
    /**
     * The AddressStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AddressStatus;
    /**
     * The ExternalAddressID
     * Meta information extracted from the WSDL
     * - documentation: <br> This field is no longer applicable, and should no longer be returned. <br> <span class="tablenote"><b>Note: </b> This field will stop being returned and removed from the WSDL on January 31, 2024. </span>
     * - minOccurs: 0
     * @var string
     */
    public $ExternalAddressID;
    /**
     * The InternationalName
     * Meta information extracted from the WSDL
     * - documentation: Seller's international name that is associated with the payment address. This field is only applicable to seller payment/billing addresses.
     * - minOccurs: 0
     * @var string
     */
    public $InternationalName;
    /**
     * The InternationalStateAndCity
     * Meta information extracted from the WSDL
     * - documentation: International state and city that is associated with the seller's payment address. This field is only applicable to seller payment/billing addresses.
     * - minOccurs: 0
     * @var string
     */
    public $InternationalStateAndCity;
    /**
     * The InternationalStreet
     * Meta information extracted from the WSDL
     * - documentation: Seller's international street address that is associated with the payment address. This field is only applicable to seller payment/billing addresses.
     * - minOccurs: 0
     * @var string
     */
    public $InternationalStreet;
    /**
     * The CompanyName
     * Meta information extracted from the WSDL
     * - documentation: User's company name. This field should only be passed in or returned if applicable/defined.
     * - minOccurs: 0
     * @var string
     */
    public $CompanyName;
    /**
     * The AddressRecordType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AddressRecordType;
    /**
     * The FirstName
     * Meta information extracted from the WSDL
     * - documentation: Displays the first name of the seller (in a business card format) if the seller's <b>SellerBusinessCodeType</b> value is <code>Commercial</code>.
     * - minOccurs: 0
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * Meta information extracted from the WSDL
     * - documentation: Displays the last name of the seller (in a business card format) if the seller's <b>SellerBusinessCodeType</b> is set to <code>Commercial</code>.
     * - minOccurs: 0
     * @var string
     */
    public $LastName;
    /**
     * The Phone2
     * Meta information extracted from the WSDL
     * - documentation: Secondary Phone number of the lead. Not returned if information is unavailable.
     * - minOccurs: 0
     * @var string
     */
    public $Phone2;
    /**
     * The AddressUsage
     * Meta information extracted from the WSDL
     * - documentation: <br> This tag tells whether current address is a default shipping address or one of the shipping addresses in address book. <br> <span class="tablenote"><b>Note: </b> This field will stop being returned and removed from the WSDL on
     * January 31, 2024. </span>
     * - minOccurs: 0
     * @var string
     */
    public $AddressUsage;
    /**
     * The ReferenceID
     * Meta information extracted from the WSDL
     * - documentation: Uniquely identifies an order shipped using the Global Shipping Program. This value is generated by eBay when the order is completed. The international shipping provider uses the <b>ReferenceID</b> as the primary reference when
     * processing the shipment. Sellers must include this value on the package immediately above the street address of the international shipping provider. <br/><br/> Example: "Reference #1234567890123456" <span class="tablenote"><b>Note:</b> International
     * orders being sent through eBay International Shipping also contain reference IDs, but reference IDs for eBay International Shipping will be returned in the <b>Street2</b> field instead. </span>
     * - minOccurs: 0
     * @var string
     */
    public $ReferenceID;
    /**
     * The AddressAttribute
     * Meta information extracted from the WSDL
     * - documentation: <br> This field shows an attribute for the address, and its corresponding value. Currently, this field is only used to display the reference ID for a "Click and Collect" order, but in the future, other address attributes may be
     * returned in this field. <br> <span class="tablenote"><b>Note: </b> The <b>Seller.RegistrationAddress</b> container and its child fields will stop being returned in <b>GetSellerTransactions</b> on January 31, 2024. </span>
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\AddressAttributeType[]
     */
    public $AddressAttribute;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for AddressType
     * @uses AddressType::setName()
     * @uses AddressType::setStreet()
     * @uses AddressType::setStreet1()
     * @uses AddressType::setStreet2()
     * @uses AddressType::setCityName()
     * @uses AddressType::setCounty()
     * @uses AddressType::setStateOrProvince()
     * @uses AddressType::setCountry()
     * @uses AddressType::setCountryName()
     * @uses AddressType::setPhone()
     * @uses AddressType::setPhoneCountryCode()
     * @uses AddressType::setPhoneCountryPrefix()
     * @uses AddressType::setPhoneAreaOrCityCode()
     * @uses AddressType::setPhoneLocalNumber()
     * @uses AddressType::setPostalCode()
     * @uses AddressType::setAddressID()
     * @uses AddressType::setAddressOwner()
     * @uses AddressType::setAddressStatus()
     * @uses AddressType::setExternalAddressID()
     * @uses AddressType::setInternationalName()
     * @uses AddressType::setInternationalStateAndCity()
     * @uses AddressType::setInternationalStreet()
     * @uses AddressType::setCompanyName()
     * @uses AddressType::setAddressRecordType()
     * @uses AddressType::setFirstName()
     * @uses AddressType::setLastName()
     * @uses AddressType::setPhone2()
     * @uses AddressType::setAddressUsage()
     * @uses AddressType::setReferenceID()
     * @uses AddressType::setAddressAttribute()
     * @uses AddressType::setAny()
     * @param string $name
     * @param string $street
     * @param string $street1
     * @param string $street2
     * @param string $cityName
     * @param string $county
     * @param string $stateOrProvince
     * @param string $country
     * @param string $countryName
     * @param string $phone
     * @param string $phoneCountryCode
     * @param string $phoneCountryPrefix
     * @param string $phoneAreaOrCityCode
     * @param string $phoneLocalNumber
     * @param string $postalCode
     * @param string $addressID
     * @param string $addressOwner
     * @param string $addressStatus
     * @param string $externalAddressID
     * @param string $internationalName
     * @param string $internationalStateAndCity
     * @param string $internationalStreet
     * @param string $companyName
     * @param string $addressRecordType
     * @param string $firstName
     * @param string $lastName
     * @param string $phone2
     * @param string $addressUsage
     * @param string $referenceID
     * @param \LewisLarsen\Ebay\StructType\AddressAttributeType[] $addressAttribute
     * @param \DOMDocument $any
     */
    public function __construct($name = null, $street = null, $street1 = null, $street2 = null, $cityName = null, $county = null, $stateOrProvince = null, $country = null, $countryName = null, $phone = null, $phoneCountryCode = null, $phoneCountryPrefix = null, $phoneAreaOrCityCode = null, $phoneLocalNumber = null, $postalCode = null, $addressID = null, $addressOwner = null, $addressStatus = null, $externalAddressID = null, $internationalName = null, $internationalStateAndCity = null, $internationalStreet = null, $companyName = null, $addressRecordType = null, $firstName = null, $lastName = null, $phone2 = null, $addressUsage = null, $referenceID = null, array $addressAttribute = array(), \DOMDocument $any = null)
    {
        $this
            ->setName($name)
            ->setStreet($street)
            ->setStreet1($street1)
            ->setStreet2($street2)
            ->setCityName($cityName)
            ->setCounty($county)
            ->setStateOrProvince($stateOrProvince)
            ->setCountry($country)
            ->setCountryName($countryName)
            ->setPhone($phone)
            ->setPhoneCountryCode($phoneCountryCode)
            ->setPhoneCountryPrefix($phoneCountryPrefix)
            ->setPhoneAreaOrCityCode($phoneAreaOrCityCode)
            ->setPhoneLocalNumber($phoneLocalNumber)
            ->setPostalCode($postalCode)
            ->setAddressID($addressID)
            ->setAddressOwner($addressOwner)
            ->setAddressStatus($addressStatus)
            ->setExternalAddressID($externalAddressID)
            ->setInternationalName($internationalName)
            ->setInternationalStateAndCity($internationalStateAndCity)
            ->setInternationalStreet($internationalStreet)
            ->setCompanyName($companyName)
            ->setAddressRecordType($addressRecordType)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setPhone2($phone2)
            ->setAddressUsage($addressUsage)
            ->setReferenceID($referenceID)
            ->setAddressAttribute($addressAttribute)
            ->setAny($any);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \LewisLarsen\Ebay\StructType\AddressType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Street value
     * @return string|null
     */
    public function getStreet()
    {
        return $this->Street;
    }
    /**
     * Set Street value
     * @param string $street
     * @return \LewisLarsen\Ebay\StructType\AddressType
     */
    public function setStreet($street = null)
    {
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street, true), gettype($street)), __LINE__);
        }
        $this->Street = $street;
        return $this;
    }
    /**
     * Get Street1 value
     * @return string|null
     */
    public function getStreet1()
    {
        return $this->Street1;
    }
    /**
     * Set Street1 value
     * @param string $street1
     * @return \LewisLarsen\Ebay\StructType\AddressType
     */
    public function setStreet1($street1 = null)
    {
        // validation for constraint: string
        if (!is_null($street1) && !is_string($street1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street1, true), gettype($street1)), __LINE__);
        }
        $this->Street1 = $street1;
        return $this;
    }
    /**
     * Get Street2 value
     * @return string|null
     */
    public function getStreet2()
    {
        return $this->Street2;
    }
    /**
     * Set Street2 value
     * @param string $street2
     * @return \LewisLarsen\Ebay\StructType\AddressType
     */
    public function setStreet2($street2 = null)
    {
        // validation for constraint: string
        if (!is_null($street2) && !is_string($street2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street2, true), gettype($street2)), __LINE__);
        }
        $this->Street2 = $street2;
        return $this;
    }
    /**
     * Get CityName value
     * @return string|null
     */
    public function getCityName()
    {
        return $this->CityName;
    }
    /**
     * Set CityName value
     * @param string $cityName
     * @return \LewisLarsen\Ebay\StructType\AddressType
     */
    public function setCityName($cityName = null)
    {
        // validation for constraint: string
        if (!is_null($cityName) && !is_string($cityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cityName, true), gettype($cityName)), __LINE__);
        }
        $this->CityName = $cityName;
        return $this;
    }
    /**
     * Get County value
     * @return string|null
     */
    public function getCounty()
    {
        return $this->County;
    }
    /**
     * Set County value
     * @param string $county
     * @return \LewisLarsen\Ebay\StructType\AddressType
     */
    public function setCounty($county = null)
    {
        // validation for constraint: string
        if (!is_null($county) && !is_string($county)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($county, true), gettype($county)), __LINE__);
        }
        $this->County = $county;
        return $this;
    }
    /**
     * Get StateOrProvince value
     * @return string|null
     */
    public function getStateOrProvince()
    {
        return $this->StateOrProvince;
    }
    /**
     * Set StateOrProvince value
     * @param string $stateOrProvince
     * @return \LewisLarsen\Ebay\StructType\AddressType
     */
    public function setStateOrProvince($stateOrProvince = null)
    {
        // validation for constraint: string
        if (!is_null($stateOrProvince) && !is_string($stateOrProvince)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stateOrProvince, true), gettype($stateOrProvince)), __LINE__);
        }
        $this->StateOrProvince = $stateOrProvince;
        return $this;
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @uses \LewisLarsen\Ebay\EnumType\CountryCodeType::valueIsValid()
     * @uses \LewisLarsen\Ebay\EnumType\CountryCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $country
     * @return \LewisLarsen\Ebay\StructType\AddressType
     */
    public function setCountry($country = null)
    {
        // validation for constraint: enumeration
        if (!\LewisLarsen\Ebay\EnumType\CountryCodeType::valueIsValid($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \LewisLarsen\Ebay\EnumType\CountryCodeType', is_array($country) ? implode(', ', $country) : var_export($country, true), implode(', ', \LewisLarsen\Ebay\EnumType\CountryCodeType::getValidValues())), __LINE__);
        }
        $this->Country = $country;
        return $this;
    }
    /**
     * Get CountryName value
     * @return string|null
     */
    public function getCountryName()
    {
        return $this->CountryName;
    }
    /**
     * Set CountryName value
     * @param string $countryName
     * @return \LewisLarsen\Ebay\StructType\AddressType
     */
    public function setCountryName($countryName = null)
    {
        // validation for constraint: string
        if (!is_null($countryName) && !is_string($countryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryName, true), gettype($countryName)), __LINE__);
        }
        $this->CountryName = $countryName;
        return $this;
    }
    /**
     * Get Phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->Phone;
    }
    /**
     * Set Phone value
     * @param string $phone
     * @return \LewisLarsen\Ebay\StructType\AddressType
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        $this->Phone = $phone;
        return $this;
    }
    /**
     * Get PhoneCountryCode value
     * @return string|null
     */
    public function getPhoneCountryCode()
    {
        return $this->PhoneCountryCode;
    }
    /**
     * Set PhoneCountryCode value
     * @uses \LewisLarsen\Ebay\EnumType\CountryCodeType::valueIsValid()
     * @uses \LewisLarsen\Ebay\EnumType\CountryCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $phoneCountryCode
     * @return \LewisLarsen\Ebay\StructType\AddressType
     */
    public function setPhoneCountryCode($phoneCountryCode = null)
    {
        // validation for constraint: enumeration
        if (!\LewisLarsen\Ebay\EnumType\CountryCodeType::valueIsValid($phoneCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \LewisLarsen\Ebay\EnumType\CountryCodeType', is_array($phoneCountryCode) ? implode(', ', $phoneCountryCode) : var_export($phoneCountryCode, true), implode(', ', \LewisLarsen\Ebay\EnumType\CountryCodeType::getValidValues())), __LINE__);
        }
        $this->PhoneCountryCode = $phoneCountryCode;
        return $this;
    }
    /**
     * Get PhoneCountryPrefix value
     * @return string|null
     */
    public function getPhoneCountryPrefix()
    {
        return $this->PhoneCountryPrefix;
    }
    /**
     * Set PhoneCountryPrefix value
     * @param string $phoneCountryPrefix
     * @return \LewisLarsen\Ebay\StructType\AddressType
     */
    public function setPhoneCountryPrefix($phoneCountryPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($phoneCountryPrefix) && !is_string($phoneCountryPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneCountryPrefix, true), gettype($phoneCountryPrefix)), __LINE__);
        }
        $this->PhoneCountryPrefix = $phoneCountryPrefix;
        return $this;
    }
    /**
     * Get PhoneAreaOrCityCode value
     * @return string|null
     */
    public function getPhoneAreaOrCityCode()
    {
        return $this->PhoneAreaOrCityCode;
    }
    /**
     * Set PhoneAreaOrCityCode value
     * @param string $phoneAreaOrCityCode
     * @return \LewisLarsen\Ebay\StructType\AddressType
     */
    public function setPhoneAreaOrCityCode($phoneAreaOrCityCode = null)
    {
        // validation for constraint: string
        if (!is_null($phoneAreaOrCityCode) && !is_string($phoneAreaOrCityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneAreaOrCityCode, true), gettype($phoneAreaOrCityCode)), __LINE__);
        }
        $this->PhoneAreaOrCityCode = $phoneAreaOrCityCode;
        return $this;
    }
    /**
     * Get PhoneLocalNumber value
     * @return string|null
     */
    public function getPhoneLocalNumber()
    {
        return $this->PhoneLocalNumber;
    }
    /**
     * Set PhoneLocalNumber value
     * @param string $phoneLocalNumber
     * @return \LewisLarsen\Ebay\StructType\AddressType
     */
    public function setPhoneLocalNumber($phoneLocalNumber = null)
    {
        // validation for constraint: string
        if (!is_null($phoneLocalNumber) && !is_string($phoneLocalNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneLocalNumber, true), gettype($phoneLocalNumber)), __LINE__);
        }
        $this->PhoneLocalNumber = $phoneLocalNumber;
        return $this;
    }
    /**
     * Get PostalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->PostalCode;
    }
    /**
     * Set PostalCode value
     * @param string $postalCode
     * @return \LewisLarsen\Ebay\StructType\AddressType
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postalCode, true), gettype($postalCode)), __LINE__);
        }
        $this->PostalCode = $postalCode;
        return $this;
    }
    /**
     * Get AddressID value
     * @return string|null
     */
    public function getAddressID()
    {
        return $this->AddressID;
    }
    /**
     * Set AddressID value
     * @param string $addressID
     * @return \LewisLarsen\Ebay\StructType\AddressType
     */
    public function setAddressID($addressID = null)
    {
        // validation for constraint: string
        if (!is_null($addressID) && !is_string($addressID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressID, true), gettype($addressID)), __LINE__);
        }
        $this->AddressID = $addressID;
        return $this;
    }
    /**
     * Get AddressOwner value
     * @return string|null
     */
    public function getAddressOwner()
    {
        return $this->AddressOwner;
    }
    /**
     * Set AddressOwner value
     * @uses \LewisLarsen\Ebay\EnumType\AddressOwnerCodeType::valueIsValid()
     * @uses \LewisLarsen\Ebay\EnumType\AddressOwnerCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $addressOwner
     * @return \LewisLarsen\Ebay\StructType\AddressType
     */
    public function setAddressOwner($addressOwner = null)
    {
        // validation for constraint: enumeration
        if (!\LewisLarsen\Ebay\EnumType\AddressOwnerCodeType::valueIsValid($addressOwner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \LewisLarsen\Ebay\EnumType\AddressOwnerCodeType', is_array($addressOwner) ? implode(', ', $addressOwner) : var_export($addressOwner, true), implode(', ', \LewisLarsen\Ebay\EnumType\AddressOwnerCodeType::getValidValues())), __LINE__);
        }
        $this->AddressOwner = $addressOwner;
        return $this;
    }
    /**
     * Get AddressStatus value
     * @return string|null
     */
    public function getAddressStatus()
    {
        return $this->AddressStatus;
    }
    /**
     * Set AddressStatus value
     * @uses \LewisLarsen\Ebay\EnumType\AddressStatusCodeType::valueIsValid()
     * @uses \LewisLarsen\Ebay\EnumType\AddressStatusCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $addressStatus
     * @return \LewisLarsen\Ebay\StructType\AddressType
     */
    public function setAddressStatus($addressStatus = null)
    {
        // validation for constraint: enumeration
        if (!\LewisLarsen\Ebay\EnumType\AddressStatusCodeType::valueIsValid($addressStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \LewisLarsen\Ebay\EnumType\AddressStatusCodeType', is_array($addressStatus) ? implode(', ', $addressStatus) : var_export($addressStatus, true), implode(', ', \LewisLarsen\Ebay\EnumType\AddressStatusCodeType::getValidValues())), __LINE__);
        }
        $this->AddressStatus = $addressStatus;
        return $this;
    }
    /**
     * Get ExternalAddressID value
     * @return string|null
     */
    public function getExternalAddressID()
    {
        return $this->ExternalAddressID;
    }
    /**
     * Set ExternalAddressID value
     * @param string $externalAddressID
     * @return \LewisLarsen\Ebay\StructType\AddressType
     */
    public function setExternalAddressID($externalAddressID = null)
    {
        // validation for constraint: string
        if (!is_null($externalAddressID) && !is_string($externalAddressID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalAddressID, true), gettype($externalAddressID)), __LINE__);
        }
        $this->ExternalAddressID = $externalAddressID;
        return $this;
    }
    /**
     * Get InternationalName value
     * @return string|null
     */
    public function getInternationalName()
    {
        return $this->InternationalName;
    }
    /**
     * Set InternationalName value
     * @param string $internationalName
     * @return \LewisLarsen\Ebay\StructType\AddressType
     */
    public function setInternationalName($internationalName = null)
    {
        // validation for constraint: string
        if (!is_null($internationalName) && !is_string($internationalName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internationalName, true), gettype($internationalName)), __LINE__);
        }
        $this->InternationalName = $internationalName;
        return $this;
    }
    /**
     * Get InternationalStateAndCity value
     * @return string|null
     */
    public function getInternationalStateAndCity()
    {
        return $this->InternationalStateAndCity;
    }
    /**
     * Set InternationalStateAndCity value
     * @param string $internationalStateAndCity
     * @return \LewisLarsen\Ebay\StructType\AddressType
     */
    public function setInternationalStateAndCity($internationalStateAndCity = null)
    {
        // validation for constraint: string
        if (!is_null($internationalStateAndCity) && !is_string($internationalStateAndCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internationalStateAndCity, true), gettype($internationalStateAndCity)), __LINE__);
        }
        $this->InternationalStateAndCity = $internationalStateAndCity;
        return $this;
    }
    /**
     * Get InternationalStreet value
     * @return string|null
     */
    public function getInternationalStreet()
    {
        return $this->InternationalStreet;
    }
    /**
     * Set InternationalStreet value
     * @param string $internationalStreet
     * @return \LewisLarsen\Ebay\StructType\AddressType
     */
    public function setInternationalStreet($internationalStreet = null)
    {
        // validation for constraint: string
        if (!is_null($internationalStreet) && !is_string($internationalStreet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internationalStreet, true), gettype($internationalStreet)), __LINE__);
        }
        $this->InternationalStreet = $internationalStreet;
        return $this;
    }
    /**
     * Get CompanyName value
     * @return string|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * Set CompanyName value
     * @param string $companyName
     * @return \LewisLarsen\Ebay\StructType\AddressType
     */
    public function setCompanyName($companyName = null)
    {
        // validation for constraint: string
        if (!is_null($companyName) && !is_string($companyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyName, true), gettype($companyName)), __LINE__);
        }
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Get AddressRecordType value
     * @return string|null
     */
    public function getAddressRecordType()
    {
        return $this->AddressRecordType;
    }
    /**
     * Set AddressRecordType value
     * @uses \LewisLarsen\Ebay\EnumType\AddressRecordTypeCodeType::valueIsValid()
     * @uses \LewisLarsen\Ebay\EnumType\AddressRecordTypeCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $addressRecordType
     * @return \LewisLarsen\Ebay\StructType\AddressType
     */
    public function setAddressRecordType($addressRecordType = null)
    {
        // validation for constraint: enumeration
        if (!\LewisLarsen\Ebay\EnumType\AddressRecordTypeCodeType::valueIsValid($addressRecordType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \LewisLarsen\Ebay\EnumType\AddressRecordTypeCodeType', is_array($addressRecordType) ? implode(', ', $addressRecordType) : var_export($addressRecordType, true), implode(', ', \LewisLarsen\Ebay\EnumType\AddressRecordTypeCodeType::getValidValues())), __LINE__);
        }
        $this->AddressRecordType = $addressRecordType;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \LewisLarsen\Ebay\StructType\AddressType
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \LewisLarsen\Ebay\StructType\AddressType
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get Phone2 value
     * @return string|null
     */
    public function getPhone2()
    {
        return $this->Phone2;
    }
    /**
     * Set Phone2 value
     * @param string $phone2
     * @return \LewisLarsen\Ebay\StructType\AddressType
     */
    public function setPhone2($phone2 = null)
    {
        // validation for constraint: string
        if (!is_null($phone2) && !is_string($phone2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone2, true), gettype($phone2)), __LINE__);
        }
        $this->Phone2 = $phone2;
        return $this;
    }
    /**
     * Get AddressUsage value
     * @return string|null
     */
    public function getAddressUsage()
    {
        return $this->AddressUsage;
    }
    /**
     * Set AddressUsage value
     * @uses \LewisLarsen\Ebay\EnumType\AddressUsageCodeType::valueIsValid()
     * @uses \LewisLarsen\Ebay\EnumType\AddressUsageCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $addressUsage
     * @return \LewisLarsen\Ebay\StructType\AddressType
     */
    public function setAddressUsage($addressUsage = null)
    {
        // validation for constraint: enumeration
        if (!\LewisLarsen\Ebay\EnumType\AddressUsageCodeType::valueIsValid($addressUsage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \LewisLarsen\Ebay\EnumType\AddressUsageCodeType', is_array($addressUsage) ? implode(', ', $addressUsage) : var_export($addressUsage, true), implode(', ', \LewisLarsen\Ebay\EnumType\AddressUsageCodeType::getValidValues())), __LINE__);
        }
        $this->AddressUsage = $addressUsage;
        return $this;
    }
    /**
     * Get ReferenceID value
     * @return string|null
     */
    public function getReferenceID()
    {
        return $this->ReferenceID;
    }
    /**
     * Set ReferenceID value
     * @param string $referenceID
     * @return \LewisLarsen\Ebay\StructType\AddressType
     */
    public function setReferenceID($referenceID = null)
    {
        // validation for constraint: string
        if (!is_null($referenceID) && !is_string($referenceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceID, true), gettype($referenceID)), __LINE__);
        }
        $this->ReferenceID = $referenceID;
        return $this;
    }
    /**
     * Get AddressAttribute value
     * @return \LewisLarsen\Ebay\StructType\AddressAttributeType[]|null
     */
    public function getAddressAttribute()
    {
        return $this->AddressAttribute;
    }
    /**
     * This method is responsible for validating the values passed to the setAddressAttribute method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddressAttribute method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddressAttributeForArrayConstraintsFromSetAddressAttribute(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $addressTypeAddressAttributeItem) {
            // validation for constraint: itemType
            if (!$addressTypeAddressAttributeItem instanceof \LewisLarsen\Ebay\StructType\AddressAttributeType) {
                $invalidValues[] = is_object($addressTypeAddressAttributeItem) ? get_class($addressTypeAddressAttributeItem) : sprintf('%s(%s)', gettype($addressTypeAddressAttributeItem), var_export($addressTypeAddressAttributeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AddressAttribute property can only contain items of type \LewisLarsen\Ebay\StructType\AddressAttributeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AddressAttribute value
     * @throws \InvalidArgumentException
     * @param \LewisLarsen\Ebay\StructType\AddressAttributeType[] $addressAttribute
     * @return \LewisLarsen\Ebay\StructType\AddressType
     */
    public function setAddressAttribute(array $addressAttribute = array())
    {
        // validation for constraint: array
        if ('' !== ($addressAttributeArrayErrorMessage = self::validateAddressAttributeForArrayConstraintsFromSetAddressAttribute($addressAttribute))) {
            throw new \InvalidArgumentException($addressAttributeArrayErrorMessage, __LINE__);
        }
        $this->AddressAttribute = $addressAttribute;
        return $this;
    }
    /**
     * Add item to AddressAttribute value
     * @throws \InvalidArgumentException
     * @param \LewisLarsen\Ebay\StructType\AddressAttributeType $item
     * @return \LewisLarsen\Ebay\StructType\AddressType
     */
    public function addToAddressAttribute(\LewisLarsen\Ebay\StructType\AddressAttributeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \LewisLarsen\Ebay\StructType\AddressAttributeType) {
            throw new \InvalidArgumentException(sprintf('The AddressAttribute property can only contain items of type \LewisLarsen\Ebay\StructType\AddressAttributeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AddressAttribute[] = $item;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \LewisLarsen\Ebay\StructType\AddressType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
}
