<?php

namespace LewisLarsen\Ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BidGroupItemType StructType
 * Meta information extracted from the WSDL
 * - documentation: This type is deprecated.
 * @subpackage Structs
 */
class BidGroupItemType extends AbstractStructBase
{
    /**
     * The Item
     * Meta information extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\ItemType
     */
    public $Item;
    /**
     * The BidGroupItemStatus
     * Meta information extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var string
     */
    public $BidGroupItemStatus;
    /**
     * The MaxBidAmount
     * Meta information extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \LewisLarsen\Ebay\StructType\AmountType
     */
    public $MaxBidAmount;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for BidGroupItemType
     * @uses BidGroupItemType::setItem()
     * @uses BidGroupItemType::setBidGroupItemStatus()
     * @uses BidGroupItemType::setMaxBidAmount()
     * @uses BidGroupItemType::setAny()
     * @param \LewisLarsen\Ebay\StructType\ItemType $item
     * @param string $bidGroupItemStatus
     * @param \LewisLarsen\Ebay\StructType\AmountType $maxBidAmount
     * @param \DOMDocument $any
     */
    public function __construct(\LewisLarsen\Ebay\StructType\ItemType $item = null, $bidGroupItemStatus = null, \LewisLarsen\Ebay\StructType\AmountType $maxBidAmount = null, \DOMDocument $any = null)
    {
        $this
            ->setItem($item)
            ->setBidGroupItemStatus($bidGroupItemStatus)
            ->setMaxBidAmount($maxBidAmount)
            ->setAny($any);
    }
    /**
     * Get Item value
     * @return \LewisLarsen\Ebay\StructType\ItemType|null
     */
    public function getItem()
    {
        return $this->Item;
    }
    /**
     * Set Item value
     * @param \LewisLarsen\Ebay\StructType\ItemType $item
     * @return \LewisLarsen\Ebay\StructType\BidGroupItemType
     */
    public function setItem(\LewisLarsen\Ebay\StructType\ItemType $item = null)
    {
        $this->Item = $item;
        return $this;
    }
    /**
     * Get BidGroupItemStatus value
     * @return string|null
     */
    public function getBidGroupItemStatus()
    {
        return $this->BidGroupItemStatus;
    }
    /**
     * Set BidGroupItemStatus value
     * @uses \LewisLarsen\Ebay\EnumType\BidGroupItemStatusCodeType::valueIsValid()
     * @uses \LewisLarsen\Ebay\EnumType\BidGroupItemStatusCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $bidGroupItemStatus
     * @return \LewisLarsen\Ebay\StructType\BidGroupItemType
     */
    public function setBidGroupItemStatus($bidGroupItemStatus = null)
    {
        // validation for constraint: enumeration
        if (!\LewisLarsen\Ebay\EnumType\BidGroupItemStatusCodeType::valueIsValid($bidGroupItemStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \LewisLarsen\Ebay\EnumType\BidGroupItemStatusCodeType', is_array($bidGroupItemStatus) ? implode(', ', $bidGroupItemStatus) : var_export($bidGroupItemStatus, true), implode(', ', \LewisLarsen\Ebay\EnumType\BidGroupItemStatusCodeType::getValidValues())), __LINE__);
        }
        $this->BidGroupItemStatus = $bidGroupItemStatus;
        return $this;
    }
    /**
     * Get MaxBidAmount value
     * @return \LewisLarsen\Ebay\StructType\AmountType|null
     */
    public function getMaxBidAmount()
    {
        return $this->MaxBidAmount;
    }
    /**
     * Set MaxBidAmount value
     * @param \LewisLarsen\Ebay\StructType\AmountType $maxBidAmount
     * @return \LewisLarsen\Ebay\StructType\BidGroupItemType
     */
    public function setMaxBidAmount(\LewisLarsen\Ebay\StructType\AmountType $maxBidAmount = null)
    {
        $this->MaxBidAmount = $maxBidAmount;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \LewisLarsen\Ebay\StructType\BidGroupItemType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
}
