<?php

namespace CTT_NMODA\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetCurrrencyList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CTT_NMODA\StructType\GetCurrrencyList $parameters
     * @return \CTT_NMODA\StructType\GetCurrrencyListResponse|bool
     */
    public function GetCurrrencyList(\CTT_NMODA\StructType\GetCurrrencyList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCurrrencyList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPudoType
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CTT_NMODA\StructType\GetPudoType $parameters
     * @return \CTT_NMODA\StructType\GetPudoTypeResponse|bool
     */
    public function GetPudoType(\CTT_NMODA\StructType\GetPudoType $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPudoType($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetProductCodesByPrefix
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CTT_NMODA\StructType\GetProductCodesByPrefix $parameters
     * @return \CTT_NMODA\StructType\GetProductCodesByPrefixResponse|bool
     */
    public function GetProductCodesByPrefix(\CTT_NMODA\StructType\GetProductCodesByPrefix $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetProductCodesByPrefix($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \CTT_NMODA\StructType\GetCurrrencyListResponse|\CTT_NMODA\StructType\GetProductCodesByPrefixResponse|\CTT_NMODA\StructType\GetPudoTypeResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
