<?php

namespace CTT_NMODA\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ObterPontosEntregaInternacionais StructType
 * @subpackage Structs
 */
class ObterPontosEntregaInternacionais extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ID;
    /**
     * The input
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \CTT_NMODA\StructType\PudoInternacionalInput
     */
    public $input;
    /**
     * Constructor method for ObterPontosEntregaInternacionais
     * @uses ObterPontosEntregaInternacionais::setID()
     * @uses ObterPontosEntregaInternacionais::setInput()
     * @param string $iD
     * @param \CTT_NMODA\StructType\PudoInternacionalInput $input
     */
    public function __construct($iD = null, \CTT_NMODA\StructType\PudoInternacionalInput $input = null)
    {
        $this
            ->setID($iD)
            ->setInput($input);
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \CTT_NMODA\StructType\ObterPontosEntregaInternacionais
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($iD) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($iD, true)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get input value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CTT_NMODA\StructType\PudoInternacionalInput|null
     */
    public function getInput()
    {
        return isset($this->input) ? $this->input : null;
    }
    /**
     * Set input value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CTT_NMODA\StructType\PudoInternacionalInput $input
     * @return \CTT_NMODA\StructType\ObterPontosEntregaInternacionais
     */
    public function setInput(\CTT_NMODA\StructType\PudoInternacionalInput $input = null)
    {
        if (is_null($input) || (is_array($input) && empty($input))) {
            unset($this->input);
        } else {
            $this->input = $input;
        }
        return $this;
    }
}
