<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for vereinbarungenRechtsschutz StructType
 * @subpackage Structs
 */
class VereinbarungenRechtsschutz extends AbstractStructBase
{
    /**
     * The sonderrabattRechtsschutz
     * Meta information extracted from the WSDL
     * - base: xs:decimal
     * - fractionDigits: 2
     * - maxInclusive: 100
     * - minInclusive: 0
     * @var float
     */
    public $sonderrabattRechtsschutz;
    /**
     * Constructor method for vereinbarungenRechtsschutz
     * @uses VereinbarungenRechtsschutz::setSonderrabattRechtsschutz()
     * @param float $sonderrabattRechtsschutz
     */
    public function __construct($sonderrabattRechtsschutz = null)
    {
        $this
            ->setSonderrabattRechtsschutz($sonderrabattRechtsschutz);
    }
    /**
     * Get sonderrabattRechtsschutz value
     * @return float|null
     */
    public function getSonderrabattRechtsschutz()
    {
        return $this->sonderrabattRechtsschutz;
    }
    /**
     * Set sonderrabattRechtsschutz value
     * @param float $sonderrabattRechtsschutz
     * @return \StructType\VereinbarungenRechtsschutz
     */
    public function setSonderrabattRechtsschutz($sonderrabattRechtsschutz = null)
    {
        // validation for constraint: float
        if (!is_null($sonderrabattRechtsschutz) && !(is_float($sonderrabattRechtsschutz) || is_numeric($sonderrabattRechtsschutz))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($sonderrabattRechtsschutz, true), gettype($sonderrabattRechtsschutz)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($sonderrabattRechtsschutz) && mb_strlen(mb_substr($sonderrabattRechtsschutz, mb_strpos($sonderrabattRechtsschutz, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($sonderrabattRechtsschutz, true), mb_strlen(mb_substr($sonderrabattRechtsschutz, mb_strpos($sonderrabattRechtsschutz, '.') + 1))), __LINE__);
        }
        // validation for constraint: maxInclusive(100)
        if (!is_null($sonderrabattRechtsschutz) && $sonderrabattRechtsschutz > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 100', var_export($sonderrabattRechtsschutz, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($sonderrabattRechtsschutz) && $sonderrabattRechtsschutz < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($sonderrabattRechtsschutz, true)), __LINE__);
        }
        $this->sonderrabattRechtsschutz = $sonderrabattRechtsschutz;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VereinbarungenRechtsschutz
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
