<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for transferSignedDocumentRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Request for sending a signed document to fipos
 * @subpackage Structs
 */
class TransferSignedDocumentRequest extends AbstractStructBase
{
    /**
     * The login
     * Meta information extracted from the WSDL
     * - documentation: login data of user
     * @var \StructType\Login
     */
    public $login;
    /**
     * The printDocument
     * @var \StructType\PrintDocument
     */
    public $printDocument;
    /**
     * Constructor method for transferSignedDocumentRequest
     * @uses TransferSignedDocumentRequest::setLogin()
     * @uses TransferSignedDocumentRequest::setPrintDocument()
     * @param \StructType\Login $login
     * @param \StructType\PrintDocument $printDocument
     */
    public function __construct(\StructType\Login $login = null, \StructType\PrintDocument $printDocument = null)
    {
        $this
            ->setLogin($login)
            ->setPrintDocument($printDocument);
    }
    /**
     * Get login value
     * @return \StructType\Login|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param \StructType\Login $login
     * @return \StructType\TransferSignedDocumentRequest
     */
    public function setLogin(\StructType\Login $login = null)
    {
        $this->login = $login;
        return $this;
    }
    /**
     * Get printDocument value
     * @return \StructType\PrintDocument|null
     */
    public function getPrintDocument()
    {
        return $this->printDocument;
    }
    /**
     * Set printDocument value
     * @param \StructType\PrintDocument $printDocument
     * @return \StructType\TransferSignedDocumentRequest
     */
    public function setPrintDocument(\StructType\PrintDocument $printDocument = null)
    {
        $this->printDocument = $printDocument;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TransferSignedDocumentRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
