<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for transferBusinessCaseRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Request um die Übertragung eines Geschäftsfalles anzustoßen
 * @subpackage Structs
 */
class TransferBusinessCaseRequest extends AbstractStructBase
{
    /**
     * The login
     * Meta information extracted from the WSDL
     * - documentation: login user
     * @var \StructType\Login
     */
    public $login;
    /**
     * The documentID
     * Meta information extracted from the WSDL
     * - documentation: Generali-interne ID zum Referenzieren der Geschäftsfälle
     * - base: xsd:string
     * - maxLength: 23
     * @var string
     */
    public $documentID;
    /**
     * The externalUserID
     * Meta information extracted from the WSDL
     * - documentation: externe UserID die im Antrags Header gesendet wird
     * - base: xsd:string
     * - maxLength: 100
     * - minOccurs: 0
     * @var string
     */
    public $externalUserID;
    /**
     * The check
     * Meta information extracted from the WSDL
     * - documentation: soll beim übertragen auf berechtigung geprüft werden
     * - base: xsd:boolean
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $check;
    /**
     * Constructor method for transferBusinessCaseRequest
     * @uses TransferBusinessCaseRequest::setLogin()
     * @uses TransferBusinessCaseRequest::setDocumentID()
     * @uses TransferBusinessCaseRequest::setExternalUserID()
     * @uses TransferBusinessCaseRequest::setCheck()
     * @param \StructType\Login $login
     * @param string $documentID
     * @param string $externalUserID
     * @param bool $check
     */
    public function __construct(\StructType\Login $login = null, $documentID = null, $externalUserID = null, $check = true)
    {
        $this
            ->setLogin($login)
            ->setDocumentID($documentID)
            ->setExternalUserID($externalUserID)
            ->setCheck($check);
    }
    /**
     * Get login value
     * @return \StructType\Login|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param \StructType\Login $login
     * @return \StructType\TransferBusinessCaseRequest
     */
    public function setLogin(\StructType\Login $login = null)
    {
        $this->login = $login;
        return $this;
    }
    /**
     * Get documentID value
     * @return string|null
     */
    public function getDocumentID()
    {
        return $this->documentID;
    }
    /**
     * Set documentID value
     * @param string $documentID
     * @return \StructType\TransferBusinessCaseRequest
     */
    public function setDocumentID($documentID = null)
    {
        // validation for constraint: string
        if (!is_null($documentID) && !is_string($documentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentID, true), gettype($documentID)), __LINE__);
        }
        // validation for constraint: maxLength(23)
        if (!is_null($documentID) && mb_strlen($documentID) > 23) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 23', mb_strlen($documentID)), __LINE__);
        }
        $this->documentID = $documentID;
        return $this;
    }
    /**
     * Get externalUserID value
     * @return string|null
     */
    public function getExternalUserID()
    {
        return $this->externalUserID;
    }
    /**
     * Set externalUserID value
     * @param string $externalUserID
     * @return \StructType\TransferBusinessCaseRequest
     */
    public function setExternalUserID($externalUserID = null)
    {
        // validation for constraint: string
        if (!is_null($externalUserID) && !is_string($externalUserID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalUserID, true), gettype($externalUserID)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($externalUserID) && mb_strlen($externalUserID) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($externalUserID)), __LINE__);
        }
        $this->externalUserID = $externalUserID;
        return $this;
    }
    /**
     * Get check value
     * @return bool|null
     */
    public function getCheck()
    {
        return $this->check;
    }
    /**
     * Set check value
     * @param bool $check
     * @return \StructType\TransferBusinessCaseRequest
     */
    public function setCheck($check = true)
    {
        // validation for constraint: boolean
        if (!is_null($check) && !is_bool($check)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($check, true), gettype($check)), __LINE__);
        }
        $this->check = $check;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TransferBusinessCaseRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
