<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for searchContractRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Request zum Suchen von Verträgen
 * @subpackage Structs
 */
class SearchContractRequest extends AbstractStructBase
{
    /**
     * The login
     * @var \StructType\Login
     */
    public $login;
    /**
     * The search
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ContractSearch
     */
    public $search;
    /**
     * The withoutFrame
     * Meta information extracted from the WSDL
     * - documentation: Definiert ob ein eVP Navigationsframe angezeigt wird oder nicht. Default TRUE
     * - default: false
     * - minOccurs: 0
     * @var bool
     */
    public $withoutFrame;
    /**
     * Constructor method for searchContractRequest
     * @uses SearchContractRequest::setLogin()
     * @uses SearchContractRequest::setSearch()
     * @uses SearchContractRequest::setWithoutFrame()
     * @param \StructType\Login $login
     * @param \StructType\ContractSearch $search
     * @param bool $withoutFrame
     */
    public function __construct(\StructType\Login $login = null, \StructType\ContractSearch $search = null, $withoutFrame = false)
    {
        $this
            ->setLogin($login)
            ->setSearch($search)
            ->setWithoutFrame($withoutFrame);
    }
    /**
     * Get login value
     * @return \StructType\Login|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param \StructType\Login $login
     * @return \StructType\SearchContractRequest
     */
    public function setLogin(\StructType\Login $login = null)
    {
        $this->login = $login;
        return $this;
    }
    /**
     * Get search value
     * @return \StructType\ContractSearch|null
     */
    public function getSearch()
    {
        return $this->search;
    }
    /**
     * Set search value
     * @param \StructType\ContractSearch $search
     * @return \StructType\SearchContractRequest
     */
    public function setSearch(\StructType\ContractSearch $search = null)
    {
        $this->search = $search;
        return $this;
    }
    /**
     * Get withoutFrame value
     * @return bool|null
     */
    public function getWithoutFrame()
    {
        return $this->withoutFrame;
    }
    /**
     * Set withoutFrame value
     * @param bool $withoutFrame
     * @return \StructType\SearchContractRequest
     */
    public function setWithoutFrame($withoutFrame = false)
    {
        // validation for constraint: boolean
        if (!is_null($withoutFrame) && !is_bool($withoutFrame)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($withoutFrame, true), gettype($withoutFrame)), __LINE__);
        }
        $this->withoutFrame = $withoutFrame;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SearchContractRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
