<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for searchClaimListResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: Response zum Suchen von Schäden
 * @subpackage Structs
 */
class SearchClaimListResponse extends AbstractStructBase
{
    /**
     * The claim
     * Meta information extracted from the WSDL
     * - documentation: Schäden
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Claim[]
     */
    public $claim;
    /**
     * The evpServiceFault
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EvpServiceFault
     */
    public $evpServiceFault;
    /**
     * Constructor method for searchClaimListResponse
     * @uses SearchClaimListResponse::setClaim()
     * @uses SearchClaimListResponse::setEvpServiceFault()
     * @param \StructType\Claim[] $claim
     * @param \StructType\EvpServiceFault $evpServiceFault
     */
    public function __construct(array $claim = array(), \StructType\EvpServiceFault $evpServiceFault = null)
    {
        $this
            ->setClaim($claim)
            ->setEvpServiceFault($evpServiceFault);
    }
    /**
     * Get claim value
     * @return \StructType\Claim[]|null
     */
    public function getClaim()
    {
        return $this->claim;
    }
    /**
     * This method is responsible for validating the values passed to the setClaim method
     * This method is willingly generated in order to preserve the one-line inline validation within the setClaim method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateClaimForArrayConstraintsFromSetClaim(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $searchClaimListResponseClaimItem) {
            // validation for constraint: itemType
            if (!$searchClaimListResponseClaimItem instanceof \StructType\Claim) {
                $invalidValues[] = is_object($searchClaimListResponseClaimItem) ? get_class($searchClaimListResponseClaimItem) : sprintf('%s(%s)', gettype($searchClaimListResponseClaimItem), var_export($searchClaimListResponseClaimItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The claim property can only contain items of type \StructType\Claim, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set claim value
     * @throws \InvalidArgumentException
     * @param \StructType\Claim[] $claim
     * @return \StructType\SearchClaimListResponse
     */
    public function setClaim(array $claim = array())
    {
        // validation for constraint: array
        if ('' !== ($claimArrayErrorMessage = self::validateClaimForArrayConstraintsFromSetClaim($claim))) {
            throw new \InvalidArgumentException($claimArrayErrorMessage, __LINE__);
        }
        $this->claim = $claim;
        return $this;
    }
    /**
     * Add item to claim value
     * @throws \InvalidArgumentException
     * @param \StructType\Claim $item
     * @return \StructType\SearchClaimListResponse
     */
    public function addToClaim(\StructType\Claim $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Claim) {
            throw new \InvalidArgumentException(sprintf('The claim property can only contain items of type \StructType\Claim, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->claim[] = $item;
        return $this;
    }
    /**
     * Get evpServiceFault value
     * @return \StructType\EvpServiceFault|null
     */
    public function getEvpServiceFault()
    {
        return $this->evpServiceFault;
    }
    /**
     * Set evpServiceFault value
     * @param \StructType\EvpServiceFault $evpServiceFault
     * @return \StructType\SearchClaimListResponse
     */
    public function setEvpServiceFault(\StructType\EvpServiceFault $evpServiceFault = null)
    {
        $this->evpServiceFault = $evpServiceFault;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SearchClaimListResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
