<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for resetUserPasswordResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: Response zum Zurücksetzen des Benutzer Passwortes
 * @subpackage Structs
 */
class ResetUserPasswordResponse extends AbstractStructBase
{
    /**
     * The passwordMessageType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $passwordMessageType;
    /**
     * The evpServiceFault
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EvpServiceFault
     */
    public $evpServiceFault;
    /**
     * Constructor method for resetUserPasswordResponse
     * @uses ResetUserPasswordResponse::setPasswordMessageType()
     * @uses ResetUserPasswordResponse::setEvpServiceFault()
     * @param string $passwordMessageType
     * @param \StructType\EvpServiceFault $evpServiceFault
     */
    public function __construct($passwordMessageType = null, \StructType\EvpServiceFault $evpServiceFault = null)
    {
        $this
            ->setPasswordMessageType($passwordMessageType)
            ->setEvpServiceFault($evpServiceFault);
    }
    /**
     * Get passwordMessageType value
     * @return string|null
     */
    public function getPasswordMessageType()
    {
        return $this->passwordMessageType;
    }
    /**
     * Set passwordMessageType value
     * @uses \EnumType\PasswordMessageType::valueIsValid()
     * @uses \EnumType\PasswordMessageType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $passwordMessageType
     * @return \StructType\ResetUserPasswordResponse
     */
    public function setPasswordMessageType($passwordMessageType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PasswordMessageType::valueIsValid($passwordMessageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PasswordMessageType', is_array($passwordMessageType) ? implode(', ', $passwordMessageType) : var_export($passwordMessageType, true), implode(', ', \EnumType\PasswordMessageType::getValidValues())), __LINE__);
        }
        $this->passwordMessageType = $passwordMessageType;
        return $this;
    }
    /**
     * Get evpServiceFault value
     * @return \StructType\EvpServiceFault|null
     */
    public function getEvpServiceFault()
    {
        return $this->evpServiceFault;
    }
    /**
     * Set evpServiceFault value
     * @param \StructType\EvpServiceFault $evpServiceFault
     * @return \StructType\ResetUserPasswordResponse
     */
    public function setEvpServiceFault(\StructType\EvpServiceFault $evpServiceFault = null)
    {
        $this->evpServiceFault = $evpServiceFault;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ResetUserPasswordResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
