<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Request StructType
 * @subpackage Structs
 */
class Request extends AbstractStructBase
{
    /**
     * The accountingID
     * Meta information extracted from the WSDL
     * - documentation: userID used for accounting
     * - use: optional
     * @var string
     */
    public $accountingID;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - documentation: What kind of ArcImage servicerequest should be called. ---------------------------------------------------------- Usage: 1 ... Polizze 2 ... FAB (Finanzamtsbestaetigung) Only use without documentID
     * - use: optional
     * @var int
     */
    public $type;
    /**
     * The year
     * Meta information extracted from the WSDL
     * - documentation: If type=2, set the year to lookup the FAB.
     * - use: optional
     * @var int
     */
    public $year;
    /**
     * The fromDate
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $fromDate;
    /**
     * The arcImageId
     * Meta information extracted from the WSDL
     * - documentation: Use getArcImageInfo-Request to get the right ID
     * - use: optional
     * @var string
     */
    public $arcImageId;
    /**
     * Constructor method for Request
     * @uses Request::setAccountingID()
     * @uses Request::setType()
     * @uses Request::setYear()
     * @uses Request::setFromDate()
     * @uses Request::setArcImageId()
     * @param string $accountingID
     * @param int $type
     * @param int $year
     * @param string $fromDate
     * @param string $arcImageId
     */
    public function __construct($accountingID = null, $type = null, $year = null, $fromDate = null, $arcImageId = null)
    {
        $this
            ->setAccountingID($accountingID)
            ->setType($type)
            ->setYear($year)
            ->setFromDate($fromDate)
            ->setArcImageId($arcImageId);
    }
    /**
     * Get accountingID value
     * @return string|null
     */
    public function getAccountingID()
    {
        return $this->accountingID;
    }
    /**
     * Set accountingID value
     * @param string $accountingID
     * @return \StructType\Request
     */
    public function setAccountingID($accountingID = null)
    {
        // validation for constraint: string
        if (!is_null($accountingID) && !is_string($accountingID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountingID, true), gettype($accountingID)), __LINE__);
        }
        $this->accountingID = $accountingID;
        return $this;
    }
    /**
     * Get type value
     * @return int|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param int $type
     * @return \StructType\Request
     */
    public function setType($type = null)
    {
        // validation for constraint: int
        if (!is_null($type) && !(is_int($type) || ctype_digit($type))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get year value
     * @return int|null
     */
    public function getYear()
    {
        return $this->year;
    }
    /**
     * Set year value
     * @param int $year
     * @return \StructType\Request
     */
    public function setYear($year = null)
    {
        // validation for constraint: int
        if (!is_null($year) && !(is_int($year) || ctype_digit($year))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($year, true), gettype($year)), __LINE__);
        }
        $this->year = $year;
        return $this;
    }
    /**
     * Get fromDate value
     * @return string|null
     */
    public function getFromDate()
    {
        return $this->fromDate;
    }
    /**
     * Set fromDate value
     * @param string $fromDate
     * @return \StructType\Request
     */
    public function setFromDate($fromDate = null)
    {
        // validation for constraint: string
        if (!is_null($fromDate) && !is_string($fromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromDate, true), gettype($fromDate)), __LINE__);
        }
        $this->fromDate = $fromDate;
        return $this;
    }
    /**
     * Get arcImageId value
     * @return string|null
     */
    public function getArcImageId()
    {
        return $this->arcImageId;
    }
    /**
     * Set arcImageId value
     * @param string $arcImageId
     * @return \StructType\Request
     */
    public function setArcImageId($arcImageId = null)
    {
        // validation for constraint: string
        if (!is_null($arcImageId) && !is_string($arcImageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arcImageId, true), gettype($arcImageId)), __LINE__);
        }
        $this->arcImageId = $arcImageId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Request
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
