<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OMDSPackage StructType
 * @subpackage Structs
 */
class OMDSPackage extends AbstractStructBase
{
    /**
     * The omdsPackageInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\OMDSPackageInfo
     */
    public $omdsPackageInfo;
    /**
     * The content
     * Meta information extracted from the WSDL
     * - documentation: OMDS-Daten als zip-File
     * @var string
     */
    public $content;
    /**
     * Constructor method for OMDSPackage
     * @uses OMDSPackage::setOmdsPackageInfo()
     * @uses OMDSPackage::setContent()
     * @param \StructType\OMDSPackageInfo $omdsPackageInfo
     * @param string $content
     */
    public function __construct(\StructType\OMDSPackageInfo $omdsPackageInfo = null, $content = null)
    {
        $this
            ->setOmdsPackageInfo($omdsPackageInfo)
            ->setContent($content);
    }
    /**
     * Get omdsPackageInfo value
     * @return \StructType\OMDSPackageInfo
     */
    public function getOmdsPackageInfo()
    {
        return $this->omdsPackageInfo;
    }
    /**
     * Set omdsPackageInfo value
     * @param \StructType\OMDSPackageInfo $omdsPackageInfo
     * @return \StructType\OMDSPackage
     */
    public function setOmdsPackageInfo(\StructType\OMDSPackageInfo $omdsPackageInfo = null)
    {
        $this->omdsPackageInfo = $omdsPackageInfo;
        return $this;
    }
    /**
     * Get content value
     * @return string|null
     */
    public function getContent()
    {
        return $this->content;
    }
    /**
     * Set content value
     * @param string $content
     * @return \StructType\OMDSPackage
     */
    public function setContent($content = null)
    {
        // validation for constraint: string
        if (!is_null($content) && !is_string($content)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($content, true), gettype($content)), __LINE__);
        }
        $this->content = $content;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OMDSPackage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
