<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for newBusinessCaseInkassoAenderungRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Request zur Versorgung eines Geschäftsfalles
 * @subpackage Structs
 */
class NewBusinessCaseInkassoAenderungRequest extends AbstractStructBase
{
    /**
     * The login
     * @var \StructType\Login
     */
    public $login;
    /**
     * The policynumber
     * Meta information extracted from the WSDL
     * - choice: policynumber | customerID
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - union: IrisPolicyNumber | EVtgPolicyNumber
     * @var string
     */
    public $policynumber;
    /**
     * The customerID
     * Meta information extracted from the WSDL
     * - choice: policynumber | customerID
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var int
     */
    public $customerID;
    /**
     * Constructor method for newBusinessCaseInkassoAenderungRequest
     * @uses NewBusinessCaseInkassoAenderungRequest::setLogin()
     * @uses NewBusinessCaseInkassoAenderungRequest::setPolicynumber()
     * @uses NewBusinessCaseInkassoAenderungRequest::setCustomerID()
     * @param \StructType\Login $login
     * @param string $policynumber
     * @param int $customerID
     */
    public function __construct(\StructType\Login $login = null, $policynumber = null, $customerID = null)
    {
        $this
            ->setLogin($login)
            ->setPolicynumber($policynumber)
            ->setCustomerID($customerID);
    }
    /**
     * Get login value
     * @return \StructType\Login|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param \StructType\Login $login
     * @return \StructType\NewBusinessCaseInkassoAenderungRequest
     */
    public function setLogin(\StructType\Login $login = null)
    {
        $this->login = $login;
        return $this;
    }
    /**
     * Get policynumber value
     * @return string|null
     */
    public function getPolicynumber()
    {
        return isset($this->policynumber) ? $this->policynumber : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPolicynumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPolicynumber method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePolicynumberForChoiceConstraintsFromSetPolicynumber($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'customerID',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property policynumber can\'t be set as the property %s is already set. Only one property must be set among these properties: policynumber, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setPolicynumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPolicynumber method
     * This is a set of validation rules based on the union types associated to the property being set by the setPolicynumber method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePolicynumberForUnionConstraintsFromSetPolicynumber($value)
    {
        $message = '';
        // validation for constraint: pattern(\d/\d{2}/\d{8}(-\d{2})?)
        if (!is_null($value) && !preg_match('/\\d\/\\d{2}\/\\d{8}(-\\d{2})?/', $value)) {
            $exception0 = new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d/\d{2}/\d{8}(-\d{2})?', var_export($value, true)), __LINE__);
        }
        // validation for constraint: pattern(\d{3}-\d{4}-\d{4})
        if (!is_null($value) && !preg_match('/\\d{3}-\\d{4}-\\d{4}/', $value)) {
            $exception1 = new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{3}-\d{4}-\d{4}', var_export($value, true)), __LINE__);
        }
        if (isset($exception0) && isset($exception1)) {
            $message = sprintf("The value %s does not match any of the union rules: IrisPolicyNumber, EVtgPolicyNumber. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [$exception0, $exception1])));
        }
        unset($exception0, $exception1);
        return $message;
    }
    /**
     * Set policynumber value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $policynumber
     * @return \StructType\NewBusinessCaseInkassoAenderungRequest
     */
    public function setPolicynumber($policynumber = null)
    {
        // validation for constraint: string
        if (!is_null($policynumber) && !is_string($policynumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($policynumber, true), gettype($policynumber)), __LINE__);
        }
        // validation for constraint: choice(policynumber, customerID)
        if ('' !== ($policynumberChoiceErrorMessage = self::validatePolicynumberForChoiceConstraintsFromSetPolicynumber($policynumber))) {
            throw new \InvalidArgumentException($policynumberChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: union(IrisPolicyNumber, EVtgPolicyNumber)
        if ('' !== ($policynumberUnionErrorMessage = self::validatePolicynumberForUnionConstraintsFromSetPolicynumber($policynumber))) {
            throw new \InvalidArgumentException($policynumberUnionErrorMessage, __LINE__);
        }
        if (is_null($policynumber) || (is_array($policynumber) && empty($policynumber))) {
            unset($this->policynumber);
        } else {
            $this->policynumber = $policynumber;
        }
        return $this;
    }
    /**
     * Get customerID value
     * @return int|null
     */
    public function getCustomerID()
    {
        return isset($this->customerID) ? $this->customerID : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCustomerID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomerID method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCustomerIDForChoiceConstraintsFromSetCustomerID($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'policynumber',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property customerID can\'t be set as the property %s is already set. Only one property must be set among these properties: customerID, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set customerID value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param int $customerID
     * @return \StructType\NewBusinessCaseInkassoAenderungRequest
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !(is_int($customerID) || ctype_digit($customerID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerID, true), gettype($customerID)), __LINE__);
        }
        // validation for constraint: choice(policynumber, customerID)
        if ('' !== ($customerIDChoiceErrorMessage = self::validateCustomerIDForChoiceConstraintsFromSetCustomerID($customerID))) {
            throw new \InvalidArgumentException($customerIDChoiceErrorMessage, __LINE__);
        }
        if (is_null($customerID) || (is_array($customerID) && empty($customerID))) {
            unset($this->customerID);
        } else {
            $this->customerID = $customerID;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NewBusinessCaseInkassoAenderungRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
