<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for newBusinessCaseIVOnlineRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Request which starts a new online schadenmeldung and prefills it with the given data
 * @subpackage Structs
 */
class NewBusinessCaseIVOnlineRequest extends AbstractStructBase
{
    /**
     * The login
     * @var \StructType\Login
     */
    public $login;
    /**
     * The policynumber
     * Meta information extracted from the WSDL
     * - union: IrisPolicyNumber | EVtgPolicyNumber
     * @var string
     */
    public $policynumber;
    /**
     * The category
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $category;
    /**
     * The intervention
     * Meta information extracted from the WSDL
     * - documentation: Detaildaten Objekt eines Interventionsbericht
     * @var \StructType\Intervention
     */
    public $intervention;
    /**
     * Constructor method for newBusinessCaseIVOnlineRequest
     * @uses NewBusinessCaseIVOnlineRequest::setLogin()
     * @uses NewBusinessCaseIVOnlineRequest::setPolicynumber()
     * @uses NewBusinessCaseIVOnlineRequest::setCategory()
     * @uses NewBusinessCaseIVOnlineRequest::setIntervention()
     * @param \StructType\Login $login
     * @param string $policynumber
     * @param string $category
     * @param \StructType\Intervention $intervention
     */
    public function __construct(\StructType\Login $login = null, $policynumber = null, $category = null, \StructType\Intervention $intervention = null)
    {
        $this
            ->setLogin($login)
            ->setPolicynumber($policynumber)
            ->setCategory($category)
            ->setIntervention($intervention);
    }
    /**
     * Get login value
     * @return \StructType\Login|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param \StructType\Login $login
     * @return \StructType\NewBusinessCaseIVOnlineRequest
     */
    public function setLogin(\StructType\Login $login = null)
    {
        $this->login = $login;
        return $this;
    }
    /**
     * Get policynumber value
     * @return string|null
     */
    public function getPolicynumber()
    {
        return $this->policynumber;
    }
    /**
     * This method is responsible for validating the value passed to the setPolicynumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPolicynumber method
     * This is a set of validation rules based on the union types associated to the property being set by the setPolicynumber method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePolicynumberForUnionConstraintsFromSetPolicynumber($value)
    {
        $message = '';
        // validation for constraint: pattern(\d/\d{2}/\d{8}(-\d{2})?)
        if (!is_null($value) && !preg_match('/\\d\/\\d{2}\/\\d{8}(-\\d{2})?/', $value)) {
            $exception0 = new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d/\d{2}/\d{8}(-\d{2})?', var_export($value, true)), __LINE__);
        }
        // validation for constraint: pattern(\d{3}-\d{4}-\d{4})
        if (!is_null($value) && !preg_match('/\\d{3}-\\d{4}-\\d{4}/', $value)) {
            $exception1 = new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{3}-\d{4}-\d{4}', var_export($value, true)), __LINE__);
        }
        if (isset($exception0) && isset($exception1)) {
            $message = sprintf("The value %s does not match any of the union rules: IrisPolicyNumber, EVtgPolicyNumber. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [$exception0, $exception1])));
        }
        unset($exception0, $exception1);
        return $message;
    }
    /**
     * Set policynumber value
     * @param string $policynumber
     * @return \StructType\NewBusinessCaseIVOnlineRequest
     */
    public function setPolicynumber($policynumber = null)
    {
        // validation for constraint: string
        if (!is_null($policynumber) && !is_string($policynumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($policynumber, true), gettype($policynumber)), __LINE__);
        }
        // validation for constraint: union(IrisPolicyNumber, EVtgPolicyNumber)
        if ('' !== ($policynumberUnionErrorMessage = self::validatePolicynumberForUnionConstraintsFromSetPolicynumber($policynumber))) {
            throw new \InvalidArgumentException($policynumberUnionErrorMessage, __LINE__);
        }
        $this->policynumber = $policynumber;
        return $this;
    }
    /**
     * Get category value
     * @return string|null
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * Set category value
     * @uses \EnumType\IVCategory::valueIsValid()
     * @uses \EnumType\IVCategory::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $category
     * @return \StructType\NewBusinessCaseIVOnlineRequest
     */
    public function setCategory($category = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\IVCategory::valueIsValid($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\IVCategory', is_array($category) ? implode(', ', $category) : var_export($category, true), implode(', ', \EnumType\IVCategory::getValidValues())), __LINE__);
        }
        $this->category = $category;
        return $this;
    }
    /**
     * Get intervention value
     * @return \StructType\Intervention|null
     */
    public function getIntervention()
    {
        return $this->intervention;
    }
    /**
     * Set intervention value
     * @param \StructType\Intervention $intervention
     * @return \StructType\NewBusinessCaseIVOnlineRequest
     */
    public function setIntervention(\StructType\Intervention $intervention = null)
    {
        $this->intervention = $intervention;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NewBusinessCaseIVOnlineRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
