<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for kundenportalPushNachrichtRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Kundenportal Pushnachricht Request
 * @subpackage Structs
 */
class KundenportalPushNachrichtRequest extends AbstractStructBase
{
    /**
     * The login
     * @var \StructType\Login
     */
    public $login;
    /**
     * The partnerNr
     * Meta information extracted from the WSDL
     * - choice: partnerNr | KundenKtoNr
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var string
     */
    public $partnerNr;
    /**
     * The KundenKtoNr
     * Meta information extracted from the WSDL
     * - choice: partnerNr | KundenKtoNr
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var string
     */
    public $KundenKtoNr;
    /**
     * The pushNachrichtDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PushNachrichtDetails[]
     */
    public $pushNachrichtDetails;
    /**
     * Constructor method for kundenportalPushNachrichtRequest
     * @uses KundenportalPushNachrichtRequest::setLogin()
     * @uses KundenportalPushNachrichtRequest::setPartnerNr()
     * @uses KundenportalPushNachrichtRequest::setKundenKtoNr()
     * @uses KundenportalPushNachrichtRequest::setPushNachrichtDetails()
     * @param \StructType\Login $login
     * @param string $partnerNr
     * @param string $kundenKtoNr
     * @param \StructType\PushNachrichtDetails[] $pushNachrichtDetails
     */
    public function __construct(\StructType\Login $login = null, $partnerNr = null, $kundenKtoNr = null, array $pushNachrichtDetails = array())
    {
        $this
            ->setLogin($login)
            ->setPartnerNr($partnerNr)
            ->setKundenKtoNr($kundenKtoNr)
            ->setPushNachrichtDetails($pushNachrichtDetails);
    }
    /**
     * Get login value
     * @return \StructType\Login|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param \StructType\Login $login
     * @return \StructType\KundenportalPushNachrichtRequest
     */
    public function setLogin(\StructType\Login $login = null)
    {
        $this->login = $login;
        return $this;
    }
    /**
     * Get partnerNr value
     * @return string|null
     */
    public function getPartnerNr()
    {
        return isset($this->partnerNr) ? $this->partnerNr : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPartnerNr method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPartnerNr method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePartnerNrForChoiceConstraintsFromSetPartnerNr($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'KundenKtoNr',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property partnerNr can\'t be set as the property %s is already set. Only one property must be set among these properties: partnerNr, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set partnerNr value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $partnerNr
     * @return \StructType\KundenportalPushNachrichtRequest
     */
    public function setPartnerNr($partnerNr = null)
    {
        // validation for constraint: string
        if (!is_null($partnerNr) && !is_string($partnerNr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partnerNr, true), gettype($partnerNr)), __LINE__);
        }
        // validation for constraint: choice(partnerNr, KundenKtoNr)
        if ('' !== ($partnerNrChoiceErrorMessage = self::validatePartnerNrForChoiceConstraintsFromSetPartnerNr($partnerNr))) {
            throw new \InvalidArgumentException($partnerNrChoiceErrorMessage, __LINE__);
        }
        if (is_null($partnerNr) || (is_array($partnerNr) && empty($partnerNr))) {
            unset($this->partnerNr);
        } else {
            $this->partnerNr = $partnerNr;
        }
        return $this;
    }
    /**
     * Get KundenKtoNr value
     * @return string|null
     */
    public function getKundenKtoNr()
    {
        return isset($this->KundenKtoNr) ? $this->KundenKtoNr : null;
    }
    /**
     * This method is responsible for validating the value passed to the setKundenKtoNr method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKundenKtoNr method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateKundenKtoNrForChoiceConstraintsFromSetKundenKtoNr($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'partnerNr',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property KundenKtoNr can\'t be set as the property %s is already set. Only one property must be set among these properties: KundenKtoNr, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set KundenKtoNr value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $kundenKtoNr
     * @return \StructType\KundenportalPushNachrichtRequest
     */
    public function setKundenKtoNr($kundenKtoNr = null)
    {
        // validation for constraint: string
        if (!is_null($kundenKtoNr) && !is_string($kundenKtoNr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kundenKtoNr, true), gettype($kundenKtoNr)), __LINE__);
        }
        // validation for constraint: choice(partnerNr, KundenKtoNr)
        if ('' !== ($kundenKtoNrChoiceErrorMessage = self::validateKundenKtoNrForChoiceConstraintsFromSetKundenKtoNr($kundenKtoNr))) {
            throw new \InvalidArgumentException($kundenKtoNrChoiceErrorMessage, __LINE__);
        }
        if (is_null($kundenKtoNr) || (is_array($kundenKtoNr) && empty($kundenKtoNr))) {
            unset($this->KundenKtoNr);
        } else {
            $this->KundenKtoNr = $kundenKtoNr;
        }
        return $this;
    }
    /**
     * Get pushNachrichtDetails value
     * @return \StructType\PushNachrichtDetails[]|null
     */
    public function getPushNachrichtDetails()
    {
        return $this->pushNachrichtDetails;
    }
    /**
     * This method is responsible for validating the values passed to the setPushNachrichtDetails method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPushNachrichtDetails method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePushNachrichtDetailsForArrayConstraintsFromSetPushNachrichtDetails(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kundenportalPushNachrichtRequestPushNachrichtDetailsItem) {
            // validation for constraint: itemType
            if (!$kundenportalPushNachrichtRequestPushNachrichtDetailsItem instanceof \StructType\PushNachrichtDetails) {
                $invalidValues[] = is_object($kundenportalPushNachrichtRequestPushNachrichtDetailsItem) ? get_class($kundenportalPushNachrichtRequestPushNachrichtDetailsItem) : sprintf('%s(%s)', gettype($kundenportalPushNachrichtRequestPushNachrichtDetailsItem), var_export($kundenportalPushNachrichtRequestPushNachrichtDetailsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The pushNachrichtDetails property can only contain items of type \StructType\PushNachrichtDetails, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set pushNachrichtDetails value
     * @throws \InvalidArgumentException
     * @param \StructType\PushNachrichtDetails[] $pushNachrichtDetails
     * @return \StructType\KundenportalPushNachrichtRequest
     */
    public function setPushNachrichtDetails(array $pushNachrichtDetails = array())
    {
        // validation for constraint: array
        if ('' !== ($pushNachrichtDetailsArrayErrorMessage = self::validatePushNachrichtDetailsForArrayConstraintsFromSetPushNachrichtDetails($pushNachrichtDetails))) {
            throw new \InvalidArgumentException($pushNachrichtDetailsArrayErrorMessage, __LINE__);
        }
        $this->pushNachrichtDetails = $pushNachrichtDetails;
        return $this;
    }
    /**
     * Add item to pushNachrichtDetails value
     * @throws \InvalidArgumentException
     * @param \StructType\PushNachrichtDetails $item
     * @return \StructType\KundenportalPushNachrichtRequest
     */
    public function addToPushNachrichtDetails(\StructType\PushNachrichtDetails $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PushNachrichtDetails) {
            throw new \InvalidArgumentException(sprintf('The pushNachrichtDetails property can only contain items of type \StructType\PushNachrichtDetails, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->pushNachrichtDetails[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\KundenportalPushNachrichtRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
