<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for kundenportalMarkMessageAsReadRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Kundenportal Nachricht bereits gelesen Request
 * @subpackage Structs
 */
class KundenportalMarkMessageAsReadRequest extends AbstractStructBase
{
    /**
     * The login
     * @var \StructType\Login
     */
    public $login;
    /**
     * The messageOid
     * @var string
     */
    public $messageOid;
    /**
     * The deleteMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $deleteMessage;
    /**
     * The moveMessageTo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $moveMessageTo;
    /**
     * Constructor method for kundenportalMarkMessageAsReadRequest
     * @uses KundenportalMarkMessageAsReadRequest::setLogin()
     * @uses KundenportalMarkMessageAsReadRequest::setMessageOid()
     * @uses KundenportalMarkMessageAsReadRequest::setDeleteMessage()
     * @uses KundenportalMarkMessageAsReadRequest::setMoveMessageTo()
     * @param \StructType\Login $login
     * @param string $messageOid
     * @param bool $deleteMessage
     * @param bool $moveMessageTo
     */
    public function __construct(\StructType\Login $login = null, $messageOid = null, $deleteMessage = null, $moveMessageTo = null)
    {
        $this
            ->setLogin($login)
            ->setMessageOid($messageOid)
            ->setDeleteMessage($deleteMessage)
            ->setMoveMessageTo($moveMessageTo);
    }
    /**
     * Get login value
     * @return \StructType\Login|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param \StructType\Login $login
     * @return \StructType\KundenportalMarkMessageAsReadRequest
     */
    public function setLogin(\StructType\Login $login = null)
    {
        $this->login = $login;
        return $this;
    }
    /**
     * Get messageOid value
     * @return string|null
     */
    public function getMessageOid()
    {
        return $this->messageOid;
    }
    /**
     * Set messageOid value
     * @param string $messageOid
     * @return \StructType\KundenportalMarkMessageAsReadRequest
     */
    public function setMessageOid($messageOid = null)
    {
        // validation for constraint: string
        if (!is_null($messageOid) && !is_string($messageOid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messageOid, true), gettype($messageOid)), __LINE__);
        }
        $this->messageOid = $messageOid;
        return $this;
    }
    /**
     * Get deleteMessage value
     * @return bool|null
     */
    public function getDeleteMessage()
    {
        return $this->deleteMessage;
    }
    /**
     * Set deleteMessage value
     * @param bool $deleteMessage
     * @return \StructType\KundenportalMarkMessageAsReadRequest
     */
    public function setDeleteMessage($deleteMessage = null)
    {
        // validation for constraint: boolean
        if (!is_null($deleteMessage) && !is_bool($deleteMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($deleteMessage, true), gettype($deleteMessage)), __LINE__);
        }
        $this->deleteMessage = $deleteMessage;
        return $this;
    }
    /**
     * Get moveMessageTo value
     * @return bool|null
     */
    public function getMoveMessageTo()
    {
        return $this->moveMessageTo;
    }
    /**
     * Set moveMessageTo value
     * @param bool $moveMessageTo
     * @return \StructType\KundenportalMarkMessageAsReadRequest
     */
    public function setMoveMessageTo($moveMessageTo = null)
    {
        // validation for constraint: boolean
        if (!is_null($moveMessageTo) && !is_bool($moveMessageTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($moveMessageTo, true), gettype($moveMessageTo)), __LINE__);
        }
        $this->moveMessageTo = $moveMessageTo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\KundenportalMarkMessageAsReadRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
