<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for healthInsurance StructType
 * @subpackage Structs
 */
class HealthInsurance extends AbstractStructBase
{
    /**
     * The typOfhealthInsurance
     * Meta information extracted from the WSDL
     * - documentation: Schadensubkategorie für Kranken
     * - base: xsd:string
     * @var string
     */
    public $typOfhealthInsurance;
    /**
     * The stationary
     * Meta information extracted from the WSDL
     * - choice: stationary | ambulant
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Stationary
     */
    public $stationary;
    /**
     * The ambulant
     * Meta information extracted from the WSDL
     * - choice: stationary | ambulant
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Ambulant
     */
    public $ambulant;
    /**
     * Constructor method for healthInsurance
     * @uses HealthInsurance::setTypOfhealthInsurance()
     * @uses HealthInsurance::setStationary()
     * @uses HealthInsurance::setAmbulant()
     * @param string $typOfhealthInsurance
     * @param \StructType\Stationary $stationary
     * @param \StructType\Ambulant $ambulant
     */
    public function __construct($typOfhealthInsurance = null, \StructType\Stationary $stationary = null, \StructType\Ambulant $ambulant = null)
    {
        $this
            ->setTypOfhealthInsurance($typOfhealthInsurance)
            ->setStationary($stationary)
            ->setAmbulant($ambulant);
    }
    /**
     * Get typOfhealthInsurance value
     * @return string|null
     */
    public function getTypOfhealthInsurance()
    {
        return $this->typOfhealthInsurance;
    }
    /**
     * Set typOfhealthInsurance value
     * @param string $typOfhealthInsurance
     * @return \StructType\HealthInsurance
     */
    public function setTypOfhealthInsurance($typOfhealthInsurance = null)
    {
        // validation for constraint: string
        if (!is_null($typOfhealthInsurance) && !is_string($typOfhealthInsurance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typOfhealthInsurance, true), gettype($typOfhealthInsurance)), __LINE__);
        }
        $this->typOfhealthInsurance = $typOfhealthInsurance;
        return $this;
    }
    /**
     * Get stationary value
     * @return \StructType\Stationary|null
     */
    public function getStationary()
    {
        return isset($this->stationary) ? $this->stationary : null;
    }
    /**
     * This method is responsible for validating the value passed to the setStationary method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStationary method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateStationaryForChoiceConstraintsFromSetStationary($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ambulant',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property stationary can\'t be set as the property %s is already set. Only one property must be set among these properties: stationary, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set stationary value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Stationary $stationary
     * @return \StructType\HealthInsurance
     */
    public function setStationary(\StructType\Stationary $stationary = null)
    {
        // validation for constraint: choice(stationary, ambulant)
        if ('' !== ($stationaryChoiceErrorMessage = self::validateStationaryForChoiceConstraintsFromSetStationary($stationary))) {
            throw new \InvalidArgumentException($stationaryChoiceErrorMessage, __LINE__);
        }
        if (is_null($stationary) || (is_array($stationary) && empty($stationary))) {
            unset($this->stationary);
        } else {
            $this->stationary = $stationary;
        }
        return $this;
    }
    /**
     * Get ambulant value
     * @return \StructType\Ambulant|null
     */
    public function getAmbulant()
    {
        return isset($this->ambulant) ? $this->ambulant : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAmbulant method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAmbulant method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAmbulantForChoiceConstraintsFromSetAmbulant($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'stationary',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ambulant can\'t be set as the property %s is already set. Only one property must be set among these properties: ambulant, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ambulant value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Ambulant $ambulant
     * @return \StructType\HealthInsurance
     */
    public function setAmbulant(\StructType\Ambulant $ambulant = null)
    {
        // validation for constraint: choice(stationary, ambulant)
        if ('' !== ($ambulantChoiceErrorMessage = self::validateAmbulantForChoiceConstraintsFromSetAmbulant($ambulant))) {
            throw new \InvalidArgumentException($ambulantChoiceErrorMessage, __LINE__);
        }
        if (is_null($ambulant) || (is_array($ambulant) && empty($ambulant))) {
            unset($this->ambulant);
        } else {
            $this->ambulant = $ambulant;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HealthInsurance
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
