<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for headerType StructType
 * @subpackage Structs
 */
class HeaderType extends AbstractStructBase
{
    /**
     * The clientID
     * Meta information extracted from the WSDL
     * - documentation: Client ID des einspielenden Systems - aktuell noch optional, später Pflicht, wenn es von allen mitgeschickt wird
     * - minOccurs: 0
     * @var int
     */
    public $clientID;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - documentation: Versionsbezeichnung des einspielenden Systems (zwecks Fehlersuche). Beispiel: "MaklerXY V1.23 (1.1.2015)".
     * @var string
     */
    public $version;
    /**
     * The erzeugungsdatum
     * Meta information extracted from the WSDL
     * - documentation: Datum und Uhrzeit der Erzeugung des XMLs.
     * @var string
     */
    public $erzeugungsdatum;
    /**
     * The praemienpruefung
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PraemienpruefungType
     */
    public $praemienpruefung;
    /**
     * The externalId
     * Meta information extracted from the WSDL
     * - documentation: Externe ID des Antrages der Makler Software.
     * - minOccurs: 0
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for headerType
     * @uses HeaderType::setClientID()
     * @uses HeaderType::setVersion()
     * @uses HeaderType::setErzeugungsdatum()
     * @uses HeaderType::setPraemienpruefung()
     * @uses HeaderType::setExternalId()
     * @param int $clientID
     * @param string $version
     * @param string $erzeugungsdatum
     * @param \StructType\PraemienpruefungType $praemienpruefung
     * @param string $externalId
     */
    public function __construct($clientID = null, $version = null, $erzeugungsdatum = null, \StructType\PraemienpruefungType $praemienpruefung = null, $externalId = null)
    {
        $this
            ->setClientID($clientID)
            ->setVersion($version)
            ->setErzeugungsdatum($erzeugungsdatum)
            ->setPraemienpruefung($praemienpruefung)
            ->setExternalId($externalId);
    }
    /**
     * Get clientID value
     * @return int|null
     */
    public function getClientID()
    {
        return $this->clientID;
    }
    /**
     * Set clientID value
     * @param int $clientID
     * @return \StructType\HeaderType
     */
    public function setClientID($clientID = null)
    {
        // validation for constraint: int
        if (!is_null($clientID) && !(is_int($clientID) || ctype_digit($clientID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($clientID, true), gettype($clientID)), __LINE__);
        }
        $this->clientID = $clientID;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\HeaderType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Get erzeugungsdatum value
     * @return string|null
     */
    public function getErzeugungsdatum()
    {
        return $this->erzeugungsdatum;
    }
    /**
     * Set erzeugungsdatum value
     * @param string $erzeugungsdatum
     * @return \StructType\HeaderType
     */
    public function setErzeugungsdatum($erzeugungsdatum = null)
    {
        // validation for constraint: string
        if (!is_null($erzeugungsdatum) && !is_string($erzeugungsdatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($erzeugungsdatum, true), gettype($erzeugungsdatum)), __LINE__);
        }
        $this->erzeugungsdatum = $erzeugungsdatum;
        return $this;
    }
    /**
     * Get praemienpruefung value
     * @return \StructType\PraemienpruefungType|null
     */
    public function getPraemienpruefung()
    {
        return $this->praemienpruefung;
    }
    /**
     * Set praemienpruefung value
     * @param \StructType\PraemienpruefungType $praemienpruefung
     * @return \StructType\HeaderType
     */
    public function setPraemienpruefung(\StructType\PraemienpruefungType $praemienpruefung = null)
    {
        $this->praemienpruefung = $praemienpruefung;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\HeaderType
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HeaderType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
