<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getUserDataResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: Response zum Einloggen in der eVP
 * @subpackage Structs
 */
class GetUserDataResponse extends AbstractStructBase
{
    /**
     * The evpServiceFault
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EvpServiceFault
     */
    public $evpServiceFault;
    /**
     * The fbUrl
     * @var string
     */
    public $fbUrl;
    /**
     * The profilPicture
     * Meta information extracted from the WSDL
     * - documentation: Beinhaltet den Stream des angehängten Files
     * - minOccurs: 0
     * @var \StructType\Attachment
     */
    public $profilPicture;
    /**
     * The userId
     * @var string
     */
    public $userId;
    /**
     * The paOid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $paOid;
    /**
     * The message
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $message;
    /**
     * The userTokens
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\UserToken[]
     */
    public $userTokens;
    /**
     * Constructor method for getUserDataResponse
     * @uses GetUserDataResponse::setEvpServiceFault()
     * @uses GetUserDataResponse::setFbUrl()
     * @uses GetUserDataResponse::setProfilPicture()
     * @uses GetUserDataResponse::setUserId()
     * @uses GetUserDataResponse::setPaOid()
     * @uses GetUserDataResponse::setMessage()
     * @uses GetUserDataResponse::setUserTokens()
     * @param \StructType\EvpServiceFault $evpServiceFault
     * @param string $fbUrl
     * @param \StructType\Attachment $profilPicture
     * @param string $userId
     * @param string $paOid
     * @param string $message
     * @param \StructType\UserToken[] $userTokens
     */
    public function __construct(\StructType\EvpServiceFault $evpServiceFault = null, $fbUrl = null, \StructType\Attachment $profilPicture = null, $userId = null, $paOid = null, $message = null, array $userTokens = array())
    {
        $this
            ->setEvpServiceFault($evpServiceFault)
            ->setFbUrl($fbUrl)
            ->setProfilPicture($profilPicture)
            ->setUserId($userId)
            ->setPaOid($paOid)
            ->setMessage($message)
            ->setUserTokens($userTokens);
    }
    /**
     * Get evpServiceFault value
     * @return \StructType\EvpServiceFault|null
     */
    public function getEvpServiceFault()
    {
        return $this->evpServiceFault;
    }
    /**
     * Set evpServiceFault value
     * @param \StructType\EvpServiceFault $evpServiceFault
     * @return \StructType\GetUserDataResponse
     */
    public function setEvpServiceFault(\StructType\EvpServiceFault $evpServiceFault = null)
    {
        $this->evpServiceFault = $evpServiceFault;
        return $this;
    }
    /**
     * Get fbUrl value
     * @return string|null
     */
    public function getFbUrl()
    {
        return $this->fbUrl;
    }
    /**
     * Set fbUrl value
     * @param string $fbUrl
     * @return \StructType\GetUserDataResponse
     */
    public function setFbUrl($fbUrl = null)
    {
        // validation for constraint: string
        if (!is_null($fbUrl) && !is_string($fbUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fbUrl, true), gettype($fbUrl)), __LINE__);
        }
        $this->fbUrl = $fbUrl;
        return $this;
    }
    /**
     * Get profilPicture value
     * @return \StructType\Attachment|null
     */
    public function getProfilPicture()
    {
        return $this->profilPicture;
    }
    /**
     * Set profilPicture value
     * @param \StructType\Attachment $profilPicture
     * @return \StructType\GetUserDataResponse
     */
    public function setProfilPicture(\StructType\Attachment $profilPicture = null)
    {
        $this->profilPicture = $profilPicture;
        return $this;
    }
    /**
     * Get userId value
     * @return string|null
     */
    public function getUserId()
    {
        return $this->userId;
    }
    /**
     * Set userId value
     * @param string $userId
     * @return \StructType\GetUserDataResponse
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        $this->userId = $userId;
        return $this;
    }
    /**
     * Get paOid value
     * @return string|null
     */
    public function getPaOid()
    {
        return $this->paOid;
    }
    /**
     * Set paOid value
     * @param string $paOid
     * @return \StructType\GetUserDataResponse
     */
    public function setPaOid($paOid = null)
    {
        // validation for constraint: string
        if (!is_null($paOid) && !is_string($paOid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paOid, true), gettype($paOid)), __LINE__);
        }
        $this->paOid = $paOid;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \StructType\GetUserDataResponse
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Get userTokens value
     * @return \StructType\UserToken[]|null
     */
    public function getUserTokens()
    {
        return $this->userTokens;
    }
    /**
     * This method is responsible for validating the values passed to the setUserTokens method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUserTokens method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUserTokensForArrayConstraintsFromSetUserTokens(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getUserDataResponseUserTokensItem) {
            // validation for constraint: itemType
            if (!$getUserDataResponseUserTokensItem instanceof \StructType\UserToken) {
                $invalidValues[] = is_object($getUserDataResponseUserTokensItem) ? get_class($getUserDataResponseUserTokensItem) : sprintf('%s(%s)', gettype($getUserDataResponseUserTokensItem), var_export($getUserDataResponseUserTokensItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The userTokens property can only contain items of type \StructType\UserToken, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set userTokens value
     * @throws \InvalidArgumentException
     * @param \StructType\UserToken[] $userTokens
     * @return \StructType\GetUserDataResponse
     */
    public function setUserTokens(array $userTokens = array())
    {
        // validation for constraint: array
        if ('' !== ($userTokensArrayErrorMessage = self::validateUserTokensForArrayConstraintsFromSetUserTokens($userTokens))) {
            throw new \InvalidArgumentException($userTokensArrayErrorMessage, __LINE__);
        }
        $this->userTokens = $userTokens;
        return $this;
    }
    /**
     * Add item to userTokens value
     * @throws \InvalidArgumentException
     * @param \StructType\UserToken $item
     * @return \StructType\GetUserDataResponse
     */
    public function addToUserTokens(\StructType\UserToken $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UserToken) {
            throw new \InvalidArgumentException(sprintf('The userTokens property can only contain items of type \StructType\UserToken, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->userTokens[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetUserDataResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
