<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getBusinessCaseRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Request zur Versorgung eines Geschäftsfalles
 * @subpackage Structs
 */
class GetBusinessCaseRequest extends AbstractStructBase
{
    /**
     * The login
     * @var \StructType\Login
     */
    public $login;
    /**
     * The businessCaseNumber
     * Meta information extracted from the WSDL
     * - documentation: ID des Geschäftsfalles in der eVP
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $businessCaseNumber;
    /**
     * The businessCaseNumberAsString
     * Meta information extracted from the WSDL
     * - documentation: ID des Geschäftsfalles als String in der eVP
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $businessCaseNumberAsString;
    /**
     * Constructor method for getBusinessCaseRequest
     * @uses GetBusinessCaseRequest::setLogin()
     * @uses GetBusinessCaseRequest::setBusinessCaseNumber()
     * @uses GetBusinessCaseRequest::setBusinessCaseNumberAsString()
     * @param \StructType\Login $login
     * @param int $businessCaseNumber
     * @param string $businessCaseNumberAsString
     */
    public function __construct(\StructType\Login $login = null, $businessCaseNumber = null, $businessCaseNumberAsString = null)
    {
        $this
            ->setLogin($login)
            ->setBusinessCaseNumber($businessCaseNumber)
            ->setBusinessCaseNumberAsString($businessCaseNumberAsString);
    }
    /**
     * Get login value
     * @return \StructType\Login|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param \StructType\Login $login
     * @return \StructType\GetBusinessCaseRequest
     */
    public function setLogin(\StructType\Login $login = null)
    {
        $this->login = $login;
        return $this;
    }
    /**
     * Get businessCaseNumber value
     * @return int|null
     */
    public function getBusinessCaseNumber()
    {
        return $this->businessCaseNumber;
    }
    /**
     * Set businessCaseNumber value
     * @param int $businessCaseNumber
     * @return \StructType\GetBusinessCaseRequest
     */
    public function setBusinessCaseNumber($businessCaseNumber = null)
    {
        // validation for constraint: int
        if (!is_null($businessCaseNumber) && !(is_int($businessCaseNumber) || ctype_digit($businessCaseNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($businessCaseNumber, true), gettype($businessCaseNumber)), __LINE__);
        }
        $this->businessCaseNumber = $businessCaseNumber;
        return $this;
    }
    /**
     * Get businessCaseNumberAsString value
     * @return string|null
     */
    public function getBusinessCaseNumberAsString()
    {
        return $this->businessCaseNumberAsString;
    }
    /**
     * Set businessCaseNumberAsString value
     * @param string $businessCaseNumberAsString
     * @return \StructType\GetBusinessCaseRequest
     */
    public function setBusinessCaseNumberAsString($businessCaseNumberAsString = null)
    {
        // validation for constraint: string
        if (!is_null($businessCaseNumberAsString) && !is_string($businessCaseNumberAsString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($businessCaseNumberAsString, true), gettype($businessCaseNumberAsString)), __LINE__);
        }
        $this->businessCaseNumberAsString = $businessCaseNumberAsString;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetBusinessCaseRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
