<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for fahrzeugdatenPkwType StructType
 * @subpackage Structs
 */
class FahrzeugdatenPkwType extends AbstractStructBase
{
    /**
     * The zulassungsbezirk
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $zulassungsbezirk;
    /**
     * The kfzArt
     * @var string
     */
    public $kfzArt;
    /**
     * The verwendungsart
     * @var string
     */
    public $verwendungsart;
    /**
     * The taxiMietwagen
     * @var string
     */
    public $taxiMietwagen;
    /**
     * The taxiVerwendungsart
     * Meta information extracted from the WSDL
     * - documentation: Dieses Feld ist nur sichtbar, wenn im Feld "taxiMietwagen" der Wert 'Taxi' gewählt wird
     * - minOccurs: 0
     * @var string
     */
    public $taxiVerwendungsart;
    /**
     * The markePkw
     * @var string
     */
    public $markePkw;
    /**
     * The typeAusfuehrung
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 32
     * @var string
     */
    public $typeAusfuehrung;
    /**
     * The firmenfahrzeug
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $firmenfahrzeug;
    /**
     * The bauartgeschwindigkeit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $bauartgeschwindigkeit;
    /**
     * The bauart
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $bauart;
    /**
     * The erstzulassung
     * @var string
     */
    public $erstzulassung;
    /**
     * The leistungKW
     * @var int
     */
    public $leistungKW;
    /**
     * The co2Ausstoss
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $co2Ausstoss;
    /**
     * The hubraum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $hubraum;
    /**
     * The anzahlPlaetze
     * @var int
     */
    public $anzahlPlaetze;
    /**
     * The eigengewicht
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $eigengewicht;
    /**
     * The gesamtgewichtPkw
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $gesamtgewichtPkw;
    /**
     * The nutzlastPkw
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $nutzlastPkw;
    /**
     * The listenpreis
     * Meta information extracted from the WSDL
     * - documentation: muss für Kasko befüllt sein
     * - minOccurs: 0
     * @var int
     */
    public $listenpreis;
    /**
     * The kaufpreis
     * Meta information extracted from the WSDL
     * - documentation: muss für Leasing befüllt sein
     * - minOccurs: 0
     * @var int
     */
    public $kaufpreis;
    /**
     * The antriebsart
     * @var string
     */
    public $antriebsart;
    /**
     * The befreiungsgrund
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $befreiungsgrund;
    /**
     * The gueterbefoerderungPkw
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $gueterbefoerderungPkw;
    /**
     * The gefaehrlicheGueter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $gefaehrlicheGueter;
    /**
     * The ohneKennzeichen
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ohneKennzeichen;
    /**
     * The schneeraeumung
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $schneeraeumung;
    /**
     * The selbstvermietung
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $selbstvermietung;
    /**
     * The oldtimer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $oldtimer;
    /**
     * The akkubewertung
     * Meta information extracted from the WSDL
     * - documentation: bei Elektroantrieb benötigt (ab 02/2018)
     * - minOccurs: 0
     * @var string
     */
    public $akkubewertung;
    /**
     * The akkuwert
     * Meta information extracted from the WSDL
     * - documentation: bei "Akku mitversichert (im Fahrzeugwert nicht enthalten)" benötigt
     * - minOccurs: 0
     * @var int
     */
    public $akkuwert;
    /**
     * Constructor method for fahrzeugdatenPkwType
     * @uses FahrzeugdatenPkwType::setZulassungsbezirk()
     * @uses FahrzeugdatenPkwType::setKfzArt()
     * @uses FahrzeugdatenPkwType::setVerwendungsart()
     * @uses FahrzeugdatenPkwType::setTaxiMietwagen()
     * @uses FahrzeugdatenPkwType::setTaxiVerwendungsart()
     * @uses FahrzeugdatenPkwType::setMarkePkw()
     * @uses FahrzeugdatenPkwType::setTypeAusfuehrung()
     * @uses FahrzeugdatenPkwType::setFirmenfahrzeug()
     * @uses FahrzeugdatenPkwType::setBauartgeschwindigkeit()
     * @uses FahrzeugdatenPkwType::setBauart()
     * @uses FahrzeugdatenPkwType::setErstzulassung()
     * @uses FahrzeugdatenPkwType::setLeistungKW()
     * @uses FahrzeugdatenPkwType::setCo2Ausstoss()
     * @uses FahrzeugdatenPkwType::setHubraum()
     * @uses FahrzeugdatenPkwType::setAnzahlPlaetze()
     * @uses FahrzeugdatenPkwType::setEigengewicht()
     * @uses FahrzeugdatenPkwType::setGesamtgewichtPkw()
     * @uses FahrzeugdatenPkwType::setNutzlastPkw()
     * @uses FahrzeugdatenPkwType::setListenpreis()
     * @uses FahrzeugdatenPkwType::setKaufpreis()
     * @uses FahrzeugdatenPkwType::setAntriebsart()
     * @uses FahrzeugdatenPkwType::setBefreiungsgrund()
     * @uses FahrzeugdatenPkwType::setGueterbefoerderungPkw()
     * @uses FahrzeugdatenPkwType::setGefaehrlicheGueter()
     * @uses FahrzeugdatenPkwType::setOhneKennzeichen()
     * @uses FahrzeugdatenPkwType::setSchneeraeumung()
     * @uses FahrzeugdatenPkwType::setSelbstvermietung()
     * @uses FahrzeugdatenPkwType::setOldtimer()
     * @uses FahrzeugdatenPkwType::setAkkubewertung()
     * @uses FahrzeugdatenPkwType::setAkkuwert()
     * @param string $zulassungsbezirk
     * @param string $kfzArt
     * @param string $verwendungsart
     * @param string $taxiMietwagen
     * @param string $taxiVerwendungsart
     * @param string $markePkw
     * @param string $typeAusfuehrung
     * @param string $firmenfahrzeug
     * @param int $bauartgeschwindigkeit
     * @param string $bauart
     * @param string $erstzulassung
     * @param int $leistungKW
     * @param int $co2Ausstoss
     * @param int $hubraum
     * @param int $anzahlPlaetze
     * @param int $eigengewicht
     * @param int $gesamtgewichtPkw
     * @param int $nutzlastPkw
     * @param int $listenpreis
     * @param int $kaufpreis
     * @param string $antriebsart
     * @param string $befreiungsgrund
     * @param string $gueterbefoerderungPkw
     * @param string $gefaehrlicheGueter
     * @param string $ohneKennzeichen
     * @param string $schneeraeumung
     * @param string $selbstvermietung
     * @param string $oldtimer
     * @param string $akkubewertung
     * @param int $akkuwert
     */
    public function __construct($zulassungsbezirk = null, $kfzArt = null, $verwendungsart = null, $taxiMietwagen = null, $taxiVerwendungsart = null, $markePkw = null, $typeAusfuehrung = null, $firmenfahrzeug = null, $bauartgeschwindigkeit = null, $bauart = null, $erstzulassung = null, $leistungKW = null, $co2Ausstoss = null, $hubraum = null, $anzahlPlaetze = null, $eigengewicht = null, $gesamtgewichtPkw = null, $nutzlastPkw = null, $listenpreis = null, $kaufpreis = null, $antriebsart = null, $befreiungsgrund = null, $gueterbefoerderungPkw = null, $gefaehrlicheGueter = null, $ohneKennzeichen = null, $schneeraeumung = null, $selbstvermietung = null, $oldtimer = null, $akkubewertung = null, $akkuwert = null)
    {
        $this
            ->setZulassungsbezirk($zulassungsbezirk)
            ->setKfzArt($kfzArt)
            ->setVerwendungsart($verwendungsart)
            ->setTaxiMietwagen($taxiMietwagen)
            ->setTaxiVerwendungsart($taxiVerwendungsart)
            ->setMarkePkw($markePkw)
            ->setTypeAusfuehrung($typeAusfuehrung)
            ->setFirmenfahrzeug($firmenfahrzeug)
            ->setBauartgeschwindigkeit($bauartgeschwindigkeit)
            ->setBauart($bauart)
            ->setErstzulassung($erstzulassung)
            ->setLeistungKW($leistungKW)
            ->setCo2Ausstoss($co2Ausstoss)
            ->setHubraum($hubraum)
            ->setAnzahlPlaetze($anzahlPlaetze)
            ->setEigengewicht($eigengewicht)
            ->setGesamtgewichtPkw($gesamtgewichtPkw)
            ->setNutzlastPkw($nutzlastPkw)
            ->setListenpreis($listenpreis)
            ->setKaufpreis($kaufpreis)
            ->setAntriebsart($antriebsart)
            ->setBefreiungsgrund($befreiungsgrund)
            ->setGueterbefoerderungPkw($gueterbefoerderungPkw)
            ->setGefaehrlicheGueter($gefaehrlicheGueter)
            ->setOhneKennzeichen($ohneKennzeichen)
            ->setSchneeraeumung($schneeraeumung)
            ->setSelbstvermietung($selbstvermietung)
            ->setOldtimer($oldtimer)
            ->setAkkubewertung($akkubewertung)
            ->setAkkuwert($akkuwert);
    }
    /**
     * Get zulassungsbezirk value
     * @return string|null
     */
    public function getZulassungsbezirk()
    {
        return $this->zulassungsbezirk;
    }
    /**
     * Set zulassungsbezirk value
     * @uses \EnumType\ZulassungsbezirkType::valueIsValid()
     * @uses \EnumType\ZulassungsbezirkType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $zulassungsbezirk
     * @return \StructType\FahrzeugdatenPkwType
     */
    public function setZulassungsbezirk($zulassungsbezirk = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ZulassungsbezirkType::valueIsValid($zulassungsbezirk)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ZulassungsbezirkType', is_array($zulassungsbezirk) ? implode(', ', $zulassungsbezirk) : var_export($zulassungsbezirk, true), implode(', ', \EnumType\ZulassungsbezirkType::getValidValues())), __LINE__);
        }
        $this->zulassungsbezirk = $zulassungsbezirk;
        return $this;
    }
    /**
     * Get kfzArt value
     * @return string|null
     */
    public function getKfzArt()
    {
        return $this->kfzArt;
    }
    /**
     * Set kfzArt value
     * @uses \EnumType\KfzArtType::valueIsValid()
     * @uses \EnumType\KfzArtType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $kfzArt
     * @return \StructType\FahrzeugdatenPkwType
     */
    public function setKfzArt($kfzArt = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\KfzArtType::valueIsValid($kfzArt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\KfzArtType', is_array($kfzArt) ? implode(', ', $kfzArt) : var_export($kfzArt, true), implode(', ', \EnumType\KfzArtType::getValidValues())), __LINE__);
        }
        $this->kfzArt = $kfzArt;
        return $this;
    }
    /**
     * Get verwendungsart value
     * @return string|null
     */
    public function getVerwendungsart()
    {
        return $this->verwendungsart;
    }
    /**
     * Set verwendungsart value
     * @uses \EnumType\KfzVerwendungType::valueIsValid()
     * @uses \EnumType\KfzVerwendungType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $verwendungsart
     * @return \StructType\FahrzeugdatenPkwType
     */
    public function setVerwendungsart($verwendungsart = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\KfzVerwendungType::valueIsValid($verwendungsart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\KfzVerwendungType', is_array($verwendungsart) ? implode(', ', $verwendungsart) : var_export($verwendungsart, true), implode(', ', \EnumType\KfzVerwendungType::getValidValues())), __LINE__);
        }
        $this->verwendungsart = $verwendungsart;
        return $this;
    }
    /**
     * Get taxiMietwagen value
     * @return string|null
     */
    public function getTaxiMietwagen()
    {
        return $this->taxiMietwagen;
    }
    /**
     * Set taxiMietwagen value
     * @uses \EnumType\JaNeinType::valueIsValid()
     * @uses \EnumType\JaNeinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $taxiMietwagen
     * @return \StructType\FahrzeugdatenPkwType
     */
    public function setTaxiMietwagen($taxiMietwagen = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JaNeinType::valueIsValid($taxiMietwagen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JaNeinType', is_array($taxiMietwagen) ? implode(', ', $taxiMietwagen) : var_export($taxiMietwagen, true), implode(', ', \EnumType\JaNeinType::getValidValues())), __LINE__);
        }
        $this->taxiMietwagen = $taxiMietwagen;
        return $this;
    }
    /**
     * Get taxiVerwendungsart value
     * @return string|null
     */
    public function getTaxiVerwendungsart()
    {
        return $this->taxiVerwendungsart;
    }
    /**
     * Set taxiVerwendungsart value
     * @uses \EnumType\TaxiVerwendungsartType::valueIsValid()
     * @uses \EnumType\TaxiVerwendungsartType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $taxiVerwendungsart
     * @return \StructType\FahrzeugdatenPkwType
     */
    public function setTaxiVerwendungsart($taxiVerwendungsart = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TaxiVerwendungsartType::valueIsValid($taxiVerwendungsart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TaxiVerwendungsartType', is_array($taxiVerwendungsart) ? implode(', ', $taxiVerwendungsart) : var_export($taxiVerwendungsart, true), implode(', ', \EnumType\TaxiVerwendungsartType::getValidValues())), __LINE__);
        }
        $this->taxiVerwendungsart = $taxiVerwendungsart;
        return $this;
    }
    /**
     * Get markePkw value
     * @return string|null
     */
    public function getMarkePkw()
    {
        return $this->markePkw;
    }
    /**
     * Set markePkw value
     * @param string $markePkw
     * @return \StructType\FahrzeugdatenPkwType
     */
    public function setMarkePkw($markePkw = null)
    {
        // validation for constraint: string
        if (!is_null($markePkw) && !is_string($markePkw)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($markePkw, true), gettype($markePkw)), __LINE__);
        }
        $this->markePkw = $markePkw;
        return $this;
    }
    /**
     * Get typeAusfuehrung value
     * @return string|null
     */
    public function getTypeAusfuehrung()
    {
        return $this->typeAusfuehrung;
    }
    /**
     * Set typeAusfuehrung value
     * @param string $typeAusfuehrung
     * @return \StructType\FahrzeugdatenPkwType
     */
    public function setTypeAusfuehrung($typeAusfuehrung = null)
    {
        // validation for constraint: string
        if (!is_null($typeAusfuehrung) && !is_string($typeAusfuehrung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeAusfuehrung, true), gettype($typeAusfuehrung)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($typeAusfuehrung) && mb_strlen($typeAusfuehrung) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($typeAusfuehrung)), __LINE__);
        }
        $this->typeAusfuehrung = $typeAusfuehrung;
        return $this;
    }
    /**
     * Get firmenfahrzeug value
     * @return string|null
     */
    public function getFirmenfahrzeug()
    {
        return $this->firmenfahrzeug;
    }
    /**
     * Set firmenfahrzeug value
     * @uses \EnumType\JaNeinType::valueIsValid()
     * @uses \EnumType\JaNeinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $firmenfahrzeug
     * @return \StructType\FahrzeugdatenPkwType
     */
    public function setFirmenfahrzeug($firmenfahrzeug = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JaNeinType::valueIsValid($firmenfahrzeug)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JaNeinType', is_array($firmenfahrzeug) ? implode(', ', $firmenfahrzeug) : var_export($firmenfahrzeug, true), implode(', ', \EnumType\JaNeinType::getValidValues())), __LINE__);
        }
        $this->firmenfahrzeug = $firmenfahrzeug;
        return $this;
    }
    /**
     * Get bauartgeschwindigkeit value
     * @return int|null
     */
    public function getBauartgeschwindigkeit()
    {
        return $this->bauartgeschwindigkeit;
    }
    /**
     * Set bauartgeschwindigkeit value
     * @param int $bauartgeschwindigkeit
     * @return \StructType\FahrzeugdatenPkwType
     */
    public function setBauartgeschwindigkeit($bauartgeschwindigkeit = null)
    {
        // validation for constraint: int
        if (!is_null($bauartgeschwindigkeit) && !(is_int($bauartgeschwindigkeit) || ctype_digit($bauartgeschwindigkeit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bauartgeschwindigkeit, true), gettype($bauartgeschwindigkeit)), __LINE__);
        }
        $this->bauartgeschwindigkeit = $bauartgeschwindigkeit;
        return $this;
    }
    /**
     * Get bauart value
     * @return string|null
     */
    public function getBauart()
    {
        return $this->bauart;
    }
    /**
     * Set bauart value
     * @uses \EnumType\BauartType::valueIsValid()
     * @uses \EnumType\BauartType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $bauart
     * @return \StructType\FahrzeugdatenPkwType
     */
    public function setBauart($bauart = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BauartType::valueIsValid($bauart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BauartType', is_array($bauart) ? implode(', ', $bauart) : var_export($bauart, true), implode(', ', \EnumType\BauartType::getValidValues())), __LINE__);
        }
        $this->bauart = $bauart;
        return $this;
    }
    /**
     * Get erstzulassung value
     * @return string|null
     */
    public function getErstzulassung()
    {
        return $this->erstzulassung;
    }
    /**
     * Set erstzulassung value
     * @param string $erstzulassung
     * @return \StructType\FahrzeugdatenPkwType
     */
    public function setErstzulassung($erstzulassung = null)
    {
        // validation for constraint: string
        if (!is_null($erstzulassung) && !is_string($erstzulassung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($erstzulassung, true), gettype($erstzulassung)), __LINE__);
        }
        $this->erstzulassung = $erstzulassung;
        return $this;
    }
    /**
     * Get leistungKW value
     * @return int|null
     */
    public function getLeistungKW()
    {
        return $this->leistungKW;
    }
    /**
     * Set leistungKW value
     * @param int $leistungKW
     * @return \StructType\FahrzeugdatenPkwType
     */
    public function setLeistungKW($leistungKW = null)
    {
        // validation for constraint: int
        if (!is_null($leistungKW) && !(is_int($leistungKW) || ctype_digit($leistungKW))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($leistungKW, true), gettype($leistungKW)), __LINE__);
        }
        $this->leistungKW = $leistungKW;
        return $this;
    }
    /**
     * Get co2Ausstoss value
     * @return int|null
     */
    public function getCo2Ausstoss()
    {
        return $this->co2Ausstoss;
    }
    /**
     * Set co2Ausstoss value
     * @param int $co2Ausstoss
     * @return \StructType\FahrzeugdatenPkwType
     */
    public function setCo2Ausstoss($co2Ausstoss = null)
    {
        // validation for constraint: int
        if (!is_null($co2Ausstoss) && !(is_int($co2Ausstoss) || ctype_digit($co2Ausstoss))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($co2Ausstoss, true), gettype($co2Ausstoss)), __LINE__);
        }
        $this->co2Ausstoss = $co2Ausstoss;
        return $this;
    }
    /**
     * Get hubraum value
     * @return int|null
     */
    public function getHubraum()
    {
        return $this->hubraum;
    }
    /**
     * Set hubraum value
     * @param int $hubraum
     * @return \StructType\FahrzeugdatenPkwType
     */
    public function setHubraum($hubraum = null)
    {
        // validation for constraint: int
        if (!is_null($hubraum) && !(is_int($hubraum) || ctype_digit($hubraum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hubraum, true), gettype($hubraum)), __LINE__);
        }
        $this->hubraum = $hubraum;
        return $this;
    }
    /**
     * Get anzahlPlaetze value
     * @return int|null
     */
    public function getAnzahlPlaetze()
    {
        return $this->anzahlPlaetze;
    }
    /**
     * Set anzahlPlaetze value
     * @param int $anzahlPlaetze
     * @return \StructType\FahrzeugdatenPkwType
     */
    public function setAnzahlPlaetze($anzahlPlaetze = null)
    {
        // validation for constraint: int
        if (!is_null($anzahlPlaetze) && !(is_int($anzahlPlaetze) || ctype_digit($anzahlPlaetze))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anzahlPlaetze, true), gettype($anzahlPlaetze)), __LINE__);
        }
        $this->anzahlPlaetze = $anzahlPlaetze;
        return $this;
    }
    /**
     * Get eigengewicht value
     * @return int|null
     */
    public function getEigengewicht()
    {
        return $this->eigengewicht;
    }
    /**
     * Set eigengewicht value
     * @param int $eigengewicht
     * @return \StructType\FahrzeugdatenPkwType
     */
    public function setEigengewicht($eigengewicht = null)
    {
        // validation for constraint: int
        if (!is_null($eigengewicht) && !(is_int($eigengewicht) || ctype_digit($eigengewicht))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($eigengewicht, true), gettype($eigengewicht)), __LINE__);
        }
        $this->eigengewicht = $eigengewicht;
        return $this;
    }
    /**
     * Get gesamtgewichtPkw value
     * @return int|null
     */
    public function getGesamtgewichtPkw()
    {
        return $this->gesamtgewichtPkw;
    }
    /**
     * Set gesamtgewichtPkw value
     * @param int $gesamtgewichtPkw
     * @return \StructType\FahrzeugdatenPkwType
     */
    public function setGesamtgewichtPkw($gesamtgewichtPkw = null)
    {
        // validation for constraint: int
        if (!is_null($gesamtgewichtPkw) && !(is_int($gesamtgewichtPkw) || ctype_digit($gesamtgewichtPkw))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($gesamtgewichtPkw, true), gettype($gesamtgewichtPkw)), __LINE__);
        }
        $this->gesamtgewichtPkw = $gesamtgewichtPkw;
        return $this;
    }
    /**
     * Get nutzlastPkw value
     * @return int|null
     */
    public function getNutzlastPkw()
    {
        return $this->nutzlastPkw;
    }
    /**
     * Set nutzlastPkw value
     * @param int $nutzlastPkw
     * @return \StructType\FahrzeugdatenPkwType
     */
    public function setNutzlastPkw($nutzlastPkw = null)
    {
        // validation for constraint: int
        if (!is_null($nutzlastPkw) && !(is_int($nutzlastPkw) || ctype_digit($nutzlastPkw))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nutzlastPkw, true), gettype($nutzlastPkw)), __LINE__);
        }
        $this->nutzlastPkw = $nutzlastPkw;
        return $this;
    }
    /**
     * Get listenpreis value
     * @return int|null
     */
    public function getListenpreis()
    {
        return $this->listenpreis;
    }
    /**
     * Set listenpreis value
     * @param int $listenpreis
     * @return \StructType\FahrzeugdatenPkwType
     */
    public function setListenpreis($listenpreis = null)
    {
        // validation for constraint: int
        if (!is_null($listenpreis) && !(is_int($listenpreis) || ctype_digit($listenpreis))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($listenpreis, true), gettype($listenpreis)), __LINE__);
        }
        $this->listenpreis = $listenpreis;
        return $this;
    }
    /**
     * Get kaufpreis value
     * @return int|null
     */
    public function getKaufpreis()
    {
        return $this->kaufpreis;
    }
    /**
     * Set kaufpreis value
     * @param int $kaufpreis
     * @return \StructType\FahrzeugdatenPkwType
     */
    public function setKaufpreis($kaufpreis = null)
    {
        // validation for constraint: int
        if (!is_null($kaufpreis) && !(is_int($kaufpreis) || ctype_digit($kaufpreis))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kaufpreis, true), gettype($kaufpreis)), __LINE__);
        }
        $this->kaufpreis = $kaufpreis;
        return $this;
    }
    /**
     * Get antriebsart value
     * @return string|null
     */
    public function getAntriebsart()
    {
        return $this->antriebsart;
    }
    /**
     * Set antriebsart value
     * @uses \EnumType\AntriebsartType::valueIsValid()
     * @uses \EnumType\AntriebsartType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $antriebsart
     * @return \StructType\FahrzeugdatenPkwType
     */
    public function setAntriebsart($antriebsart = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AntriebsartType::valueIsValid($antriebsart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AntriebsartType', is_array($antriebsart) ? implode(', ', $antriebsart) : var_export($antriebsart, true), implode(', ', \EnumType\AntriebsartType::getValidValues())), __LINE__);
        }
        $this->antriebsart = $antriebsart;
        return $this;
    }
    /**
     * Get befreiungsgrund value
     * @return string|null
     */
    public function getBefreiungsgrund()
    {
        return $this->befreiungsgrund;
    }
    /**
     * Set befreiungsgrund value
     * @uses \EnumType\BefreiungsgrundType::valueIsValid()
     * @uses \EnumType\BefreiungsgrundType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $befreiungsgrund
     * @return \StructType\FahrzeugdatenPkwType
     */
    public function setBefreiungsgrund($befreiungsgrund = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BefreiungsgrundType::valueIsValid($befreiungsgrund)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BefreiungsgrundType', is_array($befreiungsgrund) ? implode(', ', $befreiungsgrund) : var_export($befreiungsgrund, true), implode(', ', \EnumType\BefreiungsgrundType::getValidValues())), __LINE__);
        }
        $this->befreiungsgrund = $befreiungsgrund;
        return $this;
    }
    /**
     * Get gueterbefoerderungPkw value
     * @return string|null
     */
    public function getGueterbefoerderungPkw()
    {
        return $this->gueterbefoerderungPkw;
    }
    /**
     * Set gueterbefoerderungPkw value
     * @uses \EnumType\JaNeinType::valueIsValid()
     * @uses \EnumType\JaNeinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $gueterbefoerderungPkw
     * @return \StructType\FahrzeugdatenPkwType
     */
    public function setGueterbefoerderungPkw($gueterbefoerderungPkw = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JaNeinType::valueIsValid($gueterbefoerderungPkw)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JaNeinType', is_array($gueterbefoerderungPkw) ? implode(', ', $gueterbefoerderungPkw) : var_export($gueterbefoerderungPkw, true), implode(', ', \EnumType\JaNeinType::getValidValues())), __LINE__);
        }
        $this->gueterbefoerderungPkw = $gueterbefoerderungPkw;
        return $this;
    }
    /**
     * Get gefaehrlicheGueter value
     * @return string|null
     */
    public function getGefaehrlicheGueter()
    {
        return $this->gefaehrlicheGueter;
    }
    /**
     * Set gefaehrlicheGueter value
     * @uses \EnumType\JaNeinType::valueIsValid()
     * @uses \EnumType\JaNeinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $gefaehrlicheGueter
     * @return \StructType\FahrzeugdatenPkwType
     */
    public function setGefaehrlicheGueter($gefaehrlicheGueter = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JaNeinType::valueIsValid($gefaehrlicheGueter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JaNeinType', is_array($gefaehrlicheGueter) ? implode(', ', $gefaehrlicheGueter) : var_export($gefaehrlicheGueter, true), implode(', ', \EnumType\JaNeinType::getValidValues())), __LINE__);
        }
        $this->gefaehrlicheGueter = $gefaehrlicheGueter;
        return $this;
    }
    /**
     * Get ohneKennzeichen value
     * @return string|null
     */
    public function getOhneKennzeichen()
    {
        return $this->ohneKennzeichen;
    }
    /**
     * Set ohneKennzeichen value
     * @uses \EnumType\JaNeinType::valueIsValid()
     * @uses \EnumType\JaNeinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ohneKennzeichen
     * @return \StructType\FahrzeugdatenPkwType
     */
    public function setOhneKennzeichen($ohneKennzeichen = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JaNeinType::valueIsValid($ohneKennzeichen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JaNeinType', is_array($ohneKennzeichen) ? implode(', ', $ohneKennzeichen) : var_export($ohneKennzeichen, true), implode(', ', \EnumType\JaNeinType::getValidValues())), __LINE__);
        }
        $this->ohneKennzeichen = $ohneKennzeichen;
        return $this;
    }
    /**
     * Get schneeraeumung value
     * @return string|null
     */
    public function getSchneeraeumung()
    {
        return $this->schneeraeumung;
    }
    /**
     * Set schneeraeumung value
     * @uses \EnumType\JaNeinType::valueIsValid()
     * @uses \EnumType\JaNeinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $schneeraeumung
     * @return \StructType\FahrzeugdatenPkwType
     */
    public function setSchneeraeumung($schneeraeumung = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JaNeinType::valueIsValid($schneeraeumung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JaNeinType', is_array($schneeraeumung) ? implode(', ', $schneeraeumung) : var_export($schneeraeumung, true), implode(', ', \EnumType\JaNeinType::getValidValues())), __LINE__);
        }
        $this->schneeraeumung = $schneeraeumung;
        return $this;
    }
    /**
     * Get selbstvermietung value
     * @return string|null
     */
    public function getSelbstvermietung()
    {
        return $this->selbstvermietung;
    }
    /**
     * Set selbstvermietung value
     * @uses \EnumType\JaNeinType::valueIsValid()
     * @uses \EnumType\JaNeinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $selbstvermietung
     * @return \StructType\FahrzeugdatenPkwType
     */
    public function setSelbstvermietung($selbstvermietung = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JaNeinType::valueIsValid($selbstvermietung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JaNeinType', is_array($selbstvermietung) ? implode(', ', $selbstvermietung) : var_export($selbstvermietung, true), implode(', ', \EnumType\JaNeinType::getValidValues())), __LINE__);
        }
        $this->selbstvermietung = $selbstvermietung;
        return $this;
    }
    /**
     * Get oldtimer value
     * @return string|null
     */
    public function getOldtimer()
    {
        return $this->oldtimer;
    }
    /**
     * Set oldtimer value
     * @uses \EnumType\JaNeinType::valueIsValid()
     * @uses \EnumType\JaNeinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $oldtimer
     * @return \StructType\FahrzeugdatenPkwType
     */
    public function setOldtimer($oldtimer = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JaNeinType::valueIsValid($oldtimer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JaNeinType', is_array($oldtimer) ? implode(', ', $oldtimer) : var_export($oldtimer, true), implode(', ', \EnumType\JaNeinType::getValidValues())), __LINE__);
        }
        $this->oldtimer = $oldtimer;
        return $this;
    }
    /**
     * Get akkubewertung value
     * @return string|null
     */
    public function getAkkubewertung()
    {
        return $this->akkubewertung;
    }
    /**
     * Set akkubewertung value
     * @uses \EnumType\AkkubewertungType::valueIsValid()
     * @uses \EnumType\AkkubewertungType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $akkubewertung
     * @return \StructType\FahrzeugdatenPkwType
     */
    public function setAkkubewertung($akkubewertung = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AkkubewertungType::valueIsValid($akkubewertung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AkkubewertungType', is_array($akkubewertung) ? implode(', ', $akkubewertung) : var_export($akkubewertung, true), implode(', ', \EnumType\AkkubewertungType::getValidValues())), __LINE__);
        }
        $this->akkubewertung = $akkubewertung;
        return $this;
    }
    /**
     * Get akkuwert value
     * @return int|null
     */
    public function getAkkuwert()
    {
        return $this->akkuwert;
    }
    /**
     * Set akkuwert value
     * @param int $akkuwert
     * @return \StructType\FahrzeugdatenPkwType
     */
    public function setAkkuwert($akkuwert = null)
    {
        // validation for constraint: int
        if (!is_null($akkuwert) && !(is_int($akkuwert) || ctype_digit($akkuwert))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($akkuwert, true), gettype($akkuwert)), __LINE__);
        }
        $this->akkuwert = $akkuwert;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FahrzeugdatenPkwType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
