<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createPartnerGroupRequest StructType
 * @subpackage Structs
 */
class CreatePartnerGroupRequest extends AbstractStructBase
{
    /**
     * The customerPaOid
     * Meta information extracted from the WSDL
     * - maxOccurs: 2000
     * - minOccurs: 1
     * @var string[]
     */
    public $customerPaOid;
    /**
     * The login
     * @var \StructType\Login
     */
    public $login;
    /**
     * The groupName
     * @var string
     */
    public $groupName;
    /**
     * Constructor method for createPartnerGroupRequest
     * @uses CreatePartnerGroupRequest::setCustomerPaOid()
     * @uses CreatePartnerGroupRequest::setLogin()
     * @uses CreatePartnerGroupRequest::setGroupName()
     * @param string[] $customerPaOid
     * @param \StructType\Login $login
     * @param string $groupName
     */
    public function __construct(array $customerPaOid = array(), \StructType\Login $login = null, $groupName = null)
    {
        $this
            ->setCustomerPaOid($customerPaOid)
            ->setLogin($login)
            ->setGroupName($groupName);
    }
    /**
     * Get customerPaOid value
     * @return string[]
     */
    public function getCustomerPaOid()
    {
        return $this->customerPaOid;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomerPaOid method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomerPaOid method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomerPaOidForArrayConstraintsFromSetCustomerPaOid(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $createPartnerGroupRequestCustomerPaOidItem) {
            // validation for constraint: itemType
            if (!is_string($createPartnerGroupRequestCustomerPaOidItem)) {
                $invalidValues[] = is_object($createPartnerGroupRequestCustomerPaOidItem) ? get_class($createPartnerGroupRequestCustomerPaOidItem) : sprintf('%s(%s)', gettype($createPartnerGroupRequestCustomerPaOidItem), var_export($createPartnerGroupRequestCustomerPaOidItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The customerPaOid property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set customerPaOid value
     * @throws \InvalidArgumentException
     * @param string[] $customerPaOid
     * @return \StructType\CreatePartnerGroupRequest
     */
    public function setCustomerPaOid(array $customerPaOid = array())
    {
        // validation for constraint: array
        if ('' !== ($customerPaOidArrayErrorMessage = self::validateCustomerPaOidForArrayConstraintsFromSetCustomerPaOid($customerPaOid))) {
            throw new \InvalidArgumentException($customerPaOidArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2000)
        if (is_array($customerPaOid) && count($customerPaOid) > 2000) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2000', count($customerPaOid)), __LINE__);
        }
        $this->customerPaOid = $customerPaOid;
        return $this;
    }
    /**
     * Add item to customerPaOid value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\CreatePartnerGroupRequest
     */
    public function addToCustomerPaOid($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The customerPaOid property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(2000)
        if (is_array($this->customerPaOid) && count($this->customerPaOid) >= 2000) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2000', count($this->customerPaOid)), __LINE__);
        }
        $this->customerPaOid[] = $item;
        return $this;
    }
    /**
     * Get login value
     * @return \StructType\Login|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param \StructType\Login $login
     * @return \StructType\CreatePartnerGroupRequest
     */
    public function setLogin(\StructType\Login $login = null)
    {
        $this->login = $login;
        return $this;
    }
    /**
     * Get groupName value
     * @return string|null
     */
    public function getGroupName()
    {
        return $this->groupName;
    }
    /**
     * Set groupName value
     * @param string $groupName
     * @return \StructType\CreatePartnerGroupRequest
     */
    public function setGroupName($groupName = null)
    {
        // validation for constraint: string
        if (!is_null($groupName) && !is_string($groupName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupName, true), gettype($groupName)), __LINE__);
        }
        $this->groupName = $groupName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreatePartnerGroupRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
