<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BusinessCaseInsuranceHolder StructType
 * Meta information extracted from the WSDL
 * - documentation: Daten zum Versicherungsnehmer
 * @subpackage Structs
 */
class BusinessCaseInsuranceHolder extends AbstractStructBase
{
    /**
     * The firstName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * @var string
     */
    public $firstName;
    /**
     * The sureName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * @var string
     */
    public $sureName;
    /**
     * The title
     * Meta information extracted from the WSDL
     * - documentation: Berufs-, oder akademischer Titel des Kunden
     * - base: xsd:string
     * - maxLength: 20
     * - minOccurs: 0
     * @var string
     */
    public $title;
    /**
     * The poBoxNumber
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 10
     * @var string
     */
    public $poBoxNumber;
    /**
     * The city
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * @var string
     */
    public $city;
    /**
     * The street
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * @var string
     */
    public $street;
    /**
     * Constructor method for BusinessCaseInsuranceHolder
     * @uses BusinessCaseInsuranceHolder::setFirstName()
     * @uses BusinessCaseInsuranceHolder::setSureName()
     * @uses BusinessCaseInsuranceHolder::setTitle()
     * @uses BusinessCaseInsuranceHolder::setPoBoxNumber()
     * @uses BusinessCaseInsuranceHolder::setCity()
     * @uses BusinessCaseInsuranceHolder::setStreet()
     * @param string $firstName
     * @param string $sureName
     * @param string $title
     * @param string $poBoxNumber
     * @param string $city
     * @param string $street
     */
    public function __construct($firstName = null, $sureName = null, $title = null, $poBoxNumber = null, $city = null, $street = null)
    {
        $this
            ->setFirstName($firstName)
            ->setSureName($sureName)
            ->setTitle($title)
            ->setPoBoxNumber($poBoxNumber)
            ->setCity($city)
            ->setStreet($street);
    }
    /**
     * Get firstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->firstName;
    }
    /**
     * Set firstName value
     * @param string $firstName
     * @return \StructType\BusinessCaseInsuranceHolder
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($firstName) && mb_strlen($firstName) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($firstName)), __LINE__);
        }
        $this->firstName = $firstName;
        return $this;
    }
    /**
     * Get sureName value
     * @return string|null
     */
    public function getSureName()
    {
        return $this->sureName;
    }
    /**
     * Set sureName value
     * @param string $sureName
     * @return \StructType\BusinessCaseInsuranceHolder
     */
    public function setSureName($sureName = null)
    {
        // validation for constraint: string
        if (!is_null($sureName) && !is_string($sureName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sureName, true), gettype($sureName)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($sureName) && mb_strlen($sureName) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($sureName)), __LINE__);
        }
        $this->sureName = $sureName;
        return $this;
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \StructType\BusinessCaseInsuranceHolder
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($title) && mb_strlen($title) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get poBoxNumber value
     * @return string|null
     */
    public function getPoBoxNumber()
    {
        return $this->poBoxNumber;
    }
    /**
     * Set poBoxNumber value
     * @param string $poBoxNumber
     * @return \StructType\BusinessCaseInsuranceHolder
     */
    public function setPoBoxNumber($poBoxNumber = null)
    {
        // validation for constraint: string
        if (!is_null($poBoxNumber) && !is_string($poBoxNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($poBoxNumber, true), gettype($poBoxNumber)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($poBoxNumber) && mb_strlen($poBoxNumber) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($poBoxNumber)), __LINE__);
        }
        $this->poBoxNumber = $poBoxNumber;
        return $this;
    }
    /**
     * Get city value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \StructType\BusinessCaseInsuranceHolder
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($city) && mb_strlen($city) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get street value
     * @return string|null
     */
    public function getStreet()
    {
        return $this->street;
    }
    /**
     * Set street value
     * @param string $street
     * @return \StructType\BusinessCaseInsuranceHolder
     */
    public function setStreet($street = null)
    {
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street, true), gettype($street)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($street) && mb_strlen($street) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($street)), __LINE__);
        }
        $this->street = $street;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BusinessCaseInsuranceHolder
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
