<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for beratungsdokumentationType StructType
 * @subpackage Structs
 */
class BeratungsdokumentationType extends AbstractStructBase
{
    /**
     * The anrede
     * Meta information extracted from the WSDL
     * - documentation: Optional, weil der Wert auch aus den Benutzerdaten übernommen wird
     * - minOccurs: 0
     * @var string
     */
    public $anrede;
    /**
     * The zuname
     * Meta information extracted from the WSDL
     * - documentation: Optional, weil der Wert auch aus den Benutzerdaten übernommen wird
     * - base: xs:string
     * - maxLength: 40
     * - minOccurs: 0
     * @var string
     */
    public $zuname;
    /**
     * The vorname
     * Meta information extracted from the WSDL
     * - documentation: Optional, weil der Wert auch aus den Benutzerdaten übernommen wird
     * - base: xs:string
     * - maxLength: 40
     * - minOccurs: 0
     * @var string
     */
    public $vorname;
    /**
     * The gisaZahl
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 40
     * - minOccurs: 0
     * @var string
     */
    public $gisaZahl;
    /**
     * The vertriebsArt
     * Meta information extracted from the WSDL
     * - documentation: Art des Vertriebs
     * - minOccurs: 0
     * @var string
     */
    public $vertriebsArt;
    /**
     * The versicherungsagentInDer
     * Meta information extracted from the WSDL
     * - documentation: muss bei Mehrfachagent ausgefüllt werden
     * - base: xs:string
     * - maxLength: 40
     * - minOccurs: 0
     * @var string
     */
    public $versicherungsagentInDer;
    /**
     * The freierText
     * Meta information extracted from the WSDL
     * - documentation: Sonstige Ergebnisse anlässlich des Beratungsgeprächs
     * - minOccurs: 0
     * @var string
     */
    public $freierText;
    /**
     * The datum
     * Meta information extracted from the WSDL
     * - documentation: Datum des Beratungsgesprächs (Tagesdatum wenn nicht mitgeschickt)
     * - minOccurs: 0
     * @var string
     */
    public $datum;
    /**
     * The dauer
     * Meta information extracted from the WSDL
     * - documentation: Gesprächsdauer (in Minuten)
     * @var int
     */
    public $dauer;
    /**
     * Constructor method for beratungsdokumentationType
     * @uses BeratungsdokumentationType::setAnrede()
     * @uses BeratungsdokumentationType::setZuname()
     * @uses BeratungsdokumentationType::setVorname()
     * @uses BeratungsdokumentationType::setGisaZahl()
     * @uses BeratungsdokumentationType::setVertriebsArt()
     * @uses BeratungsdokumentationType::setVersicherungsagentInDer()
     * @uses BeratungsdokumentationType::setFreierText()
     * @uses BeratungsdokumentationType::setDatum()
     * @uses BeratungsdokumentationType::setDauer()
     * @param string $anrede
     * @param string $zuname
     * @param string $vorname
     * @param string $gisaZahl
     * @param string $vertriebsArt
     * @param string $versicherungsagentInDer
     * @param string $freierText
     * @param string $datum
     * @param int $dauer
     */
    public function __construct($anrede = null, $zuname = null, $vorname = null, $gisaZahl = null, $vertriebsArt = null, $versicherungsagentInDer = null, $freierText = null, $datum = null, $dauer = null)
    {
        $this
            ->setAnrede($anrede)
            ->setZuname($zuname)
            ->setVorname($vorname)
            ->setGisaZahl($gisaZahl)
            ->setVertriebsArt($vertriebsArt)
            ->setVersicherungsagentInDer($versicherungsagentInDer)
            ->setFreierText($freierText)
            ->setDatum($datum)
            ->setDauer($dauer);
    }
    /**
     * Get anrede value
     * @return string|null
     */
    public function getAnrede()
    {
        return $this->anrede;
    }
    /**
     * Set anrede value
     * @uses \EnumType\AnredeType::valueIsValid()
     * @uses \EnumType\AnredeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $anrede
     * @return \StructType\BeratungsdokumentationType
     */
    public function setAnrede($anrede = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AnredeType::valueIsValid($anrede)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AnredeType', is_array($anrede) ? implode(', ', $anrede) : var_export($anrede, true), implode(', ', \EnumType\AnredeType::getValidValues())), __LINE__);
        }
        $this->anrede = $anrede;
        return $this;
    }
    /**
     * Get zuname value
     * @return string|null
     */
    public function getZuname()
    {
        return $this->zuname;
    }
    /**
     * Set zuname value
     * @param string $zuname
     * @return \StructType\BeratungsdokumentationType
     */
    public function setZuname($zuname = null)
    {
        // validation for constraint: string
        if (!is_null($zuname) && !is_string($zuname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zuname, true), gettype($zuname)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($zuname) && mb_strlen($zuname) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($zuname)), __LINE__);
        }
        $this->zuname = $zuname;
        return $this;
    }
    /**
     * Get vorname value
     * @return string|null
     */
    public function getVorname()
    {
        return $this->vorname;
    }
    /**
     * Set vorname value
     * @param string $vorname
     * @return \StructType\BeratungsdokumentationType
     */
    public function setVorname($vorname = null)
    {
        // validation for constraint: string
        if (!is_null($vorname) && !is_string($vorname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vorname, true), gettype($vorname)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($vorname) && mb_strlen($vorname) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($vorname)), __LINE__);
        }
        $this->vorname = $vorname;
        return $this;
    }
    /**
     * Get gisaZahl value
     * @return string|null
     */
    public function getGisaZahl()
    {
        return $this->gisaZahl;
    }
    /**
     * Set gisaZahl value
     * @param string $gisaZahl
     * @return \StructType\BeratungsdokumentationType
     */
    public function setGisaZahl($gisaZahl = null)
    {
        // validation for constraint: string
        if (!is_null($gisaZahl) && !is_string($gisaZahl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gisaZahl, true), gettype($gisaZahl)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($gisaZahl) && mb_strlen($gisaZahl) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($gisaZahl)), __LINE__);
        }
        $this->gisaZahl = $gisaZahl;
        return $this;
    }
    /**
     * Get vertriebsArt value
     * @return string|null
     */
    public function getVertriebsArt()
    {
        return $this->vertriebsArt;
    }
    /**
     * Set vertriebsArt value
     * @uses \EnumType\VertriebsArtType::valueIsValid()
     * @uses \EnumType\VertriebsArtType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vertriebsArt
     * @return \StructType\BeratungsdokumentationType
     */
    public function setVertriebsArt($vertriebsArt = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VertriebsArtType::valueIsValid($vertriebsArt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\VertriebsArtType', is_array($vertriebsArt) ? implode(', ', $vertriebsArt) : var_export($vertriebsArt, true), implode(', ', \EnumType\VertriebsArtType::getValidValues())), __LINE__);
        }
        $this->vertriebsArt = $vertriebsArt;
        return $this;
    }
    /**
     * Get versicherungsagentInDer value
     * @return string|null
     */
    public function getVersicherungsagentInDer()
    {
        return $this->versicherungsagentInDer;
    }
    /**
     * Set versicherungsagentInDer value
     * @param string $versicherungsagentInDer
     * @return \StructType\BeratungsdokumentationType
     */
    public function setVersicherungsagentInDer($versicherungsagentInDer = null)
    {
        // validation for constraint: string
        if (!is_null($versicherungsagentInDer) && !is_string($versicherungsagentInDer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($versicherungsagentInDer, true), gettype($versicherungsagentInDer)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($versicherungsagentInDer) && mb_strlen($versicherungsagentInDer) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($versicherungsagentInDer)), __LINE__);
        }
        $this->versicherungsagentInDer = $versicherungsagentInDer;
        return $this;
    }
    /**
     * Get freierText value
     * @return string|null
     */
    public function getFreierText()
    {
        return $this->freierText;
    }
    /**
     * Set freierText value
     * @param string $freierText
     * @return \StructType\BeratungsdokumentationType
     */
    public function setFreierText($freierText = null)
    {
        // validation for constraint: string
        if (!is_null($freierText) && !is_string($freierText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($freierText, true), gettype($freierText)), __LINE__);
        }
        $this->freierText = $freierText;
        return $this;
    }
    /**
     * Get datum value
     * @return string|null
     */
    public function getDatum()
    {
        return $this->datum;
    }
    /**
     * Set datum value
     * @param string $datum
     * @return \StructType\BeratungsdokumentationType
     */
    public function setDatum($datum = null)
    {
        // validation for constraint: string
        if (!is_null($datum) && !is_string($datum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datum, true), gettype($datum)), __LINE__);
        }
        $this->datum = $datum;
        return $this;
    }
    /**
     * Get dauer value
     * @return int|null
     */
    public function getDauer()
    {
        return $this->dauer;
    }
    /**
     * Set dauer value
     * @param int $dauer
     * @return \StructType\BeratungsdokumentationType
     */
    public function setDauer($dauer = null)
    {
        // validation for constraint: int
        if (!is_null($dauer) && !(is_int($dauer) || ctype_digit($dauer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dauer, true), gettype($dauer)), __LINE__);
        }
        $this->dauer = $dauer;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BeratungsdokumentationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
