<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for anmeldungKundenportalType StructType
 * @subpackage Structs
 */
class AnmeldungKundenportalType extends AbstractStructBase
{
    /**
     * The anmeldung
     * Meta information extracted from the WSDL
     * - documentation: Anmeldung zum Generali Kundenportal
     * @var string
     */
    public $anmeldung;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - documentation: E-Mail Adresse (=Benutzername)
     * - base: xs:string
     * - maxLength: 50
     * - minOccurs: 0
     * @var string
     */
    public $email;
    /**
     * The mobilephone
     * Meta information extracted from the WSDL
     * - documentation: Mobiltelefonnummer (für Zugangscode)
     * - base: xs:string
     * - maxLength: 30
     * - minOccurs: 0
     * @var string
     */
    public $mobilephone;
    /**
     * Constructor method for anmeldungKundenportalType
     * @uses AnmeldungKundenportalType::setAnmeldung()
     * @uses AnmeldungKundenportalType::setEmail()
     * @uses AnmeldungKundenportalType::setMobilephone()
     * @param string $anmeldung
     * @param string $email
     * @param string $mobilephone
     */
    public function __construct($anmeldung = null, $email = null, $mobilephone = null)
    {
        $this
            ->setAnmeldung($anmeldung)
            ->setEmail($email)
            ->setMobilephone($mobilephone);
    }
    /**
     * Get anmeldung value
     * @return string|null
     */
    public function getAnmeldung()
    {
        return $this->anmeldung;
    }
    /**
     * Set anmeldung value
     * @uses \EnumType\JaNeinType::valueIsValid()
     * @uses \EnumType\JaNeinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $anmeldung
     * @return \StructType\AnmeldungKundenportalType
     */
    public function setAnmeldung($anmeldung = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JaNeinType::valueIsValid($anmeldung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JaNeinType', is_array($anmeldung) ? implode(', ', $anmeldung) : var_export($anmeldung, true), implode(', ', \EnumType\JaNeinType::getValidValues())), __LINE__);
        }
        $this->anmeldung = $anmeldung;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\AnmeldungKundenportalType
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($email) && mb_strlen($email) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get mobilephone value
     * @return string|null
     */
    public function getMobilephone()
    {
        return $this->mobilephone;
    }
    /**
     * Set mobilephone value
     * @param string $mobilephone
     * @return \StructType\AnmeldungKundenportalType
     */
    public function setMobilephone($mobilephone = null)
    {
        // validation for constraint: string
        if (!is_null($mobilephone) && !is_string($mobilephone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobilephone, true), gettype($mobilephone)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($mobilephone) && mb_strlen($mobilephone) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($mobilephone)), __LINE__);
        }
        $this->mobilephone = $mobilephone;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AnmeldungKundenportalType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
