<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for all operations
 * @subpackage Services
 */
class Service extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getVersion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \StructType\GetVersionResponse|bool
     */
    public function getVersion()
    {
        try {
            $this->setResult($this->getSoapClient()->getVersion());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sendCustomer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendCustomerRequest $parameter
     * @return \StructType\SendCustomerResponse|bool
     */
    public function sendCustomer(\StructType\SendCustomerRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->sendCustomer($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createPartnerGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreatePartnerGroupRequest $parameter
     * @return \StructType\CreatePartnerGroupResponse|bool
     */
    public function createPartnerGroup(\StructType\CreatePartnerGroupRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->createPartnerGroup($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCustomer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCustomerRequest $parameter
     * @return \StructType\GetCustomerResponse|bool
     */
    public function getCustomer(\StructType\GetCustomerRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->getCustomer($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeCustomer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveCustomerRequest $parameter
     * @return \StructType\RemoveCustomerResponse|bool
     */
    public function removeCustomer(\StructType\RemoveCustomerRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->removeCustomer($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named newBusinessCase
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NewBusinessCaseRequest $parameter
     * @return \StructType\NewBusinessCaseResponse|bool
     */
    public function newBusinessCase(\StructType\NewBusinessCaseRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->newBusinessCase($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named newBusinessCaseIVOnline
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NewBusinessCaseIVOnlineRequest $parameter
     * @return \StructType\NewBusinessCaseIVOnlineResponse|bool
     */
    public function newBusinessCaseIVOnline(\StructType\NewBusinessCaseIVOnlineRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->newBusinessCaseIVOnline($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBusinessCases
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBusinessCasesRequest $parameter
     * @return \StructType\GetBusinessCasesResponse|bool
     */
    public function getBusinessCases(\StructType\GetBusinessCasesRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->getBusinessCases($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBusinessCase
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBusinessCaseRequest $parameter
     * @return \StructType\GetBusinessCaseResponse|bool
     */
    public function getBusinessCase(\StructType\GetBusinessCaseRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->getBusinessCase($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getIDFromNumbergenerator
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLatestIDFromNumbergeneratorRequest $parameter
     * @return \StructType\GetLatestIDFromNumbergeneratorResponse|bool
     */
    public function getIDFromNumbergenerator(\StructType\GetLatestIDFromNumbergeneratorRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->getIDFromNumbergenerator($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named newBusinessCaseSMOnline
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NewBusinessCaseSMOnlineRequest $parameter
     * @return \StructType\NewBusinessCaseSMOnlineResponse|bool
     */
    public function newBusinessCaseSMOnline(\StructType\NewBusinessCaseSMOnlineRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->newBusinessCaseSMOnline($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBusinessCaseTypes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBusinessCaseTypesRequest $parameter
     * @return \StructType\GetBusinessCaseTypesResponse|bool
     */
    public function getBusinessCaseTypes(\StructType\GetBusinessCaseTypesRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->getBusinessCaseTypes($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getZeusdaten
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetZeusDatenRequest $parameter
     * @return \StructType\GetZeusDatenResponse|bool
     */
    public function getZeusdaten(\StructType\GetZeusDatenRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->getZeusdaten($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named hasZeusdaten
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\HasZeusDatenRequest $parameter
     * @return \StructType\HasZeusDatenResponse|bool
     */
    public function hasZeusdaten(\StructType\HasZeusDatenRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->hasZeusdaten($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getZeusdatenGreco
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetZeusDatenGrecoRequest $parameter
     * @return \StructType\GetZeusDatenGrecoResponse|bool
     */
    public function getZeusdatenGreco(\StructType\GetZeusDatenGrecoRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->getZeusdatenGreco($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVinkulierungsdaten
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVinkulierungsdatenRequest $parameter
     * @return \StructType\GetVinkulierungsdatenResponse|bool
     */
    public function getVinkulierungsdaten(\StructType\GetVinkulierungsdatenRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->getVinkulierungsdaten($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sendMessageToMQ
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendMessageToMQRequest $parameter
     * @return \StructType\SendMessageToMQResponse|bool
     */
    public function sendMessageToMQ(\StructType\SendMessageToMQRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->sendMessageToMQ($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named transferSignedDocument
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TransferSignedDocumentRequest $parameter
     * @return \StructType\TransferSignedDocumentResponse|bool
     */
    public function transferSignedDocument(\StructType\TransferSignedDocumentRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->transferSignedDocument($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named newBusinessCasePrefilled
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NewBusinessCasePrefilledRequest $parameter
     * @return \StructType\NewBusinessCasePrefilledResponse|bool
     */
    public function newBusinessCasePrefilled(\StructType\NewBusinessCasePrefilledRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->newBusinessCasePrefilled($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBusinessCaseHistory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBusinessCaseHistoryRequest $parameter
     * @return \StructType\GetBusinessCaseHistoryResponse|bool
     */
    public function getBusinessCaseHistory(\StructType\GetBusinessCaseHistoryRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->getBusinessCaseHistory($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named browseMessageFromMQ
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\BrowseMessageFromMQRequest $parameter
     * @return \StructType\BrowseMessageFromMQResponse|bool
     */
    public function browseMessageFromMQ(\StructType\BrowseMessageFromMQRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->browseMessageFromMQ($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named newBusinessCaseCalculateAndSave
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NewBusinessCaseCalculateAndSaveRequest $parameter
     * @return \StructType\NewBusinessCaseCalculateAndSaveResponse|bool
     */
    public function newBusinessCaseCalculateAndSave(\StructType\NewBusinessCaseCalculateAndSaveRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->newBusinessCaseCalculateAndSave($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named calculatePremiumOnly
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CalculatePremiumOnlyRequest $parameter
     * @return \StructType\CalculatePremiumOnlyResponse|bool
     */
    public function calculatePremiumOnly(\StructType\CalculatePremiumOnlyRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->calculatePremiumOnly($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getChoiceLists
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetChoiceListsRequest $parameter
     * @return \StructType\GetChoiceListsResponse|bool
     */
    public function getChoiceLists(\StructType\GetChoiceListsRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->getChoiceLists($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named newBusinessCaseToPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NewBusinessCaseToPolicyRequest $parameter
     * @return \StructType\NewBusinessCaseToPolicyResponse|bool
     */
    public function newBusinessCaseToPolicy(\StructType\NewBusinessCaseToPolicyRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->newBusinessCaseToPolicy($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addCustomerToBusinessCase
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddCustomerToBusinessCaseRequest $parameter
     * @return \StructType\AddCustomerToBusinessCaseResponse|bool
     */
    public function addCustomerToBusinessCase(\StructType\AddCustomerToBusinessCaseRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->addCustomerToBusinessCase($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSignableDocuments
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSignableDocumentsRequest $parameter
     * @return \StructType\GetSignableDocumentsResponse|bool
     */
    public function getSignableDocuments(\StructType\GetSignableDocumentsRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->getSignableDocuments($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named signDocuments
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SignDocumentsRequest $parameter
     * @return \StructType\SignDocumentsResponse|bool
     */
    public function signDocuments(\StructType\SignDocumentsRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->signDocuments($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAreDocumentsSigned
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAreDocumentsSignedRequest $parameter
     * @return \StructType\GetAreDocumentsSignedResponse|bool
     */
    public function getAreDocumentsSigned(\StructType\GetAreDocumentsSignedRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->getAreDocumentsSigned($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named resetSignDocuments
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ResetSignDocumentsRequest $parameter
     * @return \StructType\ResetSignDocumentsResponse|bool
     */
    public function resetSignDocuments(\StructType\ResetSignDocumentsRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->resetSignDocuments($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSignedDocuments
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSignedDocumentsRequest $parameter
     * @return \StructType\GetSignedDocumentsResponse|bool
     */
    public function getSignedDocuments(\StructType\GetSignedDocumentsRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->getSignedDocuments($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createOrUpdatePartnerContact
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateOrUpdatePartnerContactRequest $parameter
     * @return \StructType\CreateOrUpdatePartnerContactResponse|bool
     */
    public function createOrUpdatePartnerContact(\StructType\CreateOrUpdatePartnerContactRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->createOrUpdatePartnerContact($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named orderGreenOrServiceCard
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OrderGreenOrServiceCardRequest $parameter
     * @return \StructType\OrderGreenOrServiceCardResponse|bool
     */
    public function orderGreenOrServiceCard(\StructType\OrderGreenOrServiceCardRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->orderGreenOrServiceCard($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getHoraZone
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetHoraZoneRequest $parameter
     * @return \StructType\GetHoraZoneResponse|bool
     */
    public function getHoraZone(\StructType\GetHoraZoneRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->getHoraZone($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBusinessCollectionData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBusinessCollectionDataRequest $parameter
     * @return \StructType\GetBusinessCollectionDataResponse|bool
     */
    public function getBusinessCollectionData(\StructType\GetBusinessCollectionDataRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->getBusinessCollectionData($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBusinessCaseReadonlyLink
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBusinessCaseReadonlyLinkRequest $parameter
     * @return \StructType\GetBusinessCaseReadonlyLinkResponse|bool
     */
    public function getBusinessCaseReadonlyLink(\StructType\GetBusinessCaseReadonlyLinkRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->getBusinessCaseReadonlyLink($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named login
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\LoginRequest $parameter
     * @return \StructType\LoginResponse|bool
     */
    public function login(\StructType\LoginRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->login($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named kundenportalClaimAdviceInitial
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\KundenportalClaimAdviceInitialRequest $parameter
     * @return \StructType\KundenportalClaimAdviceInitialResponse|bool
     */
    public function kundenportalClaimAdviceInitial(\StructType\KundenportalClaimAdviceInitialRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->kundenportalClaimAdviceInitial($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named kundenportalClaimAdvice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\KundenportalClaimAdviceRequest $parameter
     * @return \StructType\KundenportalClaimAdviceResponse|bool
     */
    public function kundenportalClaimAdvice(\StructType\KundenportalClaimAdviceRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->kundenportalClaimAdvice($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named kundenportalVerzeichnisse
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\KundenportalVerzeichnisseRequest $parameter
     * @return \StructType\KundenportalVerzeichnisseResponse|bool
     */
    public function kundenportalVerzeichnisse(\StructType\KundenportalVerzeichnisseRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->kundenportalVerzeichnisse($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named kundenportalSchliessfach
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\KundenportalSchliessfachRequest $parameter
     * @return \StructType\KundenportalSchliessfachResponse|bool
     */
    public function kundenportalSchliessfach(\StructType\KundenportalSchliessfachRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->kundenportalSchliessfach($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * kundenportalAddUpdateOrDeleteSchliessfachEintrag
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\KundenportalAddUpdateOrDeleteSchliessfachEintragRequest $parameter
     * @return \StructType\KundenportalAddUpdateOrDeleteSchliessfachEintragResponse|bool
     */
    public function kundenportalAddUpdateOrDeleteSchliessfachEintrag(\StructType\KundenportalAddUpdateOrDeleteSchliessfachEintragRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->kundenportalAddUpdateOrDeleteSchliessfachEintrag($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * kundenportalCreateDeleteSaveOrUpdateDocument
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\KundenportalCreateDeleteSaveOrUpdateDocumentRequest $parameter
     * @return \StructType\KundenportalCreateDeleteSaveOrUpdateDocumentResponse|bool
     */
    public function kundenportalCreateDeleteSaveOrUpdateDocument(\StructType\KundenportalCreateDeleteSaveOrUpdateDocumentRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->kundenportalCreateDeleteSaveOrUpdateDocument($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named kundenportalGetDocument
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\KundenportalGetDocumentRequest $parameter
     * @return \StructType\KundenportalGetDocumentResponse|bool
     */
    public function kundenportalGetDocument(\StructType\KundenportalGetDocumentRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->kundenportalGetDocument($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named kundenportalData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\KundenportalDataRequest $parameter
     * @return \StructType\KundenportalDataResponse|bool
     */
    public function kundenportalData(\StructType\KundenportalDataRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->kundenportalData($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named kundenportalRegister
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\KundenportalRegisterRequest $parameter
     * @return \StructType\KundenportalRegisterResponse|bool
     */
    public function kundenportalRegister(\StructType\KundenportalRegisterRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->kundenportalRegister($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named kundenportalResendActivationLink
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\KundenportalResendActivationLinkRequest $parameter
     * @return \StructType\KundenportalResendActivationLinkResponse|bool
     */
    public function kundenportalResendActivationLink(\StructType\KundenportalResendActivationLinkRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->kundenportalResendActivationLink($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named kundenportalActivation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\KundenportalActivationRequest $parameter
     * @return \StructType\KundenportalActivationResponse|bool
     */
    public function kundenportalActivation(\StructType\KundenportalActivationRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->kundenportalActivation($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named kundenportalNewsletterEmails
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\KundenportalNewsletterEmailsRequest $parameter
     * @return \StructType\KundenportalNewsletterEmailsResponse|bool
     */
    public function kundenportalNewsletterEmails(\StructType\KundenportalNewsletterEmailsRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->kundenportalNewsletterEmails($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named kundenportalPushNachricht
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\KundenportalPushNachrichtRequest $parameter
     * @return \StructType\KundenportalPushNachrichtResponse|bool
     */
    public function kundenportalPushNachricht(\StructType\KundenportalPushNachrichtRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->kundenportalPushNachricht($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named mapCustomerToPAPartner
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MapCustomerToPAPartnerRequest $parameter
     * @return \StructType\MapCustomerToPAPartnerResponse|bool
     */
    public function mapCustomerToPAPartner(\StructType\MapCustomerToPAPartnerRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->mapCustomerToPAPartner($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getArcImage
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetArcImageRequest $parameter
     * @return \StructType\GetArcImageResponse|bool
     */
    public function getArcImage(\StructType\GetArcImageRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->getArcImage($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getArcImageInfos
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetArcImageInfosRequest $parameter
     * @return \StructType\GetArcImageInfosResponse|bool
     */
    public function getArcImageInfos(\StructType\GetArcImageInfosRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->getArcImageInfos($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named searchContract
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SearchContractRequest $parameter
     * @return \StructType\SearchContractResponse|bool
     */
    public function searchContract(\StructType\SearchContractRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->searchContract($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named searchContractList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SearchContractListRequest $parameter
     * @return \StructType\SearchContractListResponse|bool
     */
    public function searchContractList(\StructType\SearchContractListRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->searchContractList($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named itChat
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ItChatRequest $parameter
     * @return \StructType\ItChatResponse|bool
     */
    public function itChat(\StructType\ItChatRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->itChat($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getContract
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetContractRequest $parameter
     * @return \StructType\GetContractResponse|bool
     */
    public function getContract(\StructType\GetContractRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->getContract($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBerechnungswerte
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBerechnungswerteRequest $parameter
     * @return \StructType\GetBerechnungswerteResponse|bool
     */
    public function getBerechnungswerte(\StructType\GetBerechnungswerteRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->getBerechnungswerte($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getContracts
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetContractsRequest $parameter
     * @return \StructType\GetContractsResponse|bool
     */
    public function getContracts(\StructType\GetContractsRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->getContracts($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addStateHistoryEntry
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddStateHistoryEntryRequest $parameter
     * @return \StructType\AddStateHistoryEntryResponse|bool
     */
    public function addStateHistoryEntry(\StructType\AddStateHistoryEntryRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->addStateHistoryEntry($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named transferBusinessCase
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TransferBusinessCaseRequest $parameter
     * @return \StructType\TransferBusinessCaseResponse|bool
     */
    public function transferBusinessCase(\StructType\TransferBusinessCaseRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->transferBusinessCase($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named newBusinessCaseFromXml
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NewBusinessCaseFromXmlRequest $parameter
     * @return \StructType\NewBusinessCaseFromXmlResponse|bool
     */
    public function newBusinessCaseFromXml(\StructType\NewBusinessCaseFromXmlRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->newBusinessCaseFromXml($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named searchClaim
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SearchClaimRequest $parameter
     * @return \StructType\SearchClaimResponse|bool
     */
    public function searchClaim(\StructType\SearchClaimRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->searchClaim($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named transferBusinessCases
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TransferBusinessCasesRequest $parameter
     * @return \StructType\TransferBusinessCasesResponse|bool
     */
    public function transferBusinessCases(\StructType\TransferBusinessCasesRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->transferBusinessCases($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named newBusinessCaseSMOnlineTransfer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NewBusinessCaseSMOnlineTransferRequest $parameter
     * @return \StructType\NewBusinessCaseSMOnlineTransferResponse|bool
     */
    public function newBusinessCaseSMOnlineTransfer(\StructType\NewBusinessCaseSMOnlineTransferRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->newBusinessCaseSMOnlineTransfer($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named newBusinessCaseStorno
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NewBusinessCaseStornoRequest $parameter
     * @return \StructType\NewBusinessCaseStornoResponse|bool
     */
    public function newBusinessCaseStorno(\StructType\NewBusinessCaseStornoRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->newBusinessCaseStorno($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named newBusinessCaseInkassoAenderung
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NewBusinessCaseInkassoAenderungRequest $parameter
     * @return \StructType\NewBusinessCaseInkassoAenderungResponse|bool
     */
    public function newBusinessCaseInkassoAenderung(\StructType\NewBusinessCaseInkassoAenderungRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->newBusinessCaseInkassoAenderung($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * newBusinessCaseVersicherungsBestaetigung
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NewBusinessCaseVersicherungsBestaetigungRequest $parameter
     * @return \StructType\NewBusinessCaseVersicherungsBestaetigungResponse|bool
     */
    public function newBusinessCaseVersicherungsBestaetigung(\StructType\NewBusinessCaseVersicherungsBestaetigungRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->newBusinessCaseVersicherungsBestaetigung($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named searchClaimList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SearchClaimListRequest $parameter
     * @return \StructType\SearchClaimListResponse|bool
     */
    public function searchClaimList(\StructType\SearchClaimListRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->searchClaimList($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named registerUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RegisterUserRequest $parameter
     * @return \StructType\RegisterUserResponse|bool
     */
    public function registerUser(\StructType\RegisterUserRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->registerUser($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named resetUserPassword
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ResetUserPasswordRequest $parameter
     * @return \StructType\ResetUserPasswordResponse|bool
     */
    public function resetUserPassword(\StructType\ResetUserPasswordRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->resetUserPassword($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named resetUserPasswordQuestionAnswer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ResetUserPasswordQuestionAnswerRequest $parameter
     * @return \StructType\ResetUserPasswordQuestionAnswerResponse|bool
     */
    public function resetUserPasswordQuestionAnswer(\StructType\ResetUserPasswordQuestionAnswerRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->resetUserPasswordQuestionAnswer($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getUserData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetUserDataRequest $parameter
     * @return \StructType\GetUserDataResponse|bool
     */
    public function getUserData(\StructType\GetUserDataRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->getUserData($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deleteUserDataTokens
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteUserDataTokensRequest $parameter
     * @return \StructType\DeleteUserDataTokensResponse|bool
     */
    public function deleteUserDataTokens(\StructType\DeleteUserDataTokensRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->deleteUserDataTokens($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named isValidSchadensnummerNachname
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IsValidSchadensnummerNachnameRequest $parameter
     * @return \StructType\IsValidSchadensnummerNachnameResponse|bool
     */
    public function isValidSchadensnummerNachname(\StructType\IsValidSchadensnummerNachnameRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->isValidSchadensnummerNachname($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named kundenportalJwtInvalidateService
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\KundenportalJwtInvalidateServiceRequest $parameter
     * @return \StructType\KundenportalJwtInvalidateServiceResponse|bool
     */
    public function kundenportalJwtInvalidateService(\StructType\KundenportalJwtInvalidateServiceRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->kundenportalJwtInvalidateService($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * kundenportalBenutzerPasswortAendern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\KundenportalBenutzerPasswortAendernRequest $parameter
     * @return \StructType\KundenportalBenutzerPasswortAendernResponse|bool
     */
    public function kundenportalBenutzerPasswortAendern(\StructType\KundenportalBenutzerPasswortAendernRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->kundenportalBenutzerPasswortAendern($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named kundenportalBenutzernameAendern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\KundenportalBenutzernameAendernRequest $parameter
     * @return \StructType\KundenportalBenutzernameAendernResponse|bool
     */
    public function kundenportalBenutzernameAendern(\StructType\KundenportalBenutzernameAendernRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->kundenportalBenutzernameAendern($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named resetUserNewsletter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ResetUserNewsletterRequest $parameter
     * @return \StructType\ResetUserNewsletterResponse|bool
     */
    public function resetUserNewsletter(\StructType\ResetUserNewsletterRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->resetUserNewsletter($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named kundenportalMarkMessageAsRead
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\KundenportalMarkMessageAsReadRequest $parameters
     * @return \StructType\KundenportalMarkMessageAsReadResponse|bool
     */
    public function kundenportalMarkMessageAsRead(\StructType\KundenportalMarkMessageAsReadRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->kundenportalMarkMessageAsRead($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named kundenportalAntragZustimmen
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\KundenportalAntragZustimmenRequest $parameters
     * @return \StructType\KundenportalAntragZustimmenResponse|bool
     */
    public function kundenportalAntragZustimmen(\StructType\KundenportalAntragZustimmenRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->kundenportalAntragZustimmen($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named kundenportalSendMessage
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\KundenportalSendMessageRequest $parameters
     * @return \StructType\KundenportalSendMessageResponse|bool
     */
    public function kundenportalSendMessage(\StructType\KundenportalSendMessageRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->kundenportalSendMessage($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named kundenportalSetAdvisor
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\KundenportalSetAdvisorRequest $parameters
     * @return \StructType\KundenportalSetAdvisorResponse|bool
     */
    public function kundenportalSetAdvisor(\StructType\KundenportalSetAdvisorRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->kundenportalSetAdvisor($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AddCustomerToBusinessCaseResponse|\StructType\AddStateHistoryEntryResponse|\StructType\BrowseMessageFromMQResponse|\StructType\CalculatePremiumOnlyResponse|\StructType\CreateOrUpdatePartnerContactResponse|\StructType\CreatePartnerGroupResponse|\StructType\DeleteUserDataTokensResponse|\StructType\GetArcImageInfosResponse|\StructType\GetArcImageResponse|\StructType\GetAreDocumentsSignedResponse|\StructType\GetBerechnungswerteResponse|\StructType\GetBusinessCaseHistoryResponse|\StructType\GetBusinessCaseReadonlyLinkResponse|\StructType\GetBusinessCaseResponse|\StructType\GetBusinessCasesResponse|\StructType\GetBusinessCaseTypesResponse|\StructType\GetBusinessCollectionDataResponse|\StructType\GetChoiceListsResponse|\StructType\GetContractResponse|\StructType\GetContractsResponse|\StructType\GetCustomerResponse|\StructType\GetHoraZoneResponse|\StructType\GetLatestIDFromNumbergeneratorResponse|\StructType\GetSignableDocumentsResponse|\StructType\GetSignedDocumentsResponse|\StructType\GetUserDataResponse|\StructType\GetVersionResponse|\StructType\GetVinkulierungsdatenResponse|\StructType\GetZeusDatenGrecoResponse|\StructType\GetZeusDatenResponse|\StructType\HasZeusDatenResponse|\StructType\IsValidSchadensnummerNachnameResponse|\StructType\ItChatResponse|\StructType\KundenportalActivationResponse|\StructType\KundenportalAddUpdateOrDeleteSchliessfachEintragResponse|\StructType\KundenportalAntragZustimmenResponse|\StructType\KundenportalBenutzernameAendernResponse|\StructType\KundenportalBenutzerPasswortAendernResponse|\StructType\KundenportalClaimAdviceInitialResponse|\StructType\KundenportalClaimAdviceResponse|\StructType\KundenportalCreateDeleteSaveOrUpdateDocumentResponse|\StructType\KundenportalDataResponse|\StructType\KundenportalGetDocumentResponse|\StructType\KundenportalJwtInvalidateServiceResponse|\StructType\KundenportalMarkMessageAsReadResponse|\StructType\KundenportalNewsletterEmailsResponse|\StructType\KundenportalPushNachrichtResponse|\StructType\KundenportalRegisterResponse|\StructType\KundenportalResendActivationLinkResponse|\StructType\KundenportalSchliessfachResponse|\StructType\KundenportalSendMessageResponse|\StructType\KundenportalSetAdvisorResponse|\StructType\KundenportalVerzeichnisseResponse|\StructType\LoginResponse|\StructType\MapCustomerToPAPartnerResponse|\StructType\NewBusinessCaseCalculateAndSaveResponse|\StructType\NewBusinessCaseFromXmlResponse|\StructType\NewBusinessCaseInkassoAenderungResponse|\StructType\NewBusinessCaseIVOnlineResponse|\StructType\NewBusinessCasePrefilledResponse|\StructType\NewBusinessCaseResponse|\StructType\NewBusinessCaseSMOnlineResponse|\StructType\NewBusinessCaseSMOnlineTransferResponse|\StructType\NewBusinessCaseStornoResponse|\StructType\NewBusinessCaseToPolicyResponse|\StructType\NewBusinessCaseVersicherungsBestaetigungResponse|\StructType\OrderGreenOrServiceCardResponse|\StructType\RegisterUserResponse|\StructType\RemoveCustomerResponse|\StructType\ResetSignDocumentsResponse|\StructType\ResetUserNewsletterResponse|\StructType\ResetUserPasswordQuestionAnswerResponse|\StructType\ResetUserPasswordResponse|\StructType\SearchClaimListResponse|\StructType\SearchClaimResponse|\StructType\SearchContractListResponse|\StructType\SearchContractResponse|\StructType\SendCustomerResponse|\StructType\SendMessageToMQResponse|\StructType\SignDocumentsResponse|\StructType\TransferBusinessCaseResponse|\StructType\TransferBusinessCasesResponse|\StructType\TransferSignedDocumentResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
