<?php

namespace EnumType;

/**
 * This class stands for vertriebsArtType EnumType
 * @subpackage Enumerations
 */
class VertriebsArtType
{
    /**
     * Constant for value 'Versicherungsmakler'
     * @return string 'Versicherungsmakler'
     */
    const ENUM_VALUE_0 = 'Versicherungsmakler';
    /**
     * Constant for value 'Mehrfachagent'
     * @return string 'Mehrfachagent'
     */
    const ENUM_VALUE_1 = 'Mehrfachagent';
    /**
     * Constant for value 'Eigener Vertrieb'
     * @return string 'Eigener Vertrieb'
     */
    const ENUM_VALUE_2 = 'Eigener Vertrieb';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::ENUM_VALUE_0
     * @uses self::ENUM_VALUE_1
     * @uses self::ENUM_VALUE_2
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::ENUM_VALUE_0,
            self::ENUM_VALUE_1,
            self::ENUM_VALUE_2,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
